/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities;

import com.Polarice3.Goety.api.items.magic.ITotem;
import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.blocks.SoulAbsorberBlock;
import com.Polarice3.Goety.common.blocks.entities.ArcaBlockEntity;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntities;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntity;
import com.Polarice3.Goety.common.crafting.ModRecipeSerializer;
import com.Polarice3.Goety.common.crafting.SoulAbsorberRecipes;
import com.Polarice3.Goety.utils.SEHelper;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SoulAbsorberBlockEntity
extends ModBlockEntity
implements Clearable,
WorldlyContainer {
    private static final int[] SLOTS = new int[]{0};
    private ItemStack itemStack = ItemStack.f_41583_;
    private int cookingProgress;
    private int cookingTime;

    public SoulAbsorberBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.SOUL_ABSORBER.get(), blockPos, blockState);
    }

    public void tick() {
        boolean flag;
        boolean bl = flag = this.getArcaOwner() != null;
        assert (this.f_58857_ != null);
        if (!this.f_58857_.f_46443_) {
            if (flag) {
                if (!this.itemStack.m_41619_()) {
                    this.makeWorkParticles();
                }
                this.work();
            } else if (this.itemStack != ItemStack.f_41583_ && this.cookingProgress > 0) {
                this.cookingProgress = Mth.m_14045_((int)(this.cookingProgress - 2), (int)0, (int)this.cookingTime);
            }
        }
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)SoulAbsorberBlock.LIT, (Comparable)Boolean.valueOf(this.getArcaOwner() != null)), 3);
    }

    private void work() {
        if (!this.itemStack.m_41619_()) {
            assert (this.f_58857_ != null);
            if (this.itemStack.m_41720_() instanceof ITotem) {
                if (ITotem.currentSouls(this.itemStack) != 0) {
                    ++this.cookingProgress;
                    if (this.getArcaOwner() != null) {
                        SEHelper.increaseSouls(this.getArcaOwner(), 1);
                        ITotem.decreaseSouls(this.itemStack, 1);
                    }
                } else {
                    this.itemStack.m_41774_(1);
                    this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11936_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.finishParticles();
                    this.markUpdated();
                    this.cookingProgress = 0;
                }
            } else {
                SimpleContainer iinventory = new SimpleContainer(new ItemStack[]{this.itemStack});
                int soulIncrease = this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipeSerializer.SOUL_ABSORBER.get(), (Container)iinventory, this.f_58857_).map(SoulAbsorberRecipes::getSoulIncrease).orElse(25);
                if (soulIncrease > 0) {
                    ++this.cookingProgress;
                }
                if (this.cookingProgress >= this.cookingTime) {
                    if (this.getArcaOwner() != null) {
                        SEHelper.increaseSouls(this.getArcaOwner(), soulIncrease);
                    }
                    this.itemStack.m_41774_(1);
                    this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11936_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.finishParticles();
                    this.markUpdated();
                    this.cookingProgress = 0;
                }
            }
        }
    }

    public boolean placeItem(ItemStack pStack, int pCookTime) {
        if (this.itemStack.m_41619_()) {
            this.cookingTime = pCookTime;
            this.cookingProgress = 0;
            this.itemStack = pStack.m_41620_(1);
            assert (this.f_58857_ != null);
            this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11862_, SoundSource.BLOCKS, 1.0f, 0.5f);
            this.markUpdated();
            return true;
        }
        return false;
    }

    public boolean m_7983_() {
        return this.itemStack.m_41619_();
    }

    public int m_6643_() {
        return 1;
    }

    public ItemStack m_8020_(int pIndex) {
        return this.itemStack;
    }

    public ItemStack m_7407_(int pIndex, int pCount) {
        return ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int pIndex) {
        return ItemStack.f_41583_;
    }

    public void m_6836_(int pIndex, ItemStack pStack) {
        Optional<SoulAbsorberRecipes> optional = this.getRecipes(pStack);
        optional.ifPresent(soulAbsorberRecipes -> this.placeItem(pStack, soulAbsorberRecipes.getCookingTime()));
    }

    public boolean m_6542_(Player pPlayer) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return pPlayer.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    private void finishParticles() {
        BlockPos blockpos = this.m_58899_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            ServerLevel serverWorld = (ServerLevel)this.f_58857_;
            serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.5, (double)blockpos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            for (int p = 0; p < 6; ++p) {
                double d0 = (double)blockpos.m_123341_() + serverWorld.f_46441_.m_188500_();
                double d1 = (double)blockpos.m_123342_() + serverWorld.f_46441_.m_188500_();
                double d2 = (double)blockpos.m_123343_() + serverWorld.f_46441_.m_188500_();
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123745_, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private void makeWorkParticles() {
        long t;
        BlockPos blockpos = this.m_58899_();
        ServerLevel serverLevel = (ServerLevel)this.f_58857_;
        if (serverLevel != null && (t = serverLevel.m_46467_()) % 20L == 0L) {
            for (int p = 0; p < 6; ++p) {
                double d0 = (double)blockpos.m_123341_() + serverLevel.f_46441_.m_188500_();
                double d1 = (double)blockpos.m_123342_() + serverLevel.f_46441_.m_188500_();
                double d2 = (double)blockpos.m_123343_() + serverLevel.f_46441_.m_188500_();
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123809_, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void readNetwork(CompoundTag compoundNBT) {
        this.itemStack = ItemStack.m_41712_((CompoundTag)compoundNBT.m_128469_("Item"));
        this.cookingProgress = compoundNBT.m_128451_("CookingTime");
        this.cookingTime = compoundNBT.m_128451_("CookingTotalTime");
    }

    @Override
    public CompoundTag writeNetwork(CompoundTag pCompound) {
        this.saveMetadataAndItems(pCompound);
        pCompound.m_128405_("CookingTime", this.cookingProgress);
        pCompound.m_128405_("CookingTotalTime", this.cookingTime);
        return pCompound;
    }

    private CompoundTag saveMetadataAndItems(CompoundTag pCompound) {
        pCompound.m_128365_("Item", (Tag)this.itemStack.m_41739_(new CompoundTag()));
        return pCompound;
    }

    private boolean checkArca() {
        assert (this.f_58857_ != null);
        return this.f_58857_.m_8055_(new BlockPos(this.m_58899_().m_123341_(), this.m_58899_().m_123342_() - 1, this.m_58899_().m_123343_())).m_60713_((Block)ModBlocks.ARCA_BLOCK.get());
    }

    private Player getArcaOwner() {
        BlockPos blockPos;
        ArcaBlockEntity arcaTileEntity;
        if (this.checkArca() && (arcaTileEntity = (ArcaBlockEntity)this.f_58857_.m_7702_(blockPos = new BlockPos(this.m_58899_().m_123341_(), this.m_58899_().m_123342_() - 1, this.m_58899_().m_123343_()))) != null && arcaTileEntity.getPlayer() != null) {
            return arcaTileEntity.getPlayer();
        }
        return null;
    }

    public Optional<SoulAbsorberRecipes> getRecipes(ItemStack pStack) {
        return this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipeSerializer.SOUL_ABSORBER.get(), (Container)new SimpleContainer(new ItemStack[]{pStack}), this.f_58857_);
    }

    public void m_6211_() {
        this.itemStack.m_41774_(1);
    }

    public int[] m_7071_(Direction pSide) {
        return SLOTS;
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        Optional<SoulAbsorberRecipes> optional = this.getRecipes(pItemStack);
        if (!optional.isPresent()) {
            return false;
        }
        if (this.getArcaOwner() == null) {
            return false;
        }
        assert (this.f_58857_ != null);
        return !this.f_58857_.f_46443_ && this.placeItem(pItemStack, optional.get().getCookingTime());
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return false;
    }
}

