/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities;

import com.Polarice3.Goety.api.blocks.IEnchantedBlock;
import com.Polarice3.Goety.client.particles.SculkBubbleParticleOption;
import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.blocks.SculkConverterBlock;
import com.Polarice3.Goety.common.blocks.SculkRelayBlock;
import com.Polarice3.Goety.common.blocks.entities.CursedCageBlockEntity;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntities;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntity;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.utils.BlockFinder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SculkChargeParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;

public class SculkConverterBlockEntity
extends ModBlockEntity
implements IEnchantedBlock {
    private final SculkSpreader sculkSpreader = SculkSpreader.m_222254_();
    private BlockPos nearbyRelay;
    private CursedCageBlockEntity cursedCageTile;
    protected final Object2IntMap<Enchantment> enchantments = new Object2IntOpenHashMap();

    public SculkConverterBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)ModBlockEntities.SCULK_CONVERTER.get(), p_155229_, p_155230_);
    }

    @Override
    public Object2IntMap<Enchantment> getEnchantments() {
        return this.enchantments;
    }

    public void activate() {
        Level level;
        if (this.f_58857_ != null && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.checkCage()) {
                int spread = this.enchantments.getOrDefault(ModEnchantments.POTENCY.get(), 0) + 1;
                int cost = 5 * spread;
                if (this.getCursedCageTile().getSouls() > cost) {
                    this.getRelay();
                    this.getCursedCageTile().decreaseSouls(cost);
                    int x = serverLevel.m_213780_().m_216339_(-1, 1);
                    int y = (int)BlockFinder.moveBlockDownToGround(this.f_58857_, this.m_58899_());
                    int z = serverLevel.m_213780_().m_216339_(-1, 1);
                    BlockPos blockPos = new BlockPos(this.m_58899_().m_123341_() + x, y, this.m_58899_().m_123343_() + z);
                    if (this.nearbyRelay != null) {
                        y = (int)BlockFinder.moveBlockDownToGround(this.f_58857_, this.nearbyRelay);
                        blockPos = new BlockPos(this.nearbyRelay.m_123341_() + x, y, this.nearbyRelay.m_123343_() + z);
                    }
                    this.sculkSpreader.m_222266_(blockPos, spread);
                    SculkConverterBlock.bloom(serverLevel, this.m_58899_(), this.m_58900_(), serverLevel.f_46441_);
                }
            }
        }
    }

    public void findRelay() {
        if (this.f_58857_ != null) {
            if (this.nearbyRelay != null) {
                BlockState blockState = this.f_58857_.m_8055_(this.nearbyRelay);
                if (!(blockState.m_60734_() instanceof SculkRelayBlock)) {
                    this.searchRelay();
                } else {
                    Level level = this.f_58857_;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        Vec3 vec3 = Vec3.m_82512_((Vec3i)this.m_58899_());
                        serverLevel.m_8767_((ParticleOptions)new SculkBubbleParticleOption((PositionSource)new BlockPositionSource(this.nearbyRelay), (int)vec3.m_82554_(Vec3.m_82512_((Vec3i)this.nearbyRelay)) * 2), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            } else {
                this.searchRelay();
            }
        }
    }

    public void getRelay() {
        if (this.f_58857_ != null) {
            if (this.nearbyRelay != null) {
                BlockState blockState = this.f_58857_.m_8055_(this.nearbyRelay);
                if (!(blockState.m_60734_() instanceof SculkRelayBlock)) {
                    this.searchRelay();
                } else {
                    Level level = this.f_58857_;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)new SculkChargeParticleOptions(0.0f), (double)this.nearbyRelay.m_123341_() + 0.5, (double)this.nearbyRelay.m_123342_() + 1.15, (double)this.nearbyRelay.m_123343_() + 0.5, 2, 0.2, 0.0, 0.2, 0.0);
                        serverLevel.m_8767_((ParticleOptions)DustColorTransitionOptions.f_175752_, (double)this.nearbyRelay.m_123341_() + 0.5, (double)this.nearbyRelay.m_123342_() + 1.15, (double)this.nearbyRelay.m_123343_() + 0.5, 0, 0.0, (double)serverLevel.f_46441_.m_188501_() * 0.04, 0.0, (double)0.9f);
                        Vec3 vec3 = Vec3.m_82512_((Vec3i)this.m_58899_());
                        int spread = this.enchantments.getOrDefault(ModEnchantments.POTENCY.get(), 0) + 1;
                        for (int i = 0; i < spread; ++i) {
                            serverLevel.m_8767_((ParticleOptions)new SculkBubbleParticleOption((PositionSource)new BlockPositionSource(this.nearbyRelay), (int)vec3.m_82554_(Vec3.m_82512_((Vec3i)this.nearbyRelay)) * (serverLevel.f_46441_.m_188503_(4) + 1)), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 2, 0.2, 0.0, 0.2, 0.0);
                        }
                    }
                }
            } else {
                this.searchRelay();
            }
        }
    }

    private void searchRelay() {
        if (this.f_58857_ != null) {
            for (int i = -16; i <= 16; ++i) {
                for (int j = -8; j <= 8; ++j) {
                    for (int k = -16; k <= 16; ++k) {
                        BlockPos blockpos1 = this.m_58899_().m_7918_(i, j, k);
                        BlockState blockstate = this.f_58857_.m_8055_(blockpos1);
                        if (!(blockstate.m_60734_() instanceof SculkRelayBlock)) continue;
                        this.nearbyRelay = blockpos1;
                    }
                }
            }
        }
    }

    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            if (!this.checkCage()) {
                this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)SculkConverterBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
            } else {
                this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)SculkConverterBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
            }
            if (!this.sculkSpreader.m_222283_().isEmpty()) {
                this.sculkSpreader.m_222255_((LevelAccessor)this.f_58857_, this.m_58899_(), this.f_58857_.m_213780_(), true);
            }
        }
    }

    private boolean checkCage() {
        assert (this.f_58857_ != null);
        BlockPos pos = new BlockPos(this.m_58899_().m_123341_(), this.m_58899_().m_123342_() + 1, this.m_58899_().m_123343_());
        BlockState blockState = this.f_58857_.m_8055_(pos);
        if (blockState.m_60713_((Block)ModBlocks.CURSED_CAGE_BLOCK.get())) {
            BlockEntity tileentity = this.f_58857_.m_7702_(pos);
            if (tileentity instanceof CursedCageBlockEntity) {
                this.cursedCageTile = (CursedCageBlockEntity)tileentity;
                return !this.cursedCageTile.getItem().m_41619_();
            }
            return false;
        }
        return false;
    }

    @Override
    public void readNetwork(CompoundTag tag) {
        this.sculkSpreader.m_222269_(tag);
        NbtUtils.m_129239_((CompoundTag)tag);
        this.loadEnchants(tag);
    }

    @Override
    public CompoundTag writeNetwork(CompoundTag tag) {
        this.sculkSpreader.m_222275_(tag);
        if (this.nearbyRelay != null) {
            NbtUtils.m_129224_((BlockPos)this.nearbyRelay);
        }
        this.saveEnchants(tag, ((Block)ModBlocks.SCULK_CONVERTER.get()).m_5456_());
        return tag;
    }

    public CursedCageBlockEntity getCursedCageTile() {
        return this.cursedCageTile;
    }
}

