/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities;

import com.Polarice3.Goety.api.blocks.entities.IWindPowered;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.blocks.ResonanceCrystalBlock;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntities;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntity;
import com.Polarice3.Goety.common.entities.ally.SquallGolem;
import com.Polarice3.Goety.common.items.block.ResonanceBlockItem;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ResonanceCrystalBlockEntity
extends ModBlockEntity
implements IWindPowered {
    public static String GOLEM_LIST = ResonanceBlockItem.GOLEM_LIST;
    public List<SquallGolem> squallGolems = new ArrayList<SquallGolem>();
    public List<UUID> uuids = new ArrayList<UUID>();
    public int active;
    private boolean isOn;

    public ResonanceCrystalBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)ModBlockEntities.RESONANCE_CRYSTAL.get(), p_155229_, p_155230_);
    }

    public void tick() {
        if (this.f_58857_ != null) {
            if (this.active > 0) {
                --this.active;
            }
            if (((Boolean)this.m_58900_().m_61143_((Property)ResonanceCrystalBlock.POWERED)).booleanValue()) {
                if (!this.isOn) {
                    this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.RESONANCE_CRYSTAL_ON.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.isOn = true;
                } else if (this.f_58857_.m_46467_() % (long)MathHelper.secondsToTicks(6) == 0L) {
                    this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.RESONANCE_CRYSTAL_LOOP.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                Level level = this.f_58857_;
                if (level instanceof ServerLevel) {
                    ServerLevel world = (ServerLevel)level;
                    ChunkPos chunkPos = this.f_58857_.m_46745_(this.f_58858_).m_7697_();
                    if (!world.m_8902_().contains(chunkPos.m_45588_())) {
                        world.m_8602_(chunkPos.f_45578_, chunkPos.f_45579_, true);
                        if (!world.m_46749_(this.f_58858_)) {
                            world.m_46745_(this.f_58858_).m_62913_(true);
                        }
                    }
                    BlockPos blockPos = this.m_58899_();
                    ServerParticleUtil.gatheringBlockParticles((ParticleOptions)ModParticleTypes.RESONANCE_GATHER.get(), blockPos, world);
                    ServerParticleUtil.addAuraParticles(world, (ParticleOptions)ParticleTypes.f_123796_, (float)blockPos.m_123341_() + 0.5f, blockPos.m_123342_(), (float)blockPos.m_123343_() + 0.5f, 1.0f);
                    if (!this.uuids.isEmpty()) {
                        this.uuids.removeIf(uuid -> {
                            Entity entity = EntityFinder.getEntityByUuiD(uuid);
                            if (!(entity instanceof SquallGolem)) {
                                return true;
                            }
                            SquallGolem squallGolem = (SquallGolem)entity;
                            if (!squallGolem.m_6084_()) {
                                this.squallGolems.remove(squallGolem);
                                return true;
                            }
                            return false;
                        });
                        for (UUID uuid2 : this.uuids) {
                            SquallGolem squallGolem;
                            Entity entity;
                            if (uuid2 == null || !((entity = EntityFinder.getEntityByUuiD(uuid2)) instanceof SquallGolem) || this.squallGolems.contains(squallGolem = (SquallGolem)entity)) continue;
                            this.squallGolems.add(squallGolem);
                        }
                    }
                    this.activateGolems();
                }
            } else if (this.isOn) {
                this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.RESONANCE_CRYSTAL_OFF.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                this.isOn = false;
            }
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)ResonanceCrystalBlock.POWERED, (Comparable)Boolean.valueOf(this.active > 0)), 3);
        }
    }

    public void activateGolems() {
        if (!this.squallGolems.isEmpty()) {
            for (SquallGolem squallGolem : this.squallGolems) {
                if (squallGolem == null) continue;
                squallGolem.activate(20);
            }
        }
    }

    public List<SquallGolem> getSquallGolems() {
        return this.squallGolems;
    }

    public void addSquallGolem(SquallGolem squallGolem) {
        this.uuids.add(squallGolem.m_20148_());
    }

    public List<UUID> getUuids() {
        return this.uuids;
    }

    @Override
    public int activeTicks() {
        return this.active;
    }

    @Override
    public void activate(int tick) {
        this.active = tick;
        this.m_6596_();
    }

    @Override
    public void readNetwork(CompoundTag tag) {
        if (tag.m_128441_("active")) {
            this.active = tag.m_128451_("active");
        }
        if (tag.m_128441_(GOLEM_LIST)) {
            ListTag list = tag.m_128437_(GOLEM_LIST, 8);
            for (int i = 0; i < list.size(); ++i) {
                this.uuids.add(UUID.fromString(list.m_128778_(i)));
            }
        }
        if (tag.m_128441_("isOn")) {
            this.isOn = tag.m_128471_("isOn");
        }
    }

    @Override
    public CompoundTag writeNetwork(CompoundTag tag) {
        tag.m_128405_("active", this.active);
        ArrayList<String> list = new ArrayList<String>();
        if (tag.m_128441_(GOLEM_LIST)) {
            for (int i = 0; i < tag.m_128437_(GOLEM_LIST, 8).size(); ++i) {
                list.add(tag.m_128437_(GOLEM_LIST, 8).m_128778_(i));
            }
        }
        if (!this.uuids.isEmpty()) {
            for (UUID uuid : this.uuids) {
                if (list.contains(uuid.toString())) continue;
                ListTag nbttaglist = new ListTag();
                if (tag.m_128441_(GOLEM_LIST)) {
                    nbttaglist = tag.m_128437_(GOLEM_LIST, 8);
                }
                nbttaglist.add((Object)StringTag.m_129297_((String)uuid.toString()));
                tag.m_128365_(GOLEM_LIST, (Tag)nbttaglist);
            }
        }
        tag.m_128379_("isOn", this.isOn);
        return tag;
    }
}

