/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities;

import com.Polarice3.Goety.api.blocks.entities.IOwnedBlock;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class OwnedBlockEntity
extends BlockEntity
implements IOwnedBlock {
    private UUID ownerUUID;

    public OwnedBlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
    }

    public CompoundTag m_5995_() {
        return this.writeNetwork(super.m_5995_());
    }

    public void m_142466_(CompoundTag nbt) {
        this.readNetwork(nbt);
        super.m_142466_(nbt);
    }

    public void m_183515_(CompoundTag compound) {
        this.writeNetwork(compound);
        super.m_183515_(compound);
    }

    public void readNetwork(CompoundTag tag) {
        UUID uuid;
        if (tag.m_128403_("Owner")) {
            uuid = tag.m_128342_("Owner");
        } else {
            String s = tag.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.f_58857_.m_7654_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerId(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public CompoundTag writeNetwork(CompoundTag tag) {
        if (this.getOwnerId() != null) {
            tag.m_128362_("Owner", this.getOwnerId());
        }
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nullable
    public UUID getOwnerId() {
        return this.ownerUUID;
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.ownerUUID = p_184754_1_;
    }

    public void setOwner(LivingEntity livingEntity) {
        this.setOwnerId(livingEntity.m_20148_());
    }

    public LivingEntity getTrueOwner() {
        try {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : this.f_58857_.m_46003_(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    @Override
    public Player getPlayer() {
        return (Player)this.getTrueOwner();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.readNetwork(pkt.m_131708_());
        }
    }

    @Override
    public boolean screenView() {
        return true;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.m_142466_(tag);
        this.readNetwork(tag);
    }
}

