/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities;

import com.Polarice3.Goety.MainConfig;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntities;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;

public class HookBellBlockEntity
extends BlockEntity {
    private long lastRingTimestamp;
    public int ticks;
    public boolean shaking;
    public Direction clickDirection;
    private List<LivingEntity> nearbyEntities;
    private boolean resonating;
    private int resonationTicks;
    private static final double minRange = 16.0;
    private static final double maxRange = 128.0;

    public HookBellBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)ModBlockEntities.HOOK_BELL.get(), p_155229_, p_155230_);
    }

    public boolean m_7531_(int p_58837_, int p_58838_) {
        if (p_58837_ == 1) {
            this.updateEntities();
            this.resonationTicks = 0;
            this.clickDirection = Direction.m_122376_((int)p_58838_);
            this.ticks = 0;
            this.shaking = true;
            return true;
        }
        return super.m_7531_(p_58837_, p_58838_);
    }

    private static void tick(Level p_155181_, BlockPos p_155182_, BlockState p_155183_, HookBellBlockEntity p_155184_) {
        if (p_155184_.shaking) {
            ++p_155184_.ticks;
            if (p_155181_ instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)p_155181_;
                for (int i = 0; i < 2; ++i) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, (double)p_155184_.m_58899_().m_123341_() + 0.5, (double)p_155184_.m_58899_().m_123342_() + 0.5, (double)p_155184_.m_58899_().m_123343_() + 0.5, 0, (p_155181_.f_46441_.m_188500_() - 0.5) * 2.0, -p_155181_.f_46441_.m_188500_(), (p_155181_.f_46441_.m_188500_() - 0.5) * 2.0, 0.5);
                }
            }
        }
        if (p_155184_.ticks >= 50) {
            p_155184_.shaking = false;
            p_155184_.ticks = 0;
        }
        if (p_155184_.ticks >= 5 && p_155184_.resonationTicks == 0 && HookBellBlockEntity.areRaidersNearby(p_155182_, p_155184_.nearbyEntities)) {
            p_155184_.resonating = true;
            p_155181_.m_5594_((Player)null, p_155182_, SoundEvents.f_11700_, SoundSource.BLOCKS, 1.0f, 0.5f);
        }
        if (p_155184_.resonating) {
            if (p_155184_.resonationTicks < 40) {
                ++p_155184_.resonationTicks;
            } else {
                HookBellBlockEntity.teleportRaiders(p_155181_, p_155182_, p_155184_.nearbyEntities);
                p_155184_.resonating = false;
            }
        }
    }

    public static void clientTick(Level p_155176_, BlockPos p_155177_, BlockState p_155178_, HookBellBlockEntity p_155179_) {
        HookBellBlockEntity.tick(p_155176_, p_155177_, p_155178_, p_155179_);
    }

    public static void serverTick(Level p_155203_, BlockPos p_155204_, BlockState p_155205_, HookBellBlockEntity p_155206_) {
        HookBellBlockEntity.tick(p_155203_, p_155204_, p_155205_, p_155206_);
    }

    public void onHit(Direction p_58835_) {
        BlockPos blockpos = this.m_58899_();
        this.clickDirection = p_58835_;
        if (this.shaking) {
            this.ticks = 0;
        } else {
            this.shaking = true;
        }
        if (this.f_58857_ != null) {
            this.f_58857_.m_7696_(blockpos, this.m_58900_().m_60734_(), 1, p_58835_.m_122411_());
        }
    }

    private void updateEntities() {
        if (this.f_58857_ != null) {
            BlockPos blockpos = this.m_58899_();
            if (this.f_58857_.m_46467_() > this.lastRingTimestamp + 60L || this.nearbyEntities == null) {
                this.lastRingTimestamp = this.f_58857_.m_46467_();
                AABB aabb = new AABB(blockpos).m_82400_(128.0);
                this.nearbyEntities = this.f_58857_.m_45976_(LivingEntity.class, aabb);
            }
            if (!this.f_58857_.f_46443_) {
                for (LivingEntity livingentity : this.nearbyEntities) {
                    if (!livingentity.m_6084_() || livingentity.m_213877_() || !blockpos.m_203195_((Position)livingentity.m_20182_(), 128.0)) continue;
                    livingentity.m_6274_().m_21879_(MemoryModuleType.f_26325_, (Object)this.f_58857_.m_46467_());
                }
            }
        }
    }

    private static boolean areRaidersNearby(BlockPos p_155200_, List<LivingEntity> p_155201_) {
        for (LivingEntity livingentity : p_155201_) {
            if (!HookBellBlockEntity.isRaiderWithinRange(p_155200_, livingentity)) continue;
            return true;
        }
        return false;
    }

    private static boolean areRaidersClose(BlockPos origin, LivingEntity living) {
        return origin.m_203195_((Position)living.m_20182_(), 128.0) && !origin.m_203195_((Position)living.m_20182_(), 16.0);
    }

    private static void teleportRaiders(Level p_155187_, BlockPos p_155188_, List<LivingEntity> p_155189_) {
        BlockEntity blockEntity = p_155187_.m_7702_(p_155188_);
        if (blockEntity instanceof HookBellBlockEntity) {
            HookBellBlockEntity callerBellBlock = (HookBellBlockEntity)blockEntity;
            p_155189_.stream().filter(p_155219_ -> HookBellBlockEntity.isRaiderWithinRange(p_155188_, p_155219_)).forEach(entity -> HookBellBlockEntity.teleport(entity, callerBellBlock));
        }
    }

    private static boolean isRaiderWithinRange(BlockPos p_155197_, LivingEntity p_155198_) {
        return p_155198_.m_6084_() && !p_155198_.m_213877_() && HookBellBlockEntity.areRaidersClose(p_155197_, p_155198_) && p_155198_.m_6095_().m_204039_(EntityTypeTags.f_13121_) && !MobUtil.hasEntityTypesConfig((List)MainConfig.HookBellBlackList.get(), p_155198_.m_6095_());
    }

    private static void teleport(LivingEntity p_58841_, HookBellBlockEntity blockEntity) {
        for (int i = 0; i < 128; ++i) {
            double d5;
            double d4;
            BlockPos blockPos = blockEntity.f_58858_;
            double d3 = (double)blockPos.m_123341_() + (p_58841_.m_217043_().m_188500_() - 0.5) * 8.0;
            if (!p_58841_.m_20984_(d3, d4 = (double)blockPos.m_123342_() + (double)(p_58841_.m_217043_().m_188503_(16) - 8), d5 = (double)blockPos.m_123343_() + (p_58841_.m_217043_().m_188500_() - 0.5) * 8.0, true)) continue;
            p_58841_.f_19853_.m_214171_(GameEvent.f_238175_, p_58841_.m_20182_(), GameEvent.Context.m_223717_((Entity)p_58841_));
            p_58841_.f_19853_.m_6263_((Player)null, p_58841_.f_19854_, p_58841_.f_19855_, p_58841_.f_19856_, SoundEvents.f_11852_, p_58841_.m_5720_(), 1.0f, 1.0f);
            p_58841_.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            break;
        }
    }
}

