/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities;

import com.Polarice3.Goety.client.particles.SparkleParticleOption;
import com.Polarice3.Goety.common.blocks.HoleBlock;
import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntities;
import com.Polarice3.Goety.common.blocks.entities.SaveBlockEntity;
import com.Polarice3.Goety.common.magic.spells.void_spells.TunnelSpell;
import com.Polarice3.Goety.utils.MathHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class HoleBlockEntity
extends SaveBlockEntity {
    public int life = 0;
    public int lifespan = 120;
    public int count = 0;
    public Direction direction = null;

    public HoleBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)ModBlockEntities.HOLE.get(), p_155229_, p_155230_);
    }

    public void setStats(BlockState oldBlock, int initLife, int lifespan, int count, Direction direction) {
        this.oldBlock = oldBlock;
        this.life = initLife;
        this.lifespan = lifespan;
        this.count = count;
        this.direction = direction;
        this.m_6596_();
    }

    public void setStats(BlockState oldBlock, int lifespan, int count, Direction direction) {
        this.setStats(oldBlock, 0, lifespan, count, direction);
    }

    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            for (int a = 0; a < 2; ++a) {
                this.sparkle();
            }
        }
        if (!this.f_58857_.f_46443_) {
            if (this.life == 0 && this.count > 1 && this.direction != null) {
                switch (this.direction.m_122434_()) {
                    case Y: {
                        int i;
                        for (i = 0; i < 9; ++i) {
                            if (i / 3 == 1 && i % 3 == 1) continue;
                            TunnelSpell.createHole(this.f_58857_, this.m_58899_().m_7918_(-1 + i / 3, 0, -1 + i % 3), null, 1, this.lifespan);
                        }
                        break;
                    }
                    case Z: {
                        int i;
                        for (i = 0; i < 9; ++i) {
                            if (i / 3 == 1 && i % 3 == 1) continue;
                            TunnelSpell.createHole(this.f_58857_, this.m_58899_().m_7918_(-1 + i / 3, -1 + i % 3, 0), null, 1, this.lifespan);
                        }
                        break;
                    }
                    case X: {
                        int i;
                        for (i = 0; i < 9; ++i) {
                            if (i / 3 == 1 && i % 3 == 1) continue;
                            TunnelSpell.createHole(this.f_58857_, this.m_58899_().m_7918_(0, -1 + i / 3, -1 + i % 3), null, 1, this.lifespan);
                        }
                        break;
                    }
                }
                if (!TunnelSpell.createHole(this.f_58857_, this.m_58899_().m_121945_(this.direction.m_122424_()), this.direction, this.count - 1, this.lifespan)) {
                    this.count = 0;
                }
            }
            ++this.life;
            if (this.life % 20 == 0) {
                this.m_6596_();
            }
            if (this.life >= this.lifespan) {
                this.f_58857_.m_7731_(this.m_58899_(), this.oldBlock, 3);
            }
        }
    }

    public boolean shouldRenderFace(Direction direction) {
        if (this.f_58857_ == null) {
            return false;
        }
        BlockPos blockPos = this.m_58899_().m_121945_(direction);
        BlockState blockState = this.f_58857_.m_8055_(blockPos);
        return !blockState.m_60795_() && !(blockState.m_60734_() instanceof HoleBlock) && blockState.m_60804_((BlockGetter)this.f_58857_, blockPos);
    }

    private void sparkle() {
        if (this.f_58857_ == null) {
            return;
        }
        for (Direction direction : Direction.values()) {
            BlockPos blockPos = this.m_58899_().m_121945_(direction);
            BlockState blockState = this.f_58857_.m_8055_(this.m_58899_().m_121945_(direction));
            if (blockState.m_60734_() == ModBlocks.HOLE.get() || blockState.m_60804_((BlockGetter)this.f_58857_, blockPos)) continue;
            for (Direction direction1 : Direction.values()) {
                BlockPos blockPos1 = this.m_58899_().m_121945_(direction1);
                if (direction.m_122434_() == direction1.m_122434_() || !this.f_58857_.m_8055_(blockPos1).m_60804_((BlockGetter)this.f_58857_, blockPos1) && !this.f_58857_.m_8055_(blockPos.m_121945_(direction1)).m_60804_((BlockGetter)this.f_58857_, blockPos.m_121945_(direction1))) continue;
                float x = 0.5f * (float)direction.m_122429_();
                float y = 0.5f * (float)direction.m_122430_();
                float z = 0.5f * (float)direction.m_122431_();
                if (x == 0.0f) {
                    x = 0.5f * (float)direction1.m_122429_();
                }
                if (y == 0.0f) {
                    y = 0.5f * (float)direction1.m_122430_();
                }
                if (z == 0.0f) {
                    z = 0.5f * (float)direction1.m_122431_();
                }
                x = x == 0.0f ? this.f_58857_.f_46441_.m_188501_() : (x += 0.5f);
                y = y == 0.0f ? this.f_58857_.f_46441_.m_188501_() : (y += 0.5f);
                z = z == 0.0f ? this.f_58857_.f_46441_.m_188501_() : (z += 0.5f);
                if (this.f_58857_.f_46441_.m_188503_(6) != 0) continue;
                float[] color = MathHelper.rgbFloat(3496862);
                this.f_58857_.m_7106_((ParticleOptions)new SparkleParticleOption(0.6f + this.f_58857_.f_46441_.m_188501_() * 0.2f, color[0], color[1], color[2], 6 + this.f_58857_.f_46441_.m_188503_(4)), (double)((float)this.m_58899_().m_123341_() + x), (double)((float)this.m_58899_().m_123342_() + y), (double)((float)this.m_58899_().m_123343_() + z), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void readNetwork(CompoundTag compoundTag) {
        super.readNetwork(compoundTag);
        if (compoundTag.m_128441_("Life")) {
            this.life = compoundTag.m_128451_("Life");
        }
        if (compoundTag.m_128441_("Lifespan")) {
            this.lifespan = compoundTag.m_128451_("Lifespan");
        }
        if (compoundTag.m_128441_("Count")) {
            this.count = compoundTag.m_128451_("Count");
        }
        if (compoundTag.m_128441_("Direction")) {
            int ordinal = compoundTag.m_128451_("Direction");
            this.direction = ordinal > 0 && ordinal < Direction.values().length + 1 ? Direction.values()[compoundTag.m_128451_("Direction")] : null;
        }
    }

    @Override
    public CompoundTag writeNetwork(CompoundTag compoundTag) {
        super.writeNetwork(compoundTag);
        compoundTag.m_128405_("Life", this.life);
        compoundTag.m_128405_("Lifespan", this.lifespan);
        compoundTag.m_128405_("Count", this.count);
        int ordinalInt = -1;
        if (this.direction != null) {
            ordinalInt = this.direction.ordinal();
        }
        compoundTag.m_128405_("Direction", ordinalInt);
        return compoundTag;
    }
}

