/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.MainConfig;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.blocks.DarkAltarBlock;
import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.blocks.entities.CursedCageBlockEntity;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntities;
import com.Polarice3.Goety.common.blocks.entities.PedestalBlockEntity;
import com.Polarice3.Goety.common.crafting.ModRecipeSerializer;
import com.Polarice3.Goety.common.crafting.RitualRecipe;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SPlayWorldSoundPacket;
import com.Polarice3.Goety.common.research.ResearchList;
import com.Polarice3.Goety.common.ritual.Ritual;
import com.Polarice3.Goety.common.ritual.RitualRequirements;
import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.SEHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoulFireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class DarkAltarBlockEntity
extends PedestalBlockEntity
implements GameEventListener {
    public long lastChangeTime;
    public LazyOptional<ItemStackHandler> itemStackHandler = LazyOptional.of(() -> new ItemStackHandler(1){

        public int getSlotLimit(int slot) {
            return 64;
        }

        protected void onContentsChanged(int slot) {
            assert (DarkAltarBlockEntity.this.f_58857_ != null);
            if (!((DarkAltarBlockEntity)DarkAltarBlockEntity.this).f_58857_.f_46443_) {
                DarkAltarBlockEntity.this.lastChangeTime = DarkAltarBlockEntity.this.f_58857_.m_46467_();
                boolean flag = !((ItemStack)this.stacks.get(0)).m_41619_();
                DarkAltarBlockEntity.this.f_58857_.m_46597_(DarkAltarBlockEntity.this.m_58899_(), (BlockState)DarkAltarBlockEntity.this.m_58900_().m_61124_((Property)DarkAltarBlock.OCCUPIED, (Comparable)Boolean.valueOf(flag)));
                DarkAltarBlockEntity.this.markNetworkDirty();
            }
        }
    });
    private CursedCageBlockEntity cursedCageTile;
    private final BlockPositionSource blockPosSource = new BlockPositionSource(this.f_58858_);
    public RitualRecipe currentRitualRecipe;
    public ResourceLocation currentRitualRecipeId;
    public UUID castingPlayerId;
    public Player castingPlayer;
    public List<Ingredient> remainingAdditionalIngredients = new ArrayList<Ingredient>();
    public List<ItemStack> consumedIngredients = new ArrayList<ItemStack>();
    public boolean sacrificeProvided;
    public Mob getConvertEntity;
    public int currentTime;
    public int structureTime;
    public int convertTime;

    public DarkAltarBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.DARK_ALTAR.get(), blockPos, blockState);
    }

    public RitualRecipe getCurrentRitualRecipe() {
        if (this.currentRitualRecipeId != null && this.f_58857_ != null) {
            Optional recipe = this.f_58857_.m_7465_().m_44043_(this.currentRitualRecipeId);
            recipe.map(r -> (RitualRecipe)r).ifPresent(r -> {
                this.currentRitualRecipe = r;
            });
            this.currentRitualRecipeId = null;
        }
        return this.currentRitualRecipe;
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.consumedIngredients.clear();
        if (this.currentRitualRecipeId != null || this.getCurrentRitualRecipe() != null) {
            if (compound.m_128441_("consumedIngredients")) {
                ListTag list = compound.m_128437_("consumedIngredients", 10);
                for (int i = 0; i < list.size(); ++i) {
                    ItemStack stack = ItemStack.m_41712_((CompoundTag)list.m_128728_(i));
                    this.consumedIngredients.add(stack);
                }
            }
            this.restoreRemainingAdditionalIngredients();
        }
        if (compound.m_128441_("sacrificeProvided")) {
            this.sacrificeProvided = compound.m_128471_("sacrificeProvided");
        }
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        if (this.getCurrentRitualRecipe() != null) {
            if (this.consumedIngredients.size() > 0) {
                ListTag list = new ListTag();
                for (ItemStack stack : this.consumedIngredients) {
                    list.add((Object)stack.serializeNBT());
                }
                compound.m_128365_("consumedIngredients", (Tag)list);
            }
            compound.m_128379_("sacrificeProvided", this.sacrificeProvided);
        }
        super.m_183515_(compound);
    }

    @Override
    public void readNetwork(CompoundTag compound) {
        this.itemStackHandler.ifPresent(handler -> handler.deserializeNBT(compound.m_128469_("inventory")));
        this.lastChangeTime = compound.m_128454_("lastChangeTime");
        if (compound.m_128441_("currentRitual")) {
            this.currentRitualRecipeId = new ResourceLocation(compound.m_128461_("currentRitual"));
        }
        if (compound.m_128441_("castingPlayerId")) {
            this.castingPlayerId = compound.m_128342_("castingPlayerId");
        }
        this.currentTime = compound.m_128451_("currentTime");
        this.structureTime = compound.m_128451_("structureTime");
        this.convertTime = compound.m_128451_("convertTime");
    }

    @Override
    public CompoundTag writeNetwork(CompoundTag compound) {
        this.itemStackHandler.ifPresent(handler -> compound.m_128365_("inventory", (Tag)handler.serializeNBT()));
        compound.m_128356_("lastChangeTime", this.lastChangeTime);
        RitualRecipe recipe = this.getCurrentRitualRecipe();
        if (recipe != null) {
            compound.m_128359_("currentRitual", recipe.m_6423_().toString());
        }
        if (this.castingPlayerId != null) {
            compound.m_128362_("castingPlayerId", this.castingPlayerId);
        }
        compound.m_128405_("currentTime", this.currentTime);
        compound.m_128405_("structureTime", this.structureTime);
        compound.m_128405_("convertTime", this.convertTime);
        return compound;
    }

    public void tick() {
        boolean flag = this.checkCage();
        assert (this.f_58857_ != null);
        if (flag) {
            if (this.cursedCageTile.getSouls() > 0) {
                RitualRecipe recipe = this.getCurrentRitualRecipe();
                double d0 = (double)this.f_58858_.m_123341_() + this.f_58857_.f_46441_.m_188500_();
                double d1 = (double)this.f_58858_.m_123342_() + this.f_58857_.f_46441_.m_188500_();
                double d2 = (double)this.f_58858_.m_123343_() + this.f_58857_.f_46441_.m_188500_();
                if (!this.f_58857_.f_46443_) {
                    ServerLevel serverWorld = (ServerLevel)this.f_58857_;
                    if (recipe != null) {
                        int p;
                        this.restoreCastingPlayer();
                        if (this.castingPlayer == null || !this.sacrificeFulfilled()) {
                            for (p = 0; p < 4; ++p) {
                                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123744_, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
                            }
                        }
                        for (p = 0; p < 4; ++p) {
                            serverWorld.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.TOTEM_EFFECT.get()), d0, d1, d2, 0, 0.45, 0.45, 0.45, 1.0);
                        }
                        if (this.remainingAdditionalIngredients == null) {
                            this.restoreRemainingAdditionalIngredients();
                            if (this.remainingAdditionalIngredients == null) {
                                Goety.LOGGER.warn("Could not restore remainingAdditionalIngredients during tick - world seems to be null. Will attempt again next tick.");
                                return;
                            }
                        }
                        IItemHandler handler = (IItemHandler)this.itemStackHandler.orElseThrow(RuntimeException::new);
                        if (!recipe.getRitual().isValid(this.f_58857_, this.f_58858_, this, this.castingPlayer, handler.getStackInSlot(0), this.remainingAdditionalIngredients)) {
                            this.stopRitual(false);
                            return;
                        }
                        if (this.castingPlayer == null || !this.sacrificeFulfilled()) {
                            return;
                        }
                        if (this.f_58857_.m_46467_() % 20L == 0L) {
                            if (this.cursedCageTile.getSouls() >= recipe.getSoulCost()) {
                                this.cursedCageTile.decreaseSouls(recipe.getSoulCost());
                                serverWorld.m_5594_(null, this.f_58858_, SoundEvents.f_215740_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
                                serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_235898_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.15, (double)this.f_58858_.m_123343_() + 0.5, 2, 0.2, 0.0, 0.2, 0.0);
                                ++this.currentTime;
                            } else {
                                this.castingPlayer.m_5661_((Component)Component.m_237115_((String)"info.goety.ritual.noSouls.fail"), true);
                                this.stopRitual(false);
                                return;
                            }
                        }
                        recipe.getRitual().update(this.f_58857_, this.f_58858_, this, this.castingPlayer, handler.getStackInSlot(0), this.currentTime, recipe.getDuration());
                        if (!recipe.getRitual().consumeAdditionalIngredients(this.f_58857_, this.f_58858_, this.castingPlayer, this.remainingAdditionalIngredients, this.currentTime, this.consumedIngredients)) {
                            this.stopRitual(false);
                            return;
                        }
                        if (recipe.getDuration() >= 0 && this.currentTime >= recipe.getDuration()) {
                            if (!recipe.isConversion()) {
                                this.stopRitual(true);
                            } else if (this.getConvertEntity != null) {
                                this.stopRitual(true);
                            } else {
                                this.castingPlayer.m_5661_((Component)Component.m_237115_((String)"info.goety.ritual.convert.fail"), true);
                                this.stopRitual(false);
                            }
                        }
                        int totalTime = 60;
                        if (!RitualRequirements.getProperStructure(recipe.getCraftType(), this, this.f_58858_, this.f_58857_)) {
                            ++this.structureTime;
                            if (this.structureTime >= totalTime) {
                                this.castingPlayer.m_5661_((Component)Component.m_237115_((String)"info.goety.ritual.structure.fail"), true);
                                this.stopRitual(false);
                            }
                        } else {
                            this.structureTime = 0;
                        }
                        if (recipe.isConversion()) {
                            if (RitualRequirements.noConvertEntity(recipe.getEntityToConvert(), this.f_58858_, this.f_58857_)) {
                                ++this.convertTime;
                                if (this.getConvertEntity != null) {
                                    this.getConvertEntity = null;
                                }
                                if (this.convertTime >= totalTime) {
                                    this.castingPlayer.m_5661_((Component)Component.m_237115_((String)"info.goety.ritual.convert.fail"), true);
                                    this.stopRitual(false);
                                }
                            } else {
                                this.getConvertEntity = RitualRequirements.getConvertEntity(recipe.getEntityToConvert(), this.f_58858_, this.f_58857_);
                                this.convertTime = 0;
                            }
                        }
                    } else if (this.f_58857_.m_46467_() % 20L == 0L) {
                        for (int p = 0; p < 4; ++p) {
                            serverWorld.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.TOTEM_EFFECT.get()), d0, d1, d2, 0, 0.45, 0.45, 0.45, 1.0);
                        }
                    }
                }
            } else {
                this.stopRitual(false);
            }
        } else {
            this.stopRitual(false);
        }
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)DarkAltarBlock.LIT, (Comparable)Boolean.valueOf(flag)), 3);
    }

    public void restoreCastingPlayer() {
        if (this.castingPlayer == null && this.castingPlayerId != null && this.f_58857_ != null && this.f_58857_.m_46467_() % 600L == 0L) {
            this.castingPlayer = EntityFinder.getPlayerByUuiDGlobal(this.castingPlayerId).orElse(null);
            this.m_6596_();
            this.markNetworkDirty();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean activate(Level world, BlockPos pos, Player player, InteractionHand hand, Direction face) {
        if (world.f_46443_) return true;
        if (!this.checkCage()) {
            this.removeItem();
            return true;
        }
        ItemStack activationItem = player.m_21120_(hand);
        if (activationItem == ItemStack.f_41583_) {
            this.removeItem();
        }
        if (this.getCurrentRitualRecipe() != null) {
            this.stopRitual(false);
            return true;
        }
        RitualRecipe ritualRecipe = world.m_7465_().m_44013_((RecipeType)ModRecipeSerializer.RITUAL_TYPE.get()).stream().filter(r -> r.matches(world, pos, player, activationItem)).findFirst().orElse(null);
        if (ritualRecipe == null) {
            player.m_5661_((Component)Component.m_237115_((String)"info.goety.ritual.itemProblem.fail"), true);
            return false;
        }
        if (!ritualRecipe.getRitual().isValid(world, pos, this, player, activationItem, (List<Ingredient>)ritualRecipe.m_7527_())) {
            player.m_5661_((Component)Component.m_237115_((String)"info.goety.ritual.itemProblem.fail"), true);
            return false;
        }
        if (!RitualRequirements.getProperStructure(ritualRecipe.getCraftType(), this, pos, world)) {
            player.m_5661_((Component)Component.m_237115_((String)"info.goety.ritual.structure.fail"), true);
            return false;
        }
        if (ritualRecipe.getCraftType().contains("lich")) {
            if (!((Boolean)MainConfig.LichScrollRequirement.get()).booleanValue()) {
                this.startRitual(player, activationItem, ritualRecipe);
                return true;
            }
            if (SEHelper.hasResearch(player, ResearchList.FORBIDDEN)) {
                this.startRitual(player, activationItem, ritualRecipe);
                return true;
            }
            player.m_5661_((Component)Component.m_237115_((String)"info.goety.ritual.fail"), true);
            return false;
        }
        if (ritualRecipe.isConversion() && RitualRequirements.noConvertEntity(ritualRecipe.getEntityToConvert(), pos, world)) {
            player.m_5661_((Component)Component.m_237115_((String)"info.goety.ritual.convert.fail"), true);
            return false;
        }
        if (ritualRecipe.getResearch() != null && ResearchList.getResearch(ritualRecipe.getResearch()) != null) {
            if (SEHelper.hasResearch(player, ResearchList.getResearch(ritualRecipe.getResearch()))) {
                this.startRitual(player, activationItem, ritualRecipe);
                return true;
            }
            player.m_5661_((Component)Component.m_237115_((String)"info.goety.ritual.fail"), true);
            return false;
        }
        if (world.m_46472_() == Level.f_46429_ && ritualRecipe.getEntityToSummon() == ModEntityType.SUMMON_APOSTLE.get()) {
            if (SEHelper.apostleWarned(player)) {
                SEHelper.setApostleWarned(player, false);
                this.startRitual(player, activationItem, ritualRecipe);
                return true;
            }
            SEHelper.setApostleWarned(player, true);
            player.m_5661_((Component)Component.m_237115_((String)"info.goety.ritual.apostleWarn"), true);
            return false;
        }
        this.startRitual(player, activationItem, ritualRecipe);
        return true;
    }

    public void removeItem() {
        IItemHandler handler = (IItemHandler)this.itemStackHandler.orElseThrow(RuntimeException::new);
        ItemStack itemStack = handler.getStackInSlot(0);
        if (itemStack != ItemStack.f_41583_) {
            Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)handler.extractItem(0, itemStack.m_41613_(), false));
        }
        this.currentRitualRecipe = null;
        this.castingPlayerId = null;
        this.castingPlayer = null;
        this.currentTime = 0;
        this.sacrificeProvided = false;
        if (this.remainingAdditionalIngredients != null) {
            this.remainingAdditionalIngredients.clear();
        }
        this.consumedIngredients.clear();
        this.structureTime = 0;
        this.m_6596_();
        this.markNetworkDirty();
    }

    public void startRitual(Player player, ItemStack activationItem, RitualRecipe ritualRecipe) {
        if (!this.f_58857_.f_46443_) {
            this.currentRitualRecipe = ritualRecipe;
            this.castingPlayerId = player.m_20148_();
            this.castingPlayer = player;
            this.currentTime = 0;
            this.sacrificeProvided = false;
            this.consumedIngredients.clear();
            this.remainingAdditionalIngredients = new ArrayList<Ingredient>((Collection<Ingredient>)this.currentRitualRecipe.m_7527_());
            IItemHandler handler = (IItemHandler)this.itemStackHandler.orElseThrow(RuntimeException::new);
            handler.insertItem(0, activationItem.m_41620_(1), false);
            this.currentRitualRecipe.getRitual().start(this.f_58857_, this.f_58858_, this, player, handler.getStackInSlot(0));
            this.structureTime = 40;
            this.m_6596_();
            this.markNetworkDirty();
        }
    }

    public void stopRitual(boolean finished) {
        if (!this.f_58857_.f_46443_) {
            RitualRecipe recipe = this.getCurrentRitualRecipe();
            if (recipe != null && this.castingPlayer != null) {
                IItemHandler handler = (IItemHandler)this.itemStackHandler.orElseThrow(RuntimeException::new);
                if (finished) {
                    ItemStack activationItem = handler.getStackInSlot(0);
                    recipe.getRitual().finish(this.f_58857_, this.f_58858_, this, this.castingPlayer, activationItem);
                    if (recipe.getEntityToSummon() == ModEntityType.SUMMON_APOSTLE.get()) {
                        Level level = this.f_58857_;
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            ModNetwork.sendToALL(new SPlayWorldSoundPacket(this.f_58858_, (SoundEvent)SoundEvents.f_12325_.get(), 1.0f, 1.0f));
                            Warden.m_219375_((ServerLevel)serverLevel, (Vec3)Vec3.m_82512_((Vec3i)this.f_58858_), (Entity)null, (int)32);
                        }
                        for (int i = -8; i <= 8; ++i) {
                            for (int j = -8; j <= 8; ++j) {
                                for (int k = -8; k <= 8; ++k) {
                                    BlockPos blockpos1 = this.f_58858_.m_7918_(i, j, k);
                                    BlockState blockstate = this.f_58857_.m_8055_(blockpos1);
                                    if (!(blockstate.m_60734_() instanceof SoulFireBlock)) continue;
                                    this.f_58857_.m_46961_(blockpos1, false);
                                    this.f_58857_.m_5898_((Player)null, 1009, blockpos1, 0);
                                }
                            }
                        }
                    }
                } else {
                    recipe.getRitual().interrupt(this.f_58857_, this.f_58858_, this, this.castingPlayer, handler.getStackInSlot(0));
                    Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)handler.extractItem(0, 1, false));
                }
            }
            this.currentRitualRecipe = null;
            this.castingPlayerId = null;
            this.castingPlayer = null;
            this.currentTime = 0;
            this.sacrificeProvided = false;
            if (this.remainingAdditionalIngredients != null) {
                this.remainingAdditionalIngredients.clear();
            }
            this.consumedIngredients.clear();
            this.structureTime = 0;
            this.m_6596_();
            this.markNetworkDirty();
        }
    }

    public boolean sacrificeFulfilled() {
        return !this.getCurrentRitualRecipe().requiresSacrifice() || this.sacrificeProvided;
    }

    public void notifySacrifice(LivingEntity entityLivingBase) {
        this.sacrificeProvided = true;
    }

    public PositionSource m_142460_() {
        return this.blockPosSource;
    }

    public int m_142078_() {
        return 8;
    }

    public GameEventListener.DeliveryMode m_247514_() {
        return GameEventListener.DeliveryMode.BY_DISTANCE;
    }

    public boolean m_214068_(ServerLevel serverLevel, GameEvent p_282184_, GameEvent.Context p_283014_, Vec3 p_282350_) {
        Entity sourceEntity;
        if (!this.m_58901_() && p_282184_ == GameEvent.f_223707_ && (sourceEntity = p_283014_.f_223711_()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)sourceEntity;
            if (this.getCurrentRitualRecipe() != null && this.getCurrentRitualRecipe().getRitual().isValidSacrifice(livingEntity)) {
                this.notifySacrifice(livingEntity);
            }
            return true;
        }
        return false;
    }

    protected void restoreRemainingAdditionalIngredients() {
        this.remainingAdditionalIngredients = this.f_58857_ == null ? null : (this.consumedIngredients.size() > 0 ? Ritual.getRemainingAdditionalIngredients(this.getCurrentRitualRecipe().m_7527_(), this.consumedIngredients) : new ArrayList<Ingredient>((Collection<Ingredient>)this.getCurrentRitualRecipe().m_7527_()));
    }

    private boolean checkCage() {
        assert (this.f_58857_ != null);
        BlockPos pos = new BlockPos(this.m_58899_().m_123341_(), this.m_58899_().m_123342_() - 1, this.m_58899_().m_123343_());
        BlockState blockState = this.f_58857_.m_8055_(pos);
        if (blockState.m_60713_((Block)ModBlocks.CURSED_CAGE_BLOCK.get())) {
            BlockEntity tileentity = this.f_58857_.m_7702_(pos);
            if (tileentity instanceof CursedCageBlockEntity) {
                this.cursedCageTile = (CursedCageBlockEntity)tileentity;
                return !this.cursedCageTile.getItem().m_41619_() && this.cursedCageTile.getSouls() > 0;
            }
            return false;
        }
        return false;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemStackHandler.cast();
        }
        return super.getCapability(cap, direction);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemStackHandler.invalidate();
    }
}

