/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities;

import com.Polarice3.Goety.common.blocks.CursedInfuserBlock;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntities;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntity;
import com.Polarice3.Goety.common.crafting.CursedInfuserRecipes;
import com.Polarice3.Goety.common.crafting.ModRecipeSerializer;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CursedInfuserBlockEntity
extends ModBlockEntity
implements Clearable,
WorldlyContainer {
    private static final int[] SLOTS = new int[]{0};
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    private final int[] cookingProgress = new int[1];
    private final int[] cookingTime = new int[1];

    public CursedInfuserBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.CURSED_INFUSER.get(), blockPos, blockState);
    }

    public void tick() {
        boolean flag = this.checkSpawner();
        assert (this.f_58857_ != null);
        if (!this.f_58857_.f_46443_) {
            if (flag) {
                this.makeParticles();
                for (ItemStack item : this.items) {
                    if (item.m_41619_()) continue;
                    this.makeWorkParticles();
                }
                this.work();
            } else {
                for (int i = 0; i < this.items.size(); ++i) {
                    if (this.cookingProgress[i] <= 0) continue;
                    this.cookingProgress[i] = Mth.m_14045_((int)(this.cookingProgress[i] - 2), (int)0, (int)this.cookingTime[i]);
                }
            }
        }
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)CursedInfuserBlock.LIT, (Comparable)Boolean.valueOf(this.checkSpawner())), 3);
    }

    private void work() {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.items.get(i);
            if (itemstack.m_41619_()) continue;
            SimpleContainer iinventory = new SimpleContainer(new ItemStack[]{itemstack});
            assert (this.f_58857_ != null);
            ItemStack itemstack1 = this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipeSerializer.CURSED_INFUSER.get(), (Container)iinventory, this.f_58857_).map(arg_0 -> this.lambda$work$0((Container)iinventory, arg_0)).orElse(itemstack);
            if (itemstack != itemstack1) {
                int n = i;
                this.cookingProgress[n] = this.cookingProgress[n] + 1;
            }
            if (this.cookingProgress[i] % 20 == 0) {
                this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11907_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (this.cookingProgress[i] < this.cookingTime[i]) continue;
            this.items.set(i, (Object)ItemStack.f_41583_);
            BlockPos blockpos = this.m_58899_();
            Containers.m_18992_((Level)this.f_58857_, (double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), (ItemStack)itemstack1);
            this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.markUpdated();
            this.cookingProgress[i] = 0;
        }
    }

    public boolean placeItem(ItemStack pStack, int pCookTime) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.items.get(i);
            if (!itemstack.m_41619_()) continue;
            this.cookingTime[i] = pCookTime;
            this.cookingProgress[i] = 0;
            this.items.set(i, (Object)pStack.m_41620_(1));
            assert (this.f_58857_ != null);
            this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11675_, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.markUpdated();
            return true;
        }
        return false;
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public ItemStack m_8020_(int pIndex) {
        return (ItemStack)this.items.get(pIndex);
    }

    public ItemStack m_7407_(int pIndex, int pCount) {
        return ContainerHelper.m_18969_(this.items, (int)pIndex, (int)pCount);
    }

    public ItemStack m_8016_(int pIndex) {
        return ContainerHelper.m_18966_(this.items, (int)pIndex);
    }

    public void m_6836_(int pIndex, ItemStack pStack) {
        Optional<CursedInfuserRecipes> optional = this.getRecipes(pStack);
        optional.ifPresent(furnaceRecipe -> this.placeItem(pStack, furnaceRecipe.getCookingTime()));
    }

    public boolean m_6542_(Player pPlayer) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return pPlayer.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    private void makeParticles() {
        block3: {
            double d2;
            double d1;
            double d0;
            long t;
            ServerLevel serverLevel;
            block4: {
                BlockPos blockpos = this.m_58899_();
                serverLevel = (ServerLevel)this.f_58857_;
                if (serverLevel == null) break block3;
                t = serverLevel.m_46467_();
                d0 = (double)blockpos.m_123341_() + serverLevel.f_46441_.m_188500_();
                d1 = (double)blockpos.m_123342_() + serverLevel.f_46441_.m_188500_();
                d2 = (double)blockpos.m_123343_() + serverLevel.f_46441_.m_188500_();
                if (!((Boolean)this.m_58900_().m_61143_((Property)CursedInfuserBlock.WATERLOGGED)).booleanValue()) break block4;
                if (t % 20L != 0L) break block3;
                for (int p = 0; p < 4; ++p) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123774_, d0, d1, d2, 0, 0.0, 0.04, 0.0, 0.5);
                }
                break block3;
            }
            if (t % 20L == 0L) {
                for (int p = 0; p < 4; ++p) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0, 0.0, 5.0E-4, 0.0, 0.5);
                }
            }
        }
    }

    private void makeWorkParticles() {
        block4: {
            BlockPos blockpos = this.m_58899_();
            ServerLevel serverLevel = (ServerLevel)this.f_58857_;
            if (serverLevel == null) break block4;
            double d0 = (double)blockpos.m_123341_() + serverLevel.f_46441_.m_188500_();
            double d1 = (double)blockpos.m_123342_() + serverLevel.f_46441_.m_188500_();
            double d2 = (double)blockpos.m_123343_() + serverLevel.f_46441_.m_188500_();
            if (((Boolean)this.m_58900_().m_61143_((Property)CursedInfuserBlock.WATERLOGGED)).booleanValue()) {
                for (int p = 0; p < 4; ++p) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123774_, d0, d1, d2, 0, 0.0, 0.04, 0.0, 0.5);
                }
            } else {
                for (int p = 0; p < 6; ++p) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, d0, d1, d2, 1, 0.0, 0.0, 0.0, 0.0);
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0, 0.0, 5.0E-4, 0.0, 0.5);
                }
            }
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public void readNetwork(CompoundTag compoundNBT) {
        this.items.clear();
        ContainerHelper.m_18980_((CompoundTag)compoundNBT, this.items);
        if (compoundNBT.m_128425_("CookingTimes", 11)) {
            int[] aint = compoundNBT.m_128465_("CookingTimes");
            System.arraycopy(aint, 0, this.cookingProgress, 0, Math.min(this.cookingTime.length, aint.length));
        }
        if (compoundNBT.m_128425_("CookingTotalTimes", 11)) {
            int[] aint1 = compoundNBT.m_128465_("CookingTotalTimes");
            System.arraycopy(aint1, 0, this.cookingTime, 0, Math.min(this.cookingTime.length, aint1.length));
        }
    }

    @Override
    public CompoundTag writeNetwork(CompoundTag pCompound) {
        this.saveMetadataAndItems(pCompound);
        pCompound.m_128385_("CookingTimes", this.cookingProgress);
        pCompound.m_128385_("CookingTotalTimes", this.cookingTime);
        return pCompound;
    }

    private CompoundTag saveMetadataAndItems(CompoundTag pCompound) {
        ContainerHelper.m_18976_((CompoundTag)pCompound, this.items, (boolean)true);
        return pCompound;
    }

    private boolean checkSpawner() {
        assert (this.f_58857_ != null);
        return this.f_58857_.m_8055_(new BlockPos(this.m_58899_().m_123341_(), this.m_58899_().m_123342_() - 1, this.m_58899_().m_123343_())).m_60713_(Blocks.f_50085_);
    }

    public Optional<CursedInfuserRecipes> getRecipes(ItemStack pStack) {
        return this.items.stream().noneMatch(ItemStack::m_41619_) ? Optional.empty() : this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipeSerializer.CURSED_INFUSER.get(), (Container)new SimpleContainer(new ItemStack[]{pStack}), this.f_58857_);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public int[] m_7071_(Direction pSide) {
        return SLOTS;
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        Optional<CursedInfuserRecipes> optional = this.getRecipes(pItemStack);
        if (!optional.isPresent()) {
            return false;
        }
        if (!this.checkSpawner()) {
            return false;
        }
        assert (this.f_58857_ != null);
        return !this.f_58857_.f_46443_ && this.placeItem(pItemStack, optional.get().getCookingTime());
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return false;
    }

    private /* synthetic */ ItemStack lambda$work$0(Container iinventory, CursedInfuserRecipes recipes) {
        return recipes.m_5874_(iinventory, this.f_58857_.m_9598_());
    }
}

