/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities;

import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntities;
import com.Polarice3.Goety.common.blocks.entities.SoulCandlestickBlockEntity;
import com.Polarice3.Goety.common.blocks.properties.ModStateProperties;
import com.Polarice3.Goety.common.crafting.BrewingRecipe;
import com.Polarice3.Goety.common.crafting.ModRecipeSerializer;
import com.Polarice3.Goety.common.effects.brew.BrewEffect;
import com.Polarice3.Goety.common.effects.brew.BrewEffectInstance;
import com.Polarice3.Goety.common.effects.brew.BrewEffects;
import com.Polarice3.Goety.common.effects.brew.PotionBrewEffect;
import com.Polarice3.Goety.common.effects.brew.modifiers.BrewModifier;
import com.Polarice3.Goety.common.effects.brew.modifiers.CapacityModifier;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.items.curios.WitchHatItem;
import com.Polarice3.Goety.common.items.magic.TaglockKit;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BrewUtils;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.SEHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.LavaFluid;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BrewCauldronBlockEntity
extends BlockEntity
implements Container {
    private final List<SoulCandlestickBlockEntity> candlestickBlockEntityList = Lists.newArrayList();
    private final List<BlockPos> witchPoles = Lists.newArrayList();
    public static int WATER_COLOR = 4159204;
    public static int FAILED_COLOR = 7160867;
    public NonNullList<ItemStack> container = NonNullList.m_122780_((int)32, (Object)ItemStack.f_41583_);
    public Mode mode = Mode.IDLE;
    public boolean isBrewing = false;
    public int liquidColor = WATER_COLOR;
    public int capacity = 0;
    public int capacityUsed = 0;
    public int duration = 0;
    public int amplifier = 0;
    public int aoe = 0;
    public int heatTime = 0;
    public int totalCost = 0;
    public int soulTime = 0;
    public int quaff = 0;
    public int takeBrew = 0;
    public int update = 0;
    public float velocity = 0.0f;
    public float lingering = 0.0f;

    public BrewCauldronBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)ModBlockEntities.BREWING_CAULDRON.get(), p_155229_, p_155230_);
    }

    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            if (this.checkFire()) {
                if (!this.isHeated()) {
                    ++this.heatTime;
                } else if ((Integer)this.m_58900_().m_61143_((Property)ModStateProperties.LEVEL_BREW) > 0) {
                    Level level;
                    if (this.f_58857_.m_46467_() % 60L == 0L || this.isBrewing) {
                        this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.CAULDRON_BUBBLES.get(), SoundSource.BLOCKS, 0.33f, this.mode == Mode.FAILED ? 0.5f : 1.0f);
                    }
                    if (this.mode == Mode.BREWING && this.f_58857_.m_46467_() % 60L == 0L && this.f_58857_.f_46441_.m_188499_()) {
                        this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.CAULDRON_CHIMES.get(), SoundSource.BLOCKS, 0.15f, this.f_58857_.f_46441_.m_188501_() * 0.4f + 0.8f);
                    }
                    this.findCandlesticks();
                    if (this.isBrewing && this.mode == Mode.BREWING) {
                        if (!this.candlestickBlockEntityList.isEmpty()) {
                            if (this.soulTime < this.getBrewCost()) {
                                for (SoulCandlestickBlockEntity soulCandlestickBlockEntity : this.candlestickBlockEntityList) {
                                    if (soulCandlestickBlockEntity.getSouls() <= 0) continue;
                                    soulCandlestickBlockEntity.drainSouls(1, this.m_58899_());
                                    ++this.soulTime;
                                }
                            } else {
                                this.setColor(PotionUtils.m_43575_((ItemStack)this.getBrew()));
                                this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.CAST_SPELL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                                this.soulTime = 0;
                                this.totalCost = 0;
                                this.isBrewing = false;
                                this.mode = Mode.COMPLETED;
                            }
                        } else {
                            this.fail();
                        }
                    }
                    if (this.mode == Mode.COMPLETED && (level = this.f_58857_) instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        float f = 1.0f;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123771_, (double)((float)this.f_58858_.m_123341_() + 0.5f) + Math.cos((double)serverLevel.m_46467_() * 0.25) * (double)f, (double)this.f_58858_.m_123342_(), (double)((float)this.f_58858_.m_123343_() + 0.5f) + Math.sin((double)serverLevel.m_46467_() * 0.25) * (double)f, 0, 0.0, 0.0, 0.0, 0.5);
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123771_, (double)((float)this.f_58858_.m_123341_() + 0.5f) + Math.cos((double)serverLevel.m_46467_() * 0.25 + Math.PI) * (double)f, (double)this.f_58858_.m_123342_(), (double)((float)this.f_58858_.m_123343_() + 0.5f) + Math.sin((double)serverLevel.m_46467_() * 0.25 + Math.PI) * (double)f, 0, 0.0, 0.0, 0.0, 0.5);
                    }
                } else {
                    this.reset();
                }
            } else {
                this.isBrewing = false;
                this.soulTime = 0;
                this.totalCost = 0;
                this.mode = Mode.IDLE;
                if (this.heatTime > 0) {
                    --this.heatTime;
                }
            }
            if (this.update > 0) {
                --this.update;
                if (this.update <= 1) {
                    this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)ModStateProperties.LEVEL_BREW, (Comparable)Integer.valueOf(3)));
                    this.update = 0;
                }
            }
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)ModStateProperties.FAILED, (Comparable)Boolean.valueOf(this.mode == Mode.FAILED)));
            this.markUpdated();
        }
    }

    public boolean isHeated() {
        return this.heatTime == MathHelper.secondsToTicks(5);
    }

    private int getFirstEmptySlot() {
        for (int i = 0; i < this.getCapacity(); ++i) {
            if (!this.m_8020_(i).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public void brew() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            if (this.mode == Mode.BREWING && !this.isBrewing) {
                this.isBrewing = true;
                this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.PREPARE_SPELL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            this.markUpdated();
        }
    }

    public Mode insertItem(ItemStack itemStack) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            Item ingredient = itemStack.m_41720_();
            BrewModifier brewModifier = new BrewEffects().getModifier(ingredient);
            int modLevel = brewModifier != null ? brewModifier.getLevel() : -1;
            boolean activate = brewModifier instanceof CapacityModifier && brewModifier.getLevel() == 0;
            int firstEmpty = this.getFirstEmptySlot();
            if (firstEmpty != -1) {
                this.m_6836_(firstEmpty, itemStack);
                if (this.mode == Mode.IDLE && this.getCapacity() < 4 && activate) {
                    this.m_6211_();
                    this.capacity = 4;
                    Level level = this.f_58857_;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        for (int k = 0; k < 20; ++k) {
                            float f2 = serverLevel.f_46441_.m_188501_() * 4.0f;
                            float f1 = serverLevel.f_46441_.m_188501_() * ((float)Math.PI * 2);
                            double d1 = Mth.m_14089_((float)f1) * f2;
                            double d2 = 0.01 + serverLevel.f_46441_.m_188500_() * 0.5;
                            double d3 = Mth.m_14031_((float)f1) * f2;
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123771_, (double)this.m_58899_().m_123341_() + 0.5 + d1 * 0.1, (double)this.m_58899_().m_123342_() + 0.5 + 0.3, (double)this.m_58899_().m_123343_() + 0.5 + d3 * 0.1, 0, d1, d2, d3, 0.25);
                        }
                    }
                    return Mode.BREWING;
                }
                if (this.mode == Mode.BREWING) {
                    BrewingRecipe brewingRecipe = this.f_58857_.m_7465_().m_44013_((RecipeType)ModRecipeSerializer.BREWING_TYPE.get()).stream().filter(recipe -> recipe.input.test(itemStack)).findFirst().orElse(null);
                    BrewEffect brewEffect = new BrewEffects().getEffectFromCatalyst(ingredient);
                    if (this.hasNoAugmentation() && (brewingRecipe != null || brewEffect != null)) {
                        if (brewingRecipe != null && brewingRecipe.getCapacityExtra() + this.capacityUsed < this.getCapacity()) {
                            this.capacityUsed += brewingRecipe.getCapacityExtra();
                            this.addCost(brewingRecipe.soulCost);
                            this.setColor(BrewUtils.getColor(this.getBrew()));
                            return Mode.BREWING;
                        }
                        if (brewEffect != null && brewEffect.getCapacityExtra() + this.capacityUsed < this.getCapacity()) {
                            this.capacityUsed += brewEffect.getCapacityExtra();
                            this.addCost(brewEffect.getSoulCost());
                            this.setColor(BrewUtils.getColor(this.getBrew()));
                            return Mode.BREWING;
                        }
                    }
                    if (brewModifier != null) {
                        if (BrewUtils.hasEffect(this.getBrew())) {
                            if (brewModifier.getId().equals(BrewModifier.HIDDEN) || brewModifier.getId().equals(BrewModifier.SPLASH) || brewModifier.getId().equals(BrewModifier.LINGERING) || brewModifier.getId().equals(BrewModifier.GAS)) {
                                if (brewModifier.getId().equals(BrewModifier.HIDDEN)) {
                                    this.addCost(10.0f);
                                }
                                return Mode.BREWING;
                            }
                            if (brewModifier.getId().equals(BrewModifier.DURATION)) {
                                if (this.getDuration() == 0 && modLevel == 0) {
                                    ++this.duration;
                                    this.multiplyCost(1.25f);
                                    return Mode.BREWING;
                                }
                                if (this.getDuration() == 1 && modLevel == 1) {
                                    ++this.duration;
                                    this.multiplyCost(1.5f);
                                    return Mode.BREWING;
                                }
                                if (this.getDuration() == 2 && modLevel == 2) {
                                    ++this.duration;
                                    this.multiplyCost(2.0f);
                                    return Mode.BREWING;
                                }
                            }
                            if (brewModifier.getId().equals(BrewModifier.AMPLIFIER)) {
                                if (this.getAmplifier() == 0 && modLevel == 0) {
                                    ++this.amplifier;
                                    this.multiplyCost(2.0f);
                                    return Mode.BREWING;
                                }
                                if (this.getAmplifier() == 1 && modLevel == 1) {
                                    ++this.amplifier;
                                    this.multiplyCost(2.5f);
                                    return Mode.BREWING;
                                }
                                if (this.getAmplifier() == 2 && modLevel == 2) {
                                    ++this.amplifier;
                                    this.multiplyCost(3.0f);
                                    return Mode.BREWING;
                                }
                            }
                            if (brewModifier.getId().equals(BrewModifier.AOE)) {
                                if (this.getAoE() == 0 && modLevel == 0) {
                                    ++this.aoe;
                                    this.multiplyCost(1.25f);
                                    return Mode.BREWING;
                                }
                                if (this.getAoE() == 1 && modLevel == 1) {
                                    ++this.aoe;
                                    this.multiplyCost(1.5f);
                                    return Mode.BREWING;
                                }
                                if (this.getAoE() == 2 && modLevel == 2) {
                                    ++this.aoe;
                                    this.multiplyCost(2.0f);
                                    return Mode.BREWING;
                                }
                            }
                            if (brewModifier.getId().equals(BrewModifier.LINGER)) {
                                if (this.getLingering() == 0.0f && modLevel == 0) {
                                    this.lingering += 1.0f;
                                    this.multiplyCost(1.25f);
                                    return Mode.BREWING;
                                }
                                if (this.getLingering() == 1.0f && modLevel == 1) {
                                    this.lingering += 1.0f;
                                    this.multiplyCost(1.25f);
                                    return Mode.BREWING;
                                }
                                if (this.getLingering() == 2.0f && modLevel == 2) {
                                    this.lingering += 1.0f;
                                    this.multiplyCost(1.25f);
                                    return Mode.BREWING;
                                }
                            }
                            if (brewModifier.getId().equals(BrewModifier.QUAFF)) {
                                if (this.getQuaff() == 0 && modLevel == 0) {
                                    this.quaff += 8;
                                    this.multiplyCost(1.25f);
                                    return Mode.BREWING;
                                }
                                if (this.getQuaff() == 8 && modLevel == 1) {
                                    this.quaff += 8;
                                    this.multiplyCost(1.25f);
                                    return Mode.BREWING;
                                }
                                if (this.getQuaff() == 16 && modLevel == 2) {
                                    this.quaff += 8;
                                    this.multiplyCost(1.25f);
                                    return Mode.BREWING;
                                }
                            }
                            if (brewModifier.getId().equals(BrewModifier.VELOCITY)) {
                                if (this.getVelocity() == 0.0f && modLevel == 0) {
                                    this.velocity += 0.1f;
                                    this.multiplyCost(1.25f);
                                    return Mode.BREWING;
                                }
                                if (this.getVelocity() == 0.1f && modLevel == 1) {
                                    this.velocity += 0.2f;
                                    this.multiplyCost(1.25f);
                                    return Mode.BREWING;
                                }
                                if (this.getVelocity() == 0.3f && modLevel == 2) {
                                    this.velocity += 0.2f;
                                    this.multiplyCost(1.25f);
                                    return Mode.BREWING;
                                }
                            }
                        } else if (brewModifier instanceof CapacityModifier) {
                            CapacityModifier capacityModifier = (CapacityModifier)brewModifier;
                            if (this.getCapacity() == 4 && capacityModifier.getLevel() == 1) {
                                this.capacity += 2;
                                this.m_6211_();
                                return Mode.BREWING;
                            }
                            if (this.getCapacity() == 6 && capacityModifier.getLevel() == 2) {
                                this.capacity += 2;
                                this.m_6211_();
                                return Mode.BREWING;
                            }
                            if (this.getCapacity() == 8 && capacityModifier.getLevel() == 3) {
                                this.capacity += 2;
                                this.m_6211_();
                                return Mode.BREWING;
                            }
                            if (this.getCapacity() == 10 && capacityModifier.getLevel() == 4) {
                                this.capacity += 2;
                                this.m_6211_();
                                return Mode.BREWING;
                            }
                            if (this.getCapacity() == 12 && capacityModifier.getLevel() == 5) {
                                this.capacity += 4;
                                this.m_6211_();
                                return Mode.BREWING;
                            }
                        }
                    }
                }
            } else if (this.mode == Mode.IDLE && this.getCapacity() < 4 && activate) {
                this.m_6211_();
                this.capacity = 4;
                Level brewEffect = this.f_58857_;
                if (brewEffect instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)brewEffect;
                    for (int k = 0; k < 20; ++k) {
                        float f2 = serverLevel.f_46441_.m_188501_() * 4.0f;
                        float f1 = serverLevel.f_46441_.m_188501_() * ((float)Math.PI * 2);
                        double d1 = Mth.m_14089_((float)f1) * f2;
                        double d2 = 0.01 + serverLevel.f_46441_.m_188500_() * 0.5;
                        double d3 = Mth.m_14031_((float)f1) * f2;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123771_, (double)this.m_58899_().m_123341_() + 0.5 + d1 * 0.1, (double)this.m_58899_().m_123342_() + 0.5 + 0.3, (double)this.m_58899_().m_123343_() + 0.5 + d3 * 0.1, 0, d1, d2, d3, 0.25);
                    }
                }
                return Mode.BREWING;
            }
            this.markUpdated();
        }
        return this.fail();
    }

    public void commonReset() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.setColor(WATER_COLOR, false);
            this.isBrewing = false;
            this.capacity = 0;
            this.capacityUsed = 0;
            this.soulTime = 0;
            this.totalCost = 0;
            this.duration = 0;
            this.amplifier = 0;
            this.aoe = 0;
            this.quaff = 0;
            this.velocity = 0.0f;
            this.lingering = 0.0f;
            this.takeBrew = 0;
            this.m_6211_();
            this.markUpdated();
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)ModStateProperties.LEVEL_BREW, (Comparable)Integer.valueOf(0)), 3);
        }
    }

    public void fullReset() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.commonReset();
            this.mode = Mode.IDLE;
        }
    }

    public Mode reset() {
        this.commonReset();
        return Mode.IDLE;
    }

    public Mode fail() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.setColor(FAILED_COLOR);
            this.isBrewing = false;
            this.capacity = 0;
            this.soulTime = 0;
            this.totalCost = 0;
            this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)SoundEvents.f_12217_.get(), SoundSource.BLOCKS, 5.0f, 0.75f);
            this.markUpdated();
        }
        return Mode.FAILED;
    }

    public void setColor(int color) {
        this.setColor(color, true);
    }

    public void setColor(int color, boolean update) {
        if (this.f_58857_ != null) {
            this.liquidColor = color;
            if (!this.f_58857_.f_46443_) {
                if (update && (Integer)this.f_58857_.m_8055_(this.m_58899_()).m_61143_((Property)ModStateProperties.LEVEL_BREW) == 3) {
                    this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)ModStateProperties.LEVEL_BREW, (Comparable)Integer.valueOf(4)));
                    this.update = 3;
                }
                this.markUpdated();
            }
        }
    }

    public int getColor() {
        return this.liquidColor;
    }

    public ItemStack getBrew() {
        ItemStack brew = new ItemStack((ItemLike)ModItems.BREW.get());
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            Object type;
            int i;
            ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
            ArrayList<BrewEffectInstance> blockEffects = new ArrayList<BrewEffectInstance>();
            int hidden = 0;
            for (i = 0; i < this.getCapacity(); ++i) {
                ItemStack itemStack = this.m_8020_(i);
                Item item = itemStack.m_41720_();
                BrewModifier brewModifier = new BrewEffects().getModifier(item);
                BrewEffect brewEffect = new BrewEffects().getEffectFromCatalyst(item);
                BrewingRecipe brewingRecipe = this.f_58857_.m_7465_().m_44013_((RecipeType)ModRecipeSerializer.BREWING_TYPE.get()).stream().filter(recipe -> recipe.input.test(itemStack)).findFirst().orElse(null);
                if (brewingRecipe != null && effects.stream().noneMatch(effect -> effect.m_19544_() == brewingRecipe.output)) {
                    effects.add(new MobEffectInstance(brewingRecipe.output, brewingRecipe.duration));
                    continue;
                }
                if (brewEffect != null) {
                    if (brewEffect instanceof PotionBrewEffect) {
                        PotionBrewEffect potionBrewEffect = (PotionBrewEffect)brewEffect;
                        effects.add(new MobEffectInstance(potionBrewEffect.mobEffect, potionBrewEffect.duration));
                        continue;
                    }
                    blockEffects.add(new BrewEffectInstance(brewEffect, 1));
                    continue;
                }
                if (brewModifier == null) continue;
                if (brewModifier.getId().equals(BrewModifier.HIDDEN)) {
                    ++hidden;
                    continue;
                }
                if (brewModifier.getId().equals(BrewModifier.SPLASH) && brew.m_150930_((Item)ModItems.BREW.get())) {
                    brew = new ItemStack((ItemLike)ModItems.SPLASH_BREW.get());
                    continue;
                }
                if (brewModifier.getId().equals(BrewModifier.LINGERING) && brew.m_150930_((Item)ModItems.SPLASH_BREW.get())) {
                    brew = new ItemStack((ItemLike)ModItems.LINGERING_BREW.get());
                    continue;
                }
                if (!brewModifier.getId().equals(BrewModifier.GAS) || !brew.m_150930_((Item)ModItems.LINGERING_BREW.get())) continue;
                brew = new ItemStack((ItemLike)ModItems.GAS_BREW.get());
            }
            for (i = 0; i < effects.size(); ++i) {
                int j;
                for (j = 0; j < this.getDuration(); ++j) {
                    type = ((MobEffectInstance)effects.get(i)).m_19544_();
                    int duration = ((MobEffectInstance)effects.get(i)).m_19557_();
                    effects.set(i, new MobEffectInstance(type, type.m_8093_() ? duration : duration * 2));
                }
                for (j = 0; j < this.getAmplifier(); ++j) {
                    type = ((MobEffectInstance)effects.get(i)).m_19544_();
                    int duration = ((MobEffectInstance)effects.get(i)).m_19557_();
                    effects.set(i, new MobEffectInstance(type, type.m_8093_() ? duration : duration / 2, ((MobEffectInstance)effects.get(i)).m_19564_() + 1));
                }
                for (j = 0; j < hidden; ++j) {
                    type = ((MobEffectInstance)effects.get(i)).m_19544_();
                    int duration = ((MobEffectInstance)effects.get(i)).m_19557_();
                    int amplifier = ((MobEffectInstance)effects.get(i)).m_19564_();
                    effects.set(i, new MobEffectInstance(type, duration, amplifier, false, false, false));
                }
            }
            for (i = 0; i < blockEffects.size(); ++i) {
                int duration;
                int j;
                for (j = 0; j < this.getDuration(); ++j) {
                    type = ((BrewEffectInstance)blockEffects.get(i)).getEffect();
                    duration = ((BrewEffectInstance)blockEffects.get(i)).getDuration();
                    blockEffects.set(i, new BrewEffectInstance((BrewEffect)type, duration));
                }
                for (j = 0; j < this.getAmplifier(); ++j) {
                    type = ((BrewEffectInstance)blockEffects.get(i)).getEffect();
                    duration = ((BrewEffectInstance)blockEffects.get(i)).getDuration();
                    blockEffects.set(i, new BrewEffectInstance((BrewEffect)type, duration, ((BrewEffectInstance)blockEffects.get(i)).getAmplifier() + 1));
                }
            }
            BrewUtils.setCustomEffects(brew, effects, blockEffects);
            BrewUtils.setAreaOfEffect(brew, this.getAoE());
            BrewUtils.setLingering(brew, this.getLingering());
            BrewUtils.setQuaff(brew, this.getQuaff());
            BrewUtils.setVelocity(brew, this.getVelocity());
            brew.m_41784_().m_128405_("CustomPotionColor", BrewUtils.getColor(effects, blockEffects));
            brew.m_41784_().m_128379_("CustomBrew", true);
            this.markUpdated();
        }
        return brew;
    }

    public boolean hasNoAugmentation() {
        return this.duration <= 0 && this.amplifier <= 0 && this.aoe <= 0 && this.quaff <= 0 && this.velocity <= 0.0f && this.lingering <= 0.0f;
    }

    public void multiplyCost(float cost) {
        this.totalCost = (int)((float)this.totalCost * cost);
        this.discountCost();
    }

    public void addCost(float cost) {
        this.totalCost = (int)((float)this.totalCost + cost);
        this.discountCost();
    }

    public void discountCost() {
        this.findWitchPoles();
        int size = Mth.m_14045_((int)this.witchPoles.size(), (int)0, (int)3);
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                this.totalCost = (int)((float)this.totalCost * 0.99f);
            }
        }
        if (this.f_58857_ != null && this.f_58857_.m_204166_(this.f_58858_).m_203656_(BiomeTags.f_207589_)) {
            this.totalCost = (int)((float)this.totalCost * 0.99f);
        }
    }

    public int getBrewCost() {
        return this.totalCost;
    }

    public int getCapacityUsed() {
        int number = this.capacityUsed;
        for (int i = 0; i < this.m_6643_(); ++i) {
            if (this.m_8020_(i).m_41619_()) continue;
            ++number;
        }
        return number;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public int getAoE() {
        return this.aoe;
    }

    public int getQuaff() {
        return this.quaff;
    }

    public float getVelocity() {
        return this.velocity;
    }

    public float getLingering() {
        return this.lingering;
    }

    public int m_6643_() {
        return this.container.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.container) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack m_8020_(int pIndex) {
        return (ItemStack)this.container.get(pIndex);
    }

    @NotNull
    public ItemStack m_7407_(int pIndex, int pCount) {
        return ContainerHelper.m_18969_(this.container, (int)pIndex, (int)pCount);
    }

    @NotNull
    public ItemStack m_8016_(int pIndex) {
        return ContainerHelper.m_18966_(this.container, (int)pIndex);
    }

    public void m_6836_(int pIndex, @NotNull ItemStack pStack) {
        this.container.set(pIndex, (Object)pStack);
    }

    public boolean m_6542_(Player pPlayer) {
        return pPlayer.m_20275_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5) < 16.0;
    }

    public void m_6211_() {
        this.container.clear();
    }

    public void m_142466_(CompoundTag compoundNBT) {
        this.capacity = compoundNBT.m_128451_("Capacity");
        this.capacityUsed = compoundNBT.m_128451_("CapacityUsed");
        this.duration = compoundNBT.m_128451_("Duration");
        this.amplifier = compoundNBT.m_128451_("Amplifier");
        this.aoe = compoundNBT.m_128451_("AreaOfEffect");
        this.quaff = compoundNBT.m_128451_("Quaff");
        this.heatTime = compoundNBT.m_128451_("HeatTime");
        this.soulTime = compoundNBT.m_128451_("SoulTime");
        this.takeBrew = compoundNBT.m_128451_("TakeBrew");
        this.totalCost = compoundNBT.m_128451_("TotalCost");
        this.update = compoundNBT.m_128451_("ColorUpdate");
        if (compoundNBT.m_128441_("Color")) {
            this.liquidColor = compoundNBT.m_128451_("Color");
        }
        this.velocity = compoundNBT.m_128457_("Velocity");
        this.lingering = compoundNBT.m_128457_("Lingering");
        this.isBrewing = compoundNBT.m_128471_("Brewing");
        if (compoundNBT.m_128441_("Mode")) {
            this.mode = Mode.valueOf(compoundNBT.m_128461_("Mode"));
        }
        this.container = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compoundNBT, this.container);
    }

    public void m_183515_(CompoundTag pCompound) {
        pCompound.m_128405_("Capacity", this.capacity);
        pCompound.m_128405_("CapacityUsed", this.capacityUsed);
        pCompound.m_128405_("Duration", this.duration);
        pCompound.m_128405_("Amplifier", this.amplifier);
        pCompound.m_128405_("AreaOfEffect", this.aoe);
        pCompound.m_128405_("Quaff", this.quaff);
        pCompound.m_128405_("HeatTime", this.heatTime);
        pCompound.m_128405_("SoulTime", this.soulTime);
        pCompound.m_128405_("TakeBrew", this.takeBrew);
        pCompound.m_128405_("TotalCost", this.totalCost);
        pCompound.m_128405_("ColorUpdate", this.update);
        pCompound.m_128405_("Color", this.liquidColor);
        pCompound.m_128350_("Velocity", this.velocity);
        pCompound.m_128350_("Lingering", this.lingering);
        pCompound.m_128379_("Brewing", this.isBrewing);
        pCompound.m_128359_("Mode", this.mode.name());
        ContainerHelper.m_18973_((CompoundTag)pCompound, this.container);
    }

    public int getTargetLevel(ItemStack stack, Player player) {
        if (this.f_58857_ != null) {
            Item item = stack.m_41720_();
            int waterLevel = (Integer)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)ModStateProperties.LEVEL_BREW);
            if (this.mode == Mode.IDLE || this.mode == Mode.FAILED) {
                if (item == Items.f_42446_ && waterLevel == 3) {
                    return 0;
                }
                if (item == Items.f_42447_ && waterLevel == 0) {
                    return 3;
                }
                if (item == Items.f_42590_) {
                    return waterLevel - 1;
                }
                if (item == Items.f_42589_ && waterLevel < 3 && PotionUtils.m_43579_((ItemStack)stack) == Potions.f_43599_) {
                    return waterLevel + 1;
                }
            } else {
                if (this.mode == Mode.COMPLETED) {
                    if (waterLevel >= 3 && TaglockKit.canAffect((LivingEntity)player, stack, Vec3.m_82512_((Vec3i)this.m_58899_()), BrewCauldronBlockEntity.getWitchPoles(this))) {
                        return 0;
                    }
                    if (item == Items.f_42590_ || item == Items.f_42410_) {
                        boolean hat = CuriosFinder.hasCurio((LivingEntity)player, itemStack -> itemStack.m_41720_() instanceof WitchHatItem);
                        boolean croneHat = CuriosFinder.hasCurio((LivingEntity)player, (Item)ModItems.CRONE_HAT.get());
                        boolean robe = CuriosFinder.hasWitchRobe((LivingEntity)player);
                        boolean blackCat = !player.f_19853_.m_6443_(Cat.class, player.m_20191_().m_82377_(16.0, 8.0, 16.0), cat -> cat.m_28554_() == BuiltInRegistries.f_256754_.m_6246_(CatVariant.f_218150_) && cat.m_269323_() == player).isEmpty();
                        float chance = 1.0f;
                        int times = 0;
                        if (croneHat) {
                            times += 2;
                            chance -= 0.25f;
                        } else if (hat) {
                            ++times;
                            chance -= 0.25f;
                        }
                        if (robe) {
                            ++times;
                            chance -= 0.25f;
                        }
                        if (blackCat) {
                            ++times;
                            chance -= 0.25f;
                        }
                        if (player.f_19853_.f_46441_.m_188501_() <= chance || this.takeBrew >= (times += SEHelper.getBottleLevel(player))) {
                            return waterLevel - 1;
                        }
                        ++this.takeBrew;
                        return waterLevel;
                    }
                    return waterLevel;
                }
                return waterLevel;
            }
        }
        return -1;
    }

    private boolean checkFire() {
        LiquidBlock liquidBlock;
        Block block;
        assert (this.f_58857_ != null);
        BlockPos pos = new BlockPos(this.m_58899_().m_123341_(), this.m_58899_().m_123342_() - 1, this.m_58899_().m_123343_());
        BlockState blockState = this.f_58857_.m_8055_(pos);
        return blockState.m_60734_() instanceof BaseFireBlock || (block = blockState.m_60734_()) instanceof LiquidBlock && (liquidBlock = (LiquidBlock)block).getFluid() instanceof LavaFluid || blockState.m_60734_() instanceof MagmaBlock || blockState.m_60734_() instanceof CampfireBlock && (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61443_) != false;
    }

    public void findWitchPoles() {
        if (this.f_58857_ != null) {
            this.witchPoles.clear();
            for (int i = -8; i <= 8; ++i) {
                for (int j = -8; j <= 8; ++j) {
                    for (int k = -8; k <= 8; ++k) {
                        BlockPos blockpos1 = this.m_58899_().m_7918_(i, j, k);
                        if (!this.f_58857_.m_8055_(blockpos1).m_60713_((Block)ModBlocks.WITCH_POLE.get())) continue;
                        this.witchPoles.add(blockpos1);
                    }
                }
            }
        }
    }

    public static int getWitchPoles(BrewCauldronBlockEntity cauldronBlock) {
        cauldronBlock.findWitchPoles();
        return Mth.m_14045_((int)cauldronBlock.witchPoles.size(), (int)0, (int)3);
    }

    private void findCandlesticks() {
        if (this.f_58857_ != null) {
            this.candlestickBlockEntityList.clear();
            for (int i = -8; i <= 8; ++i) {
                for (int j = -8; j <= 8; ++j) {
                    for (int k = -8; k <= 8; ++k) {
                        SoulCandlestickBlockEntity soulCandlestickBlockEntity;
                        BlockPos blockpos1 = this.m_58899_().m_7918_(i, j, k);
                        BlockEntity blockEntity = this.f_58857_.m_7702_(blockpos1);
                        if (!(blockEntity instanceof SoulCandlestickBlockEntity) || (soulCandlestickBlockEntity = (SoulCandlestickBlockEntity)blockEntity).getSouls() <= 0) continue;
                        this.candlestickBlockEntityList.add(soulCandlestickBlockEntity);
                    }
                }
            }
        }
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void markUpdated() {
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public static enum Mode {
        IDLE("idle"),
        BREWING("brewing"),
        COMPLETED("completed"),
        FAILED("failed");

        public final String name;

        private Mode(String name) {
            this.name = name;
        }
    }
}

