/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks;

import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.blocks.entities.RedstoneGolemSkullBlockEntity;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.RedstoneGolem;
import com.Polarice3.Goety.common.items.block.RedstoneGolemSkullItem;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RedstoneGolemSkullBlock
extends BaseEntityBlock {
    public static final IntegerProperty ROTATION = BlockStateProperties.f_61390_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    @Nullable
    private BlockPattern redstoneGolemBase;
    @Nullable
    private BlockPattern redstoneGolemFull;

    public RedstoneGolemSkullBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(1.0f).m_280658_(NoteBlockInstrument.CUSTOM_HEAD).m_278166_(PushReaction.DESTROY));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(0)));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        BlockEntity tileEntity;
        ItemStack itemStack = new ItemStack((ItemLike)this);
        if (player.m_6047_() && (tileEntity = world.m_7702_(pos)) instanceof RedstoneGolemSkullBlockEntity) {
            this.setOwner(itemStack, tileEntity);
            this.setModCustomName(itemStack, tileEntity);
        }
        return itemStack;
    }

    public void setOwner(ItemStack itemStack, BlockEntity tileEntity) {
        if (tileEntity instanceof RedstoneGolemSkullBlockEntity) {
            RedstoneGolemSkullBlockEntity blockEntity = (RedstoneGolemSkullBlockEntity)tileEntity;
            RedstoneGolemSkullItem.setOwner((LivingEntity)blockEntity.getPlayer(), itemStack);
        }
    }

    public void setModCustomName(ItemStack itemStack, BlockEntity tileEntity) {
        RedstoneGolemSkullBlockEntity blockEntity;
        if (tileEntity instanceof RedstoneGolemSkullBlockEntity && (blockEntity = (RedstoneGolemSkullBlockEntity)tileEntity).getCustomName() != null && !blockEntity.getCustomName().isEmpty()) {
            RedstoneGolemSkullItem.setCustomName(blockEntity.getCustomName(), itemStack);
        }
    }

    public void m_6240_(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState, @Nullable BlockEntity pTe, ItemStack pStack) {
        ItemStack itemStack = new ItemStack((ItemLike)this);
        if (pTe instanceof RedstoneGolemSkullBlockEntity) {
            RedstoneGolemSkullBlockEntity blockEntity = (RedstoneGolemSkullBlockEntity)pTe;
            this.setOwner(itemStack, (BlockEntity)blockEntity);
            this.setModCustomName(itemStack, (BlockEntity)blockEntity);
        }
        RedstoneGolemSkullBlock.m_49840_((Level)pLevel, (BlockPos)pPos, (ItemStack)itemStack);
        super.m_6240_(pLevel, pPlayer, pPos, pState, pTe, pStack);
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        if (this.canSpawnGolem((LevelReader)pLevel, pPos)) {
            this.trySpawnGolem(pPlacer, pLevel, pPos, pStack);
        } else {
            BlockEntity tileentity = pLevel.m_7702_(pPos);
            if (tileentity instanceof RedstoneGolemSkullBlockEntity) {
                RedstoneGolemSkullBlockEntity blockEntity = (RedstoneGolemSkullBlockEntity)tileentity;
                blockEntity.setOwnerId(RedstoneGolemSkullItem.getOwnerID(pStack));
                if (RedstoneGolemSkullItem.getCustomName(pStack) != null) {
                    blockEntity.setCustomName(RedstoneGolemSkullItem.getCustomName(pStack));
                }
            }
        }
    }

    public VoxelShape m_5940_(BlockState p_56331_, BlockGetter p_56332_, BlockPos p_56333_, CollisionContext p_56334_) {
        return SHAPE;
    }

    public VoxelShape m_7952_(BlockState p_56336_, BlockGetter p_56337_, BlockPos p_56338_) {
        return Shapes.m_83040_();
    }

    public BlockState m_5573_(BlockPlaceContext p_56321_) {
        return (BlockState)this.m_49966_().m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(Mth.m_14107_((double)((double)(p_56321_.m_7074_() * 16.0f / 360.0f) + 0.5)) & 0xF));
    }

    public BlockState m_6843_(BlockState p_56326_, Rotation p_56327_) {
        return (BlockState)p_56326_.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(p_56327_.m_55949_(((Integer)p_56326_.m_61143_((Property)ROTATION)).intValue(), 16)));
    }

    public BlockState m_6943_(BlockState p_56323_, Mirror p_56324_) {
        return (BlockState)p_56323_.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(p_56324_.m_54843_(((Integer)p_56323_.m_61143_((Property)ROTATION)).intValue(), 16)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{ROTATION});
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    private void trySpawnGolem(LivingEntity living, Level p_51379_, BlockPos p_51380_, ItemStack itemStack) {
        BlockPattern.BlockPatternMatch blockpattern$blockpatternmatch = this.getOrCreateRedstoneGolemFull().m_61184_((LevelReader)p_51379_, p_51380_);
        if (blockpattern$blockpatternmatch != null) {
            for (int j = 0; j < this.getOrCreateRedstoneGolemFull().m_61203_(); ++j) {
                for (int k = 0; k < this.getOrCreateRedstoneGolemFull().m_61202_(); ++k) {
                    BlockInWorld blockinworld2 = blockpattern$blockpatternmatch.m_61229_(j, k, 0);
                    p_51379_.m_7731_(blockinworld2.m_61176_(), Blocks.f_50016_.m_49966_(), 2);
                    p_51379_.m_46796_(2001, blockinworld2.m_61176_(), Block.m_49956_((BlockState)blockinworld2.m_61168_()));
                }
            }
            BlockPos blockpos = blockpattern$blockpatternmatch.m_61229_(1, 2, 0).m_61176_();
            RedstoneGolem redstoneGolem = (RedstoneGolem)((EntityType)ModEntityType.REDSTONE_GOLEM.get()).m_20615_(p_51379_);
            if (redstoneGolem != null) {
                if (RedstoneGolemSkullItem.getOwnerID(itemStack) != null) {
                    redstoneGolem.setOwnerId(RedstoneGolemSkullItem.getOwnerID(itemStack));
                } else if (living != null) {
                    redstoneGolem.setTrueOwner(living);
                }
                String string = RedstoneGolemSkullItem.getCustomName(itemStack);
                if (string != null) {
                    redstoneGolem.m_6593_((Component)Component.m_237113_((String)string));
                }
                redstoneGolem.m_7678_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.05, (double)blockpos.m_123343_() + 0.5, 0.0f, 0.0f);
                if (p_51379_ instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)p_51379_;
                    redstoneGolem.m_6518_((ServerLevelAccessor)serverLevel, p_51379_.m_6436_(p_51380_), MobSpawnType.MOB_SUMMONED, null, null);
                }
                p_51379_.m_7967_((Entity)redstoneGolem);
            }
            for (int i1 = 0; i1 < this.getOrCreateRedstoneGolemFull().m_61203_(); ++i1) {
                for (int j1 = 0; j1 < this.getOrCreateRedstoneGolemFull().m_61202_(); ++j1) {
                    BlockInWorld blockinworld1 = blockpattern$blockpatternmatch.m_61229_(i1, j1, 0);
                    p_51379_.m_6289_(blockinworld1.m_61176_(), Blocks.f_50016_);
                }
            }
        }
    }

    public boolean canSpawnGolem(LevelReader p_51382_, BlockPos p_51383_) {
        return this.getOrCreateRedstoneGolemBase().m_61184_(p_51382_, p_51383_) != null;
    }

    private BlockPattern getOrCreateRedstoneGolemBase() {
        if (this.redstoneGolemBase == null) {
            this.redstoneGolemBase = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"~~ ~~", "$###$", "$$#$$", "$~D~$"}).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50330_))).m_61244_('$', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50450_))).m_61244_('D', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50090_))).m_61244_('~', p_284869_ -> p_284869_.m_61168_().m_60795_()).m_61249_();
        }
        return this.redstoneGolemBase;
    }

    private BlockPattern getOrCreateRedstoneGolemFull() {
        if (this.redstoneGolemFull == null) {
            this.redstoneGolemFull = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"~~^~~", "$###$", "$$#$$", "$~D~$"}).m_61244_('^', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)((Block)ModBlocks.REDSTONE_GOLEM_SKULL_BLOCK.get())).or((Predicate)BlockStatePredicate.m_61287_((Block)((Block)ModBlocks.WALL_REDSTONE_GOLEM_SKULL_BLOCK.get()))))).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50330_))).m_61244_('$', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50450_))).m_61244_('D', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50090_))).m_61244_('~', p_284869_ -> p_284869_.m_61168_().m_60795_()).m_61249_();
        }
        return this.redstoneGolemFull;
    }

    public BlockEntity m_142194_(BlockPos p_151996_, BlockState p_151997_) {
        return new RedstoneGolemSkullBlockEntity(p_151996_, p_151997_);
    }
}

