/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks;

import com.Polarice3.Goety.common.blocks.entities.NecroBrazierBlockEntity;
import com.Polarice3.Goety.utils.ConstantPaths;
import com.Polarice3.Goety.utils.LichdomHelper;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class NecroBrazierBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    protected static final VoxelShape SHAPE_BASE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);
    protected static final VoxelShape SHAPE_2 = Block.m_49796_((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0);
    public static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)SHAPE_BASE, (VoxelShape)SHAPE_2);
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public NecroBrazierBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60978_(3.5f).m_60918_(SoundType.f_56728_).m_60953_(NecroBrazierBlock.litBlockEmission()).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_((Property)LIT, (Comparable)Boolean.FALSE));
    }

    private static ToIntFunction<BlockState> litBlockEmission() {
        return state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? 10 : 0;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity tileentity = pLevel.m_7702_(pPos);
        if (tileentity instanceof NecroBrazierBlockEntity) {
            NecroBrazierBlockEntity burnerTileEntity = (NecroBrazierBlockEntity)tileentity;
            ItemStack itemstack = pPlayer.m_21120_(pHand);
            if (itemstack.m_41619_() || MobUtil.isShifting((Entity)pPlayer)) {
                burnerTileEntity.removeItem(pPlayer);
                return InteractionResult.SUCCESS;
            }
            if (!pLevel.f_46443_ && ((Boolean)pState.m_61143_((Property)LIT)).booleanValue() && burnerTileEntity.addItem(pPlayer, itemstack)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            BlockEntity tileentity = pLevel.m_7702_(pPos);
            if (tileentity instanceof NecroBrazierBlockEntity) {
                Containers.m_19010_((Level)pLevel, (BlockPos)pPos, ((NecroBrazierBlockEntity)tileentity).getItems());
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    public RenderShape m_7514_(BlockState p_222219_) {
        return RenderShape.MODEL;
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (((Boolean)pState.m_61143_((Property)LIT)).booleanValue()) {
            BlockEntity tileentity;
            LivingEntity livingEntity;
            if (!pEntity.m_5825_() && pEntity instanceof LivingEntity && (livingEntity = (LivingEntity)pEntity).m_6336_() != MobType.f_21641_ && !LichdomHelper.isInLichMode(livingEntity) && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)pEntity)) && pEntity.m_20186_() >= (double)((float)pPos.m_123342_() + 0.5f)) {
                pEntity.m_6469_(pEntity.m_269291_().m_269387_(), 1.0f);
            }
            if ((tileentity = pLevel.m_7702_(pPos)) instanceof NecroBrazierBlockEntity) {
                NecroBrazierBlockEntity blockEntity = (NecroBrazierBlockEntity)tileentity;
                if (pEntity instanceof ItemEntity) {
                    ItemEntity itemEntity = (ItemEntity)pEntity;
                    if (!pLevel.f_46443_ && !itemEntity.m_19880_().contains(ConstantPaths.resultItem()) && blockEntity.currentTime <= 0) {
                        blockEntity.addItem(null, itemEntity.m_32055_());
                        pLevel.m_5594_(null, pPos, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        itemEntity.m_146870_();
                    }
                }
            }
        }
        super.m_7892_(pState, pLevel, pPos, pEntity);
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockPos blockpos;
        Level iworld = pContext.m_43725_();
        boolean flag = iworld.m_6425_(blockpos = pContext.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public boolean m_7361_(LevelAccessor pLevel, BlockPos pPos, BlockState pState, FluidState pFluidState) {
        if (!((Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && pFluidState.m_76152_() == Fluids.f_76193_) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.TRUE), 3);
            pLevel.m_186469_(pPos, pFluidState.m_76152_(), pFluidState.m_76152_().m_6718_((LevelReader)pLevel));
            return true;
        }
        return false;
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{WATERLOGGED, LIT});
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new NecroBrazierBlockEntity(p_153215_, p_153216_);
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_152755_, BlockState p_152756_, BlockEntityType<T> p_152757_) {
        return (world, pos, state, blockEntity) -> {
            if (blockEntity instanceof NecroBrazierBlockEntity) {
                NecroBrazierBlockEntity brazierBlock = (NecroBrazierBlockEntity)blockEntity;
                brazierBlock.tick();
            }
        };
    }
}

