/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks;

import com.Polarice3.Goety.utils.BlockFinder;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LampBlock
extends Block
implements SimpleWaterloggedBlock {
    protected static final VoxelShape SHAPE_BASE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    protected static final VoxelShape SHAPE_MID = Block.m_49796_((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)20.0, (double)14.0);
    protected static final VoxelShape SHAPE_TOP = Block.m_49796_((double)0.0, (double)20.0, (double)0.0, (double)16.0, (double)24.0, (double)16.0);
    protected static final VoxelShape SHAPE_BOTTOM = Block.m_49796_((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE_UP = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    protected static final VoxelShape SHAPE_TOP_BASE = Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape SHAPE_TOP_POST = Block.m_49796_((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final VoxelShape SHAPE_LOWER = Shapes.m_83110_((VoxelShape)SHAPE_BASE, (VoxelShape)SHAPE_BOTTOM);
    public static final VoxelShape SHAPE_UPPER = Shapes.m_83124_((VoxelShape)SHAPE_UP, (VoxelShape[])new VoxelShape[]{SHAPE_TOP_BASE, SHAPE_TOP_POST});
    public static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)SHAPE_BASE, (VoxelShape[])new VoxelShape[]{SHAPE_MID, SHAPE_TOP});
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public LampBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60953_(LampBlock.litBlockEmission()).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_((Property)LIT, (Comparable)Boolean.TRUE)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    private static ToIntFunction<BlockState> litBlockEmission() {
        return state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? 14 : 0;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (LampBlock.canLight(pState)) {
            pLevel.m_5594_((Player)null, pPos, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.5f, 0.6f);
            pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.TRUE));
        } else {
            pLevel.m_5594_((Player)null, pPos, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.5f, 0.5f);
            pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.FALSE));
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6402_(Level p_52749_, BlockPos p_52750_, BlockState p_52751_, LivingEntity p_52752_, ItemStack p_52753_) {
        p_52749_.m_7731_(p_52750_.m_7494_(), (BlockState)p_52751_.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public void m_5707_(Level p_52755_, BlockPos p_52756_, BlockState p_52757_, Player p_52758_) {
        if (!p_52755_.f_46443_ && p_52758_.m_7500_()) {
            BlockFinder.preventCreativeDropFromBottomPart(p_52755_, p_52756_, p_52757_, p_52758_);
        }
        super.m_5707_(p_52755_, p_52756_, p_52757_, p_52758_);
    }

    public static boolean canLight(BlockState p_51322_) {
        return (Boolean)p_51322_.m_61143_((Property)LIT) == false;
    }

    public RenderShape m_7514_(BlockState p_222219_) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockPos blockpos;
        Level iworld = pContext.m_43725_();
        boolean flag = iworld.m_6425_(blockpos = pContext.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public boolean m_7898_(BlockState blockState, LevelReader level, BlockPos blockPos) {
        BlockPos blockpos = blockPos.m_7495_();
        BlockState blockstate = level.m_8055_(blockpos);
        return blockState.m_61143_(HALF) == DoubleBlockHalf.LOWER ? super.m_7898_(blockState, level, blockPos) : blockstate.m_60713_((Block)this);
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)pState.m_61143_(HALF);
        if (pFacing.m_122434_() == Direction.Axis.Y && doubleblockhalf == DoubleBlockHalf.LOWER == (pFacing == Direction.UP)) {
            return pFacingState.m_60713_((Block)this) && pFacingState.m_61143_(HALF) != doubleblockhalf ? (BlockState)pState.m_61124_((Property)LIT, (Comparable)((Boolean)pFacingState.m_61143_((Property)LIT))) : Blocks.f_50016_.m_49966_();
        }
        return doubleblockhalf == DoubleBlockHalf.LOWER && pFacing == Direction.DOWN && !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public boolean m_7361_(LevelAccessor pLevel, BlockPos pPos, BlockState pState, FluidState pFluidState) {
        if (!((Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && pFluidState.m_76152_() == Fluids.f_76193_) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.TRUE), 3);
            pLevel.m_186469_(pPos, pFluidState.m_76152_(), pFluidState.m_76152_().m_6718_((LevelReader)pLevel));
            return true;
        }
        return false;
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{WATERLOGGED, LIT, HALF});
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return SHAPE_LOWER;
        }
        if (pState.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            return SHAPE_UPPER;
        }
        return Shapes.m_83144_();
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }
}

