/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.client.render.animation.NecromancerAnimations;
import com.Polarice3.Goety.common.entities.hostile.WitherNecromancer;
import com.Polarice3.Goety.common.entities.neutral.AbstractNecromancer;
import com.Polarice3.Goety.utils.MathHelper;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class WitherNecromancerModel<T extends WitherNecromancer>
extends HierarchicalModel<T> {
    public final ModelPart root;
    public final ModelPart skeleton;
    public final ModelPart body;
    public final ModelPart head;
    public final ModelPart cape;
    public final ModelPart rightArm;
    public final ModelPart leftArm;
    public final ModelPart rightLeg;
    public final ModelPart leftLeg;

    public WitherNecromancerModel(ModelPart root) {
        this.root = root;
        this.skeleton = root.m_171324_("skeleton");
        this.body = this.skeleton.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.cape = this.body.m_171324_("cape");
        this.rightArm = this.body.m_171324_("right_arm");
        this.leftArm = this.body.m_171324_("left_arm");
        this.rightLeg = this.skeleton.m_171324_("right_leg");
        this.leftLeg = this.skeleton.m_171324_("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition skeleton = partdefinition.m_171599_("skeleton", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = skeleton.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition hat = head.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.75f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition horns = hat.m_171599_("horns", CubeListBuilder.m_171558_().m_171514_(24, 92).m_171488_(-9.0f, -37.0f, 0.0f, 18.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)-10.0f, (float)0.0f));
        PartDefinition staff = right_arm.m_171599_("staff", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)9.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition handle = staff.m_171599_("handle", CubeListBuilder.m_171558_().m_171514_(60, 39).m_171488_(0.5f, -16.0f, -19.0f, 1.0f, 24.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(48, 62).m_171488_(-1.5f, -17.0f, -19.0f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(52, 60).m_171488_(2.5f, -18.0f, -19.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(52, 60).m_171488_(-1.5f, -18.0f, -19.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)7.0f, (float)19.0f));
        PartDefinition staffhead = staff.m_171599_("staffhead", CubeListBuilder.m_171558_().m_171514_(48, 50).m_171488_(-0.5f, -20.0f, -20.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)7.0f, (float)19.0f));
        PartDefinition T_NetherSword = staff.m_171599_("T_NetherSword", CubeListBuilder.m_171558_().m_171514_(0, 69).m_171488_(-7.0f, -6.0f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 71).m_171488_(-7.0f, -5.0f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 73).m_171488_(-7.0f, -4.0f, -0.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 75).m_171488_(-6.0f, -3.0f, -0.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(12, 75).m_171488_(-5.0f, -2.0f, -0.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(12, 77).m_171488_(-4.0f, -1.0f, -0.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(8, 69).m_171488_(-3.0f, 0.0f, -0.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 89).m_171488_(5.0f, 1.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 77).m_171488_(-2.0f, 1.0f, -0.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 79).m_171488_(-1.0f, 2.0f, -0.5f, 7.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 81).m_171488_(0.0f, 3.0f, -0.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 83).m_171488_(1.0f, 4.0f, -0.5f, 4.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 85).m_171488_(1.0f, 5.0f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 87).m_171488_(0.0f, 6.0f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.75f, (float)-17.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition right_pauldron = right_arm.m_171599_("right_pauldron", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-4.0f, -4.0f, -3.0f, 5.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)1.0f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171480_().m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)-10.0f, (float)0.0f));
        PartDefinition leftItem = left_arm.m_171599_("leftItem", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)7.0f, (float)1.0f));
        PartDefinition left_pauldron = left_arm.m_171599_("left_pauldron", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171480_().m_171488_(-1.0f, -4.0f, -3.0f, 5.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)1.0f));
        PartDefinition pants = body.m_171599_("pants", CubeListBuilder.m_171558_().m_171514_(16, 32).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition middle = pants.m_171599_("middle", CubeListBuilder.m_171558_().m_171514_(40, 36).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-2.0f));
        PartDefinition cape = body.m_171599_("cape", CubeListBuilder.m_171558_().m_171514_(24, 64).m_171488_(-8.0f, 0.0f, -2.0f, 16.0f, 24.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)1.0f));
        PartDefinition right_leg = skeleton.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition left_leg = skeleton.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)-12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (!entity.m_21224_()) {
            if (((WitherNecromancer)entity).cantDo > 0) {
                this.head.f_104205_ = 0.3f * Mth.m_14031_((float)(0.45f * ageInTicks));
                this.head.f_104203_ = 0.4f;
            } else {
                this.animateHeadLookTarget(netHeadYaw, headPitch);
            }
            if (this.f_102609_) {
                this.rightLeg.f_104203_ = -1.4137167f;
                this.rightLeg.f_104204_ = 0.31415927f;
                this.rightLeg.f_104205_ = 0.07853982f;
                this.leftLeg.f_104203_ = -1.4137167f;
                this.leftLeg.f_104204_ = -0.31415927f;
                this.leftLeg.f_104205_ = -0.07853982f;
            } else if (entity.m_5912_() || !((WitherNecromancer)entity).walkAnimationState.m_216984_()) {
                this.animateWalk(entity, limbSwing, limbSwingAmount);
            }
        }
        Vec3 velocity = entity.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        this.m_233381_(((WitherNecromancer)entity).idleAnimationState, NecromancerAnimations.ALERT, ageInTicks);
        if (this.f_102609_) {
            this.rightLeg.f_104203_ = -1.4137167f;
            this.rightLeg.f_104204_ = 0.31415927f;
            this.rightLeg.f_104205_ = 0.07853982f;
            this.leftLeg.f_104203_ = -1.4137167f;
            this.leftLeg.f_104204_ = -0.31415927f;
            this.leftLeg.f_104205_ = -0.07853982f;
        } else {
            this.m_233385_(((WitherNecromancer)entity).walkAnimationState, NecromancerAnimations.WALK, ageInTicks, groundSpeed * 10.0f);
        }
        this.m_233385_(((WitherNecromancer)entity).attackAnimationState, NecromancerAnimations.ATTACK, ageInTicks, ((AbstractNecromancer)entity).getAttackSpeed());
        this.m_233381_(((WitherNecromancer)entity).summonAnimationState, NecromancerAnimations.SUMMON, ageInTicks);
        this.m_233381_(((WitherNecromancer)entity).spellAnimationState, NecromancerAnimations.SPELL, ageInTicks);
    }

    private void animateWalk(T entity, float limbSwing, float limbSwingAmount) {
        float f = 1.0f;
        if (entity.m_21256_() > 4) {
            f = (float)entity.m_20184_().m_82556_();
            f /= 0.2f;
            f = f * f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.cape.f_104203_ = MathHelper.modelDegrees(10.0f) + Mth.m_14154_((float)(Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.7f * limbSwingAmount / f));
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
    }

    private void animateHeadLookTarget(float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

