/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.client.render.animation.StormCasterAnimations;
import com.Polarice3.Goety.common.entities.hostile.illagers.StormCaster;
import com.Polarice3.Goety.utils.MathHelper;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class StormCasterModel<T extends StormCaster>
extends HierarchicalModel<T>
implements HeadedModel {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart cape;
    private final ModelPart right_leg;
    private final ModelPart left_leg;
    private final ModelPart right_arm;
    private final ModelPart left_arm;

    public StormCasterModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.cape = this.body.m_171324_("cape");
        this.right_leg = root.m_171324_("right_leg");
        this.left_leg = root.m_171324_("left_leg");
        this.right_arm = root.m_171324_("right_arm");
        this.left_arm = root.m_171324_("left_arm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition hair = head.m_171599_("hair", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition bone = hair.m_171599_("bone", CubeListBuilder.m_171558_().m_171514_(46, -8).m_171488_(1.0f, -3.0f, -4.0f, 0.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-8.0f, (float)-7.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition bone2 = hair.m_171599_("bone2", CubeListBuilder.m_171558_().m_171514_(46, -8).m_171480_().m_171488_(-1.0f, -3.0f, -4.0f, 0.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)8.0f, (float)-7.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition bone3 = hair.m_171599_("bone3", CubeListBuilder.m_171558_().m_171514_(46, -8).m_171480_().m_171488_(-1.0f, -3.0f, -4.0f, 0.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-7.0f, (float)8.0f, (float)-1.5708f, (float)-0.7854f, (float)1.5708f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 38).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 20.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cape = body.m_171599_("cape", CubeListBuilder.m_171558_().m_171514_(44, 8).m_171488_(-4.5f, -1.5f, 0.0f, 9.0f, 20.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)3.0f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition Staff = right_arm.m_171599_("Staff", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-1.0f, (float)9.0f, (float)9.0f, (float)1.5708f, (float)0.0f, (float)-1.5708f));
        PartDefinition handle = Staff.m_171599_("handle", CubeListBuilder.m_171558_().m_171514_(28, 41).m_171488_(0.0f, -14.0f, 0.0f, 1.0f, 22.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition group = Staff.m_171599_("group", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = group.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(46, 29).m_171488_(-3.0f, -3.0f, -0.5f, 8.0f, 8.0f, 1.0f, new CubeDeformation(0.01f)), PartPose.m_171423_((float)0.5f, (float)-20.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition bits = group.m_171599_("bits", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = bits.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(44, 38).m_171488_(1.0f, -3.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(44, 38).m_171488_(2.0f, -2.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(44, 38).m_171488_(-3.0f, 1.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(44, 38).m_171488_(-2.0f, 2.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(48, 38).m_171488_(-2.0f, 4.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(48, 38).m_171488_(4.0f, -2.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(44, 40).m_171488_(3.0f, -1.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(44, 38).m_171488_(3.0f, 0.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(48, 38).m_171488_(3.0f, 1.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(48, 38).m_171488_(1.0f, 1.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(44, 40).m_171488_(-1.0f, 3.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(44, 38).m_171488_(0.0f, 3.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(48, 38).m_171488_(1.0f, 3.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(48, 40).m_171488_(2.0f, 3.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(48, 38).m_171488_(2.0f, 2.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(28, 39).m_171488_(3.0f, 2.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(48, 38).m_171488_(3.0f, 3.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(28, 39).m_171488_(4.0f, 3.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(48, 40).m_171488_(3.0f, 4.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)-20.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition head2 = Staff.m_171599_("head2", CubeListBuilder.m_171558_().m_171514_(32, 38).m_171488_(-1.0f, -21.5f, -1.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (!entity.m_21224_()) {
            this.animateHeadLookTarget(netHeadYaw, headPitch);
        }
        Vec3 velocity = entity.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        if (this.f_102609_) {
            this.right_leg.f_104203_ = -1.4137167f;
            this.right_leg.f_104204_ = 0.31415927f;
            this.right_leg.f_104205_ = 0.07853982f;
            this.left_leg.f_104203_ = -1.4137167f;
            this.left_leg.f_104204_ = -0.31415927f;
            this.left_leg.f_104205_ = -0.07853982f;
        } else {
            this.m_233385_(((StormCaster)entity).walkAnimationState, StormCasterAnimations.WALK, ageInTicks, groundSpeed * 10.0f);
        }
        float f = 1.0f;
        if (entity.m_21256_() > 4) {
            f = (float)entity.m_20184_().m_82556_();
            f /= 0.2f;
            f = f * f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.cape.f_104203_ = MathHelper.modelDegrees(10.0f) + Mth.m_14154_((float)(Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.7f * limbSwingAmount / f));
        this.m_233381_(((StormCaster)entity).idleAnimationState, StormCasterAnimations.IDLE, ageInTicks);
        this.m_233381_(((StormCaster)entity).shockAnimationState, StormCasterAnimations.SHOCK, ageInTicks);
        this.m_233381_(((StormCaster)entity).cloudAnimationState, StormCasterAnimations.SUMMON_CLOUD, ageInTicks);
        this.m_233381_(((StormCaster)entity).dischargeAnimationState, StormCasterAnimations.DISCHARGE, ageInTicks);
    }

    private void animateHeadLookTarget(float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

