/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.client.render.animation.SquallGolemAnimations;
import com.Polarice3.Goety.common.entities.ally.SquallGolem;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class SquallGolemModel<T extends LivingEntity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart golem;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart pelvis;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightFan;
    private final ModelPart leftFan;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public SquallGolemModel(ModelPart root) {
        this.root = root;
        this.golem = root.m_171324_("golem");
        this.body = this.golem.m_171324_("body");
        this.pelvis = this.body.m_171324_("pelvis");
        this.head = this.body.m_171324_("head");
        this.rightArm = this.body.m_171324_("right_arm");
        this.leftArm = this.body.m_171324_("left_arm");
        this.rightFan = this.body.m_171324_("right_fan_base").m_171324_("right_fan");
        this.leftFan = this.body.m_171324_("left_fan_base").m_171324_("left_fan");
        this.rightLeg = this.golem.m_171324_("right_leg");
        this.leftLeg = this.golem.m_171324_("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition golem = partdefinition.m_171599_("golem", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = golem.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(1, 23).m_171488_(-15.0f, -11.0f, -7.0f, 30.0f, 22.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-30.0f, (float)0.0f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(89, 0).m_171488_(-6.5f, 0.5f, -4.0f, 7.0f, 35.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(89, 43).m_171488_(-6.5f, 31.5f, 4.0f, 7.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-15.5f, (float)-5.5f, (float)0.0f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(89, 53).m_171488_(-0.5f, 0.5f, -4.0f, 7.0f, 35.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(89, 96).m_171488_(-0.5f, 31.5f, 4.0f, 7.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)15.5f, (float)-5.5f, (float)0.0f));
        PartDefinition right_fan_base = body.m_171599_("right_fan_base", CubeListBuilder.m_171558_().m_171514_(42, 4).m_171488_(-2.0f, -1.0f, -2.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-12.0f, (float)-12.0f, (float)-4.0f));
        PartDefinition right_fan = right_fan_base.m_171599_("right_fan", CubeListBuilder.m_171558_().m_171514_(66, 11).m_171488_(-1.0f, -11.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_blades = right_fan.m_171599_("right_blades", CubeListBuilder.m_171558_().m_171514_(74, 0).m_171480_().m_171488_(-6.0f, -11.0f, 0.0f, 5.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(74, 9).m_171488_(1.0f, -11.0f, 0.0f, 5.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = right_blades.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(74, 9).m_171488_(1.0f, -11.0f, 0.0f, 5.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(74, 0).m_171480_().m_171488_(-6.0f, -11.0f, 0.0f, 5.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition left_fan_base = body.m_171599_("left_fan_base", CubeListBuilder.m_171558_().m_171514_(58, 4).m_171488_(-2.0f, -1.0f, -2.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)12.0f, (float)-12.0f, (float)-4.0f));
        PartDefinition left_fan = left_fan_base.m_171599_("left_fan", CubeListBuilder.m_171558_().m_171514_(66, 11).m_171488_(-1.0f, -11.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_blades = left_fan.m_171599_("left_blades", CubeListBuilder.m_171558_().m_171514_(74, 9).m_171480_().m_171488_(-6.0f, -11.0f, 0.0f, 5.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(74, 0).m_171488_(1.0f, -11.0f, 0.0f, 5.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition cube_r2 = left_blades.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(74, 9).m_171488_(1.0f, -11.0f, 0.0f, 5.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(74, 0).m_171480_().m_171488_(-6.0f, -11.0f, 0.0f, 5.0f, 9.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -6.0f, -10.0f, 16.0f, 13.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(75, 21).m_171488_(-1.0f, -6.0f, -12.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)-7.0f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(52, 13).m_171488_(-2.0f, 3.0f, -13.0f, 4.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition pelvis = body.m_171599_("pelvis", CubeListBuilder.m_171558_().m_171514_(0, 59).m_171488_(-7.0f, 0.0f, -5.0f, 14.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)11.0f, (float)0.0f));
        PartDefinition right_leg = golem.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 73).m_171488_(-4.0f, 0.0f, -4.0f, 8.0f, 15.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-7.0f, (float)-15.0f, (float)0.0f));
        PartDefinition left_leg = golem.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(32, 73).m_171488_(-4.0f, 0.0f, -4.0f, 8.0f, 15.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)7.0f, (float)-15.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (entity instanceof SquallGolem) {
            SquallGolem squallGolem = (SquallGolem)entity;
            if (squallGolem.isActivated() && !squallGolem.m_21224_()) {
                this.animateHeadLookTarget(netHeadYaw, headPitch);
            }
            Vec3 velocity = squallGolem.m_20184_();
            float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
            this.m_233381_(squallGolem.idleAnimationState, SquallGolemAnimations.IDLE, ageInTicks);
            this.m_233381_(squallGolem.alertAnimationState, SquallGolemAnimations.ALERT, ageInTicks);
            this.m_233385_(squallGolem.walkAnimationState, SquallGolemAnimations.WALK, ageInTicks, groundSpeed * 20.0f);
            this.m_233381_(squallGolem.attackAnimationState, SquallGolemAnimations.ATTACK, ageInTicks);
            this.m_233381_(squallGolem.activateAnimationState, SquallGolemAnimations.ACTIVATE, ageInTicks);
            this.m_233381_(squallGolem.deactivateAnimationState, SquallGolemAnimations.DEACTIVATE, ageInTicks);
            this.m_233381_(squallGolem.offAnimationState, SquallGolemAnimations.OFF, ageInTicks);
            float speed = ageInTicks / 2.0f;
            if (!squallGolem.isActivated() && !squallGolem.isStartingUp()) {
                speed = 0.0f;
            } else if (squallGolem.m_5912_()) {
                speed = ageInTicks;
            }
            this.rightFan.f_104204_ -= speed;
            this.leftFan.f_104204_ = speed;
        }
    }

    private void animateHeadLookTarget(float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

