/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.layer;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.utils.SEHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.model.data.ModelData;
import org.apache.commons.lang3.ArrayUtils;

public class MagicShieldLayer<T extends Player, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public static final ModelResourceLocation SHIELD = new ModelResourceLocation(Goety.location("magic_shield"), "inventory");
    private static final Direction[] DIRECTIONS = (Direction[])ArrayUtils.add((Object[])Direction.values(), null);

    public MagicShieldLayer(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    public void render(PoseStack stack, MultiBufferSource buffer, int light, T player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (SEHelper.getShields(player) > 0) {
            this.renderShields(stack, buffer, player, partialTicks);
        }
    }

    private void renderShields(PoseStack stack, MultiBufferSource buffer, T entity, float partialTicks) {
        float age = (float)((Player)entity).f_19797_ + partialTicks;
        float rotateAngleY = age / 10.0f;
        int count = SEHelper.getShields(entity);
        for (int c = 0; c < count; ++c) {
            stack.m_85836_();
            stack.m_85837_(-0.5, 1.0, -0.5);
            stack.m_85841_(1.0f, -1.0f, 1.0f);
            stack.m_85837_(0.5, 0.5, 0.5);
            stack.m_252781_(Axis.f_252436_.m_252977_(rotateAngleY * 57.295776f + (float)c * (360.0f / (float)count)));
            stack.m_252781_(Axis.f_252529_.m_252977_(15.0f));
            stack.m_85837_(-0.5, -0.5, -0.5);
            stack.m_85837_(0.0, 0.0, -1.0);
            BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(SHIELD);
            for (Direction dir : DIRECTIONS) {
                Minecraft.m_91087_().m_91291_().m_115162_(stack, buffer.m_6299_(Sheets.m_110792_()), model.getQuads(null, dir, entity.m_217043_(), ModelData.EMPTY, Sheets.m_110792_()), ItemStack.f_41583_, 0xF000F0, OverlayTexture.f_118083_);
            }
            stack.m_85849_();
        }
    }
}

