/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.block;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.blocks.entities.ModChestBlockEntity;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.ChestType;

public class ModChestRenderer<T extends ModChestBlockEntity>
extends ChestRenderer<T> {
    public static final Map<Block, EnumMap<ChestType, Material>> MATERIALS;

    public ModChestRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected Material getMaterial(T blockEntity, ChestType chestType) {
        EnumMap<ChestType, Material> b = MATERIALS.get(blockEntity.m_58900_().m_60734_());
        if (b == null) {
            return super.getMaterial(blockEntity, chestType);
        }
        Material material = b.get(chestType);
        return material != null ? material : super.getMaterial(blockEntity, chestType);
    }

    private static EnumMap<ChestType, Material> chestMaterial(String type) {
        EnumMap<ChestType, Material> map = new EnumMap<ChestType, Material>(ChestType.class);
        map.put(ChestType.SINGLE, new Material(Sheets.f_110740_, Goety.location("entity/chest/" + type + "/normal")));
        map.put(ChestType.LEFT, new Material(Sheets.f_110740_, Goety.location("entity/chest/" + type + "/normal_left")));
        map.put(ChestType.RIGHT, new Material(Sheets.f_110740_, Goety.location("entity/chest/" + type + "/normal_right")));
        return map;
    }

    private static EnumMap<ChestType, Material> trappedMaterial(String type) {
        EnumMap<ChestType, Material> map = new EnumMap<ChestType, Material>(ChestType.class);
        map.put(ChestType.SINGLE, new Material(Sheets.f_110740_, Goety.location("entity/chest/" + type + "/trapped")));
        map.put(ChestType.LEFT, new Material(Sheets.f_110740_, Goety.location("entity/chest/" + type + "/trapped_left")));
        map.put(ChestType.RIGHT, new Material(Sheets.f_110740_, Goety.location("entity/chest/" + type + "/trapped_right")));
        return map;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)((Block)ModBlocks.HAUNTED_CHEST.get()), ModChestRenderer.chestMaterial("haunted"));
        builder.put((Object)((Block)ModBlocks.TRAPPED_HAUNTED_CHEST.get()), ModChestRenderer.trappedMaterial("haunted"));
        builder.put((Object)((Block)ModBlocks.ROTTEN_CHEST.get()), ModChestRenderer.chestMaterial("rotten"));
        builder.put((Object)((Block)ModBlocks.TRAPPED_ROTTEN_CHEST.get()), ModChestRenderer.trappedMaterial("rotten"));
        builder.put((Object)((Block)ModBlocks.WINDSWEPT_CHEST.get()), ModChestRenderer.chestMaterial("windswept"));
        builder.put((Object)((Block)ModBlocks.TRAPPED_WINDSWEPT_CHEST.get()), ModChestRenderer.trappedMaterial("windswept"));
        MATERIALS = builder.build();
    }
}

