/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render;

import com.Polarice3.Goety.client.render.ModModelLayer;
import com.Polarice3.Goety.client.render.model.IceChunkModel;
import com.Polarice3.Goety.common.entities.projectiles.IceChunk;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class IceChunkRenderer
extends EntityRenderer<IceChunk> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("goety", "textures/entity/projectiles/ice_chunk.png");
    private static final ResourceLocation SPAWN = new ResourceLocation("goety", "textures/entity/projectiles/ice_chunk_spawn.png");
    private final IceChunkModel<IceChunk> model;

    public IceChunkRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
        this.model = new IceChunkModel(renderManagerIn.m_174023_(ModModelLayer.ICE_CHUNK));
    }

    public void render(IceChunk pEntity, float entityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource bufferIn, int packedLightIn) {
        float f;
        pMatrixStack.m_85836_();
        pMatrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f - pEntity.m_146908_()));
        VertexConsumer ivertexbuilder = bufferIn.m_6299_(this.model.m_103119_(this.getTextureLocation(pEntity)));
        if (pEntity.isStarting()) {
            f = (float)pEntity.hovering / 10.0f;
            ivertexbuilder = bufferIn.m_6299_(RenderType.m_110488_((ResourceLocation)this.getTextureLocation(pEntity)));
            packedLightIn = 0xF00000;
        } else {
            f = 2.0f;
        }
        pMatrixStack.m_85841_(-f, -f, f);
        pMatrixStack.m_85837_(0.0, -1.45, 0.0);
        this.model.setupAnim(pEntity, 0.0f, 0.0f, pPartialTicks, 0.0f, 0.0f);
        this.model.m_7695_(pMatrixStack, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.15f);
        pMatrixStack.m_85849_();
        super.m_7392_((Entity)pEntity, entityYaw, pPartialTicks, pMatrixStack, bufferIn, packedLightIn);
    }

    protected int getBlockLightLevel(IceChunk iceChunk, BlockPos blockPos) {
        if (iceChunk.isStarting()) {
            return 15;
        }
        return super.m_6086_((Entity)iceChunk, blockPos);
    }

    public ResourceLocation getTextureLocation(IceChunk pEntity) {
        if (pEntity.isStarting()) {
            return SPAWN;
        }
        return TEXTURE;
    }
}

