/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.MobsConfig;
import com.Polarice3.Goety.client.render.CultistRenderer;
import com.Polarice3.Goety.client.render.ModModelLayer;
import com.Polarice3.Goety.client.render.model.ApostleModel;
import com.Polarice3.Goety.client.render.model.CultistModel;
import com.Polarice3.Goety.client.render.model.VillagerArmorModel;
import com.Polarice3.Goety.common.entities.boss.Apostle;
import com.Polarice3.Goety.common.entities.hostile.cultists.Cultist;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;

public class ApostleRenderer
extends CultistRenderer<Apostle> {
    protected static final ResourceLocation TEXTURE = Goety.location("textures/entity/cultist/apostle.png");
    protected static final ResourceLocation TEXTURE_2 = Goety.location("textures/entity/cultist/apostle_second.png");
    protected static final ResourceLocation EXPLODE = Goety.location("textures/entity/cultist/apostle_explode.png");
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);

    public ApostleRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, new ApostleModel(renderManagerIn.m_174023_(ModModelLayer.APOSTLE)), 0.5f);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new VillagerArmorModel(renderManagerIn.m_174023_(ModModelLayer.VILLAGER_ARMOR_INNER)), new VillagerArmorModel(renderManagerIn.m_174023_(ModModelLayer.VILLAGER_ARMOR_OUTER)), renderManagerIn.m_266367_()));
        this.m_115326_((RenderLayer)new ItemInHandLayer<Apostle, CultistModel<Apostle>>((RenderLayerParent)this, renderManagerIn.m_234598_()){

            public void render(PoseStack p_116352_, MultiBufferSource p_116353_, int p_116354_, Apostle p_116355_, float p_116356_, float p_116357_, float p_116358_, float p_116359_, float p_116360_, float p_116361_) {
                if (p_116355_.getArmPose() != Cultist.CultistArmPose.CROSSED) {
                    super.m_6494_(p_116352_, p_116353_, p_116354_, (LivingEntity)p_116355_, p_116356_, p_116357_, p_116358_, p_116359_, p_116360_, p_116361_);
                }
            }
        });
    }

    public void render(Apostle pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        super.m_7392_((Mob)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        if (pEntity.deathTime > 0) {
            pMatrixStack.m_85836_();
            boolean flag = pEntity.f_20916_ > 0;
            float f = Mth.m_14189_((float)pPartialTicks, (float)pEntity.f_20884_, (float)pEntity.f_20883_);
            float f1 = Mth.m_14189_((float)pPartialTicks, (float)pEntity.f_20886_, (float)pEntity.f_20885_);
            float f2 = f1 - f;
            float f6 = Mth.m_14179_((float)pPartialTicks, (float)pEntity.f_19860_, (float)pEntity.m_146909_());
            float f71 = this.m_6930_((LivingEntity)pEntity, pPartialTicks);
            this.setupRotations(pEntity, pMatrixStack, f71, f, pPartialTicks);
            pMatrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
            this.scale(pEntity, pMatrixStack, pPartialTicks);
            pMatrixStack.m_85837_(0.0, (double)-1.501f, 0.0);
            ((CultistModel)this.f_115290_).prepareMobModel(pEntity, 0.0f, 0.0f, pPartialTicks);
            ((CultistModel)this.f_115290_).setupAnim(pEntity, 0.0f, 0.0f, f71, f2, f6);
            float f8 = (Boolean)MobsConfig.FancierApostleDeath.get() != false || pEntity.f_19853_.m_46472_() == Level.f_46429_ ? 300.0f : 30.0f;
            float f9 = (float)pEntity.deathTime / f8;
            VertexConsumer vertexconsumer = pBuffer.m_6299_(RenderType.m_173235_((ResourceLocation)EXPLODE));
            ((CultistModel)this.f_115290_).m_7695_(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, f9);
            VertexConsumer ivertexbuilder1 = pBuffer.m_6299_(RenderType.m_110479_((ResourceLocation)this.getTextureLocation(pEntity)));
            ((CultistModel)this.f_115290_).m_7695_(pMatrixStack, ivertexbuilder1, pPackedLight, OverlayTexture.m_118090_((float)0.0f, (boolean)flag), 1.0f, 1.0f, 1.0f, 1.0f);
            pMatrixStack.m_85849_();
            if ((((Boolean)MobsConfig.FancierApostleDeath.get()).booleanValue() || pEntity.f_19853_.m_46472_() == Level.f_46429_) && pEntity.deathTime > 20) {
                float f5 = ((float)pEntity.deathTime + pPartialTicks) / 200.0f;
                float f7 = Math.min(f5 > 0.8f ? (f5 - 0.8f) / 0.2f : 0.0f, 1.0f);
                Random random = new Random(432L);
                VertexConsumer ivertexbuilder2 = pBuffer.m_6299_(RenderType.m_110502_());
                pMatrixStack.m_85836_();
                pMatrixStack.m_85837_(0.0, 1.0, 0.0);
                int i = 0;
                while ((float)i < (f5 + f5 * f5) / 2.0f * 10.0f) {
                    pMatrixStack.m_252781_(Axis.f_252529_.m_252977_(random.nextFloat() * 360.0f));
                    pMatrixStack.m_252781_(Axis.f_252436_.m_252977_(random.nextFloat() * 360.0f));
                    pMatrixStack.m_252781_(Axis.f_252403_.m_252977_(random.nextFloat() * 360.0f));
                    pMatrixStack.m_252781_(Axis.f_252529_.m_252977_(random.nextFloat() * 360.0f));
                    pMatrixStack.m_252781_(Axis.f_252436_.m_252977_(random.nextFloat() * 360.0f));
                    pMatrixStack.m_252781_(Axis.f_252403_.m_252977_(random.nextFloat() * 360.0f + f5 * 90.0f));
                    float f3 = random.nextFloat() * 2.0f + 5.0f + f7 * 10.0f;
                    float f4 = random.nextFloat() + 1.0f + f7;
                    Matrix4f matrix4f = pMatrixStack.m_85850_().m_252922_();
                    int j = (int)(255.0f * (1.0f - f7));
                    ApostleRenderer.vertex01(ivertexbuilder2, matrix4f, j);
                    ApostleRenderer.vertex2(ivertexbuilder2, matrix4f, f3, f4);
                    ApostleRenderer.vertex3(ivertexbuilder2, matrix4f, f3, f4);
                    ApostleRenderer.vertex01(ivertexbuilder2, matrix4f, j);
                    ApostleRenderer.vertex3(ivertexbuilder2, matrix4f, f3, f4);
                    ApostleRenderer.vertex4(ivertexbuilder2, matrix4f, f3, f4);
                    ApostleRenderer.vertex01(ivertexbuilder2, matrix4f, j);
                    ApostleRenderer.vertex4(ivertexbuilder2, matrix4f, f3, f4);
                    ApostleRenderer.vertex2(ivertexbuilder2, matrix4f, f3, f4);
                    ++i;
                }
                pMatrixStack.m_85849_();
            }
        }
    }

    private static void vertex01(VertexConsumer p_229061_0_, Matrix4f p_229061_1_, int p_229061_2_) {
        p_229061_0_.m_252986_(p_229061_1_, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, p_229061_2_).m_5752_();
        p_229061_0_.m_252986_(p_229061_1_, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, p_229061_2_).m_5752_();
    }

    private static void vertex2(VertexConsumer p_229060_0_, Matrix4f p_229060_1_, float pY, float p_229060_3_) {
        p_229060_0_.m_252986_(p_229060_1_, -HALF_SQRT_3 * p_229060_3_, pY, -0.5f * p_229060_3_).m_6122_(255, 0, 0, 0).m_5752_();
    }

    private static void vertex3(VertexConsumer p_229062_0_, Matrix4f p_229062_1_, float pY, float p_229062_3_) {
        p_229062_0_.m_252986_(p_229062_1_, HALF_SQRT_3 * p_229062_3_, pY, -0.5f * p_229062_3_).m_6122_(255, 0, 0, 0).m_5752_();
    }

    private static void vertex4(VertexConsumer p_229063_0_, Matrix4f p_229063_1_, float pY, float p_229063_3_) {
        p_229063_0_.m_252986_(p_229063_1_, 0.0f, pY, 1.0f * p_229063_3_).m_6122_(255, 0, 0, 0).m_5752_();
    }

    @Nullable
    protected RenderType getRenderType(Apostle p_230496_1_, boolean p_230496_2_, boolean p_230496_3_, boolean p_230496_4_) {
        if (p_230496_1_.deathTime > 0) {
            return RenderType.m_173235_((ResourceLocation)EXPLODE);
        }
        return super.m_7225_((LivingEntity)p_230496_1_, p_230496_2_, p_230496_3_, p_230496_4_);
    }

    protected boolean isShaking(Apostle p_230495_1_) {
        return p_230495_1_.m_21224_() && p_230495_1_.deathTime < 180;
    }

    public ResourceLocation getTextureLocation(Apostle entity) {
        return entity.isSecondPhase() ? TEXTURE_2 : TEXTURE;
    }
}

