/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.particles;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.utils.ColorUtil;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;

public class FoggyCloudParticleOption
implements ParticleOptions {
    public static final Codec<FoggyCloudParticleOption> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("red").forGetter(d -> Float.valueOf(d.red)), (App)Codec.FLOAT.fieldOf("green").forGetter(d -> Float.valueOf(d.green)), (App)Codec.FLOAT.fieldOf("blue").forGetter(d -> Float.valueOf(d.blue)), (App)Codec.FLOAT.fieldOf("size").forGetter(d -> Float.valueOf(d.size)), (App)Codec.INT.fieldOf("speed").forGetter(d -> d.speed), (App)Codec.BOOL.fieldOf("gravity").forGetter(d -> d.gravity)).apply((Applicative)instance, FoggyCloudParticleOption::new));
    public static final ParticleOptions.Deserializer<FoggyCloudParticleOption> DESERIALIZER = new ParticleOptions.Deserializer<FoggyCloudParticleOption>(){

        public FoggyCloudParticleOption fromCommand(ParticleType<FoggyCloudParticleOption> p_235961_, StringReader p_235962_) throws CommandSyntaxException {
            p_235962_.expect(' ');
            float r = p_235962_.readFloat();
            p_235962_.expect(' ');
            float g = p_235962_.readFloat();
            p_235962_.expect(' ');
            float b = p_235962_.readFloat();
            p_235962_.expect(' ');
            float s = p_235962_.readFloat();
            p_235962_.expect(' ');
            int s2 = p_235962_.readInt();
            p_235962_.expect(' ');
            boolean g2 = p_235962_.readBoolean();
            return new FoggyCloudParticleOption(r, g, b, s, s2, g2);
        }

        public FoggyCloudParticleOption fromNetwork(ParticleType<FoggyCloudParticleOption> p_235964_, FriendlyByteBuf p_235965_) {
            return new FoggyCloudParticleOption(p_235965_.readFloat(), p_235965_.readFloat(), p_235965_.readFloat(), p_235965_.readFloat(), p_235965_.readInt(), p_235965_.readBoolean());
        }
    };
    private final float red;
    private final float green;
    private final float blue;
    private final float size;
    private final int speed;
    private final boolean gravity;

    public FoggyCloudParticleOption(ColorUtil colorUtil, float size, int speed) {
        this(colorUtil, size, speed, true);
    }

    public FoggyCloudParticleOption(ColorUtil colorUtil, float size, int speed, boolean gravity) {
        this.red = colorUtil.red;
        this.green = colorUtil.green;
        this.blue = colorUtil.blue;
        this.size = size;
        this.speed = speed;
        this.gravity = gravity;
    }

    public FoggyCloudParticleOption(float r, float g, float b, float size, int speed) {
        this(r, g, b, size, speed, true);
    }

    public FoggyCloudParticleOption(float r, float g, float b, float size, int speed, boolean gravity) {
        this.red = r;
        this.green = g;
        this.blue = b;
        this.size = size;
        this.speed = speed;
        this.gravity = gravity;
    }

    public void m_7711_(FriendlyByteBuf p_235956_) {
        p_235956_.writeFloat(this.red);
        p_235956_.writeFloat(this.green);
        p_235956_.writeFloat(this.blue);
        p_235956_.writeFloat(this.size);
        p_235956_.writeInt(this.speed);
        p_235956_.writeBoolean(this.gravity);
    }

    public ParticleType<FoggyCloudParticleOption> m_6012_() {
        return (ParticleType)ModParticleTypes.FOG_CLOUD.get();
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %.2f %.2f %s %s %s %s %s %s", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.size), this.speed, this.gravity);
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public float getSize() {
        return this.size;
    }

    public int getSpeed() {
        return this.speed;
    }

    public boolean hasGravity() {
        return this.gravity;
    }
}

