/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.api.magic;

import com.Polarice3.Goety.SpellConfig;
import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.items.curios.FrostRobeItem;
import com.Polarice3.Goety.common.items.curios.MagicHatItem;
import com.Polarice3.Goety.common.items.curios.MagicRobeItem;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.CuriosFinder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;

public interface ISpell {
    public int defaultSoulCost();

    default public int soulCost(LivingEntity entityLiving) {
        return this.SoulCalculation(entityLiving);
    }

    default public int SoulCalculation(LivingEntity entityLiving) {
        int cost = this.defaultSoulCost() * this.SoulCostUp(entityLiving);
        BlockPos blockPos = entityLiving.m_20183_();
        Level level = entityLiving.f_19853_;
        Holder biomeHolder = level.m_204166_(blockPos);
        boolean enable = (Boolean)SpellConfig.EnvironmentalCost.get();
        if (this.SoulDiscount(entityLiving)) {
            cost = (int)((float)cost / 1.05f);
        }
        if (this.getSpellType() == SpellType.FROST) {
            if (this.FrostSoulDiscount(entityLiving)) {
                cost /= 2;
            }
            if (enable) {
                if (((Biome)biomeHolder.get()).m_198904_(blockPos) || biomeHolder.m_203656_(Tags.Biomes.IS_COLD) || level.m_46758_(blockPos) && ((Biome)biomeHolder.get()).m_47519_((LevelReader)level, blockPos)) {
                    cost = (int)((float)cost / 1.5f);
                } else if (biomeHolder.m_203656_(BiomeTags.f_263828_)) {
                    cost = (int)((float)cost * 1.5f);
                }
            }
        }
        if (this.getSpellType() == SpellType.WIND) {
            if (this.WindSoulDiscount(entityLiving)) {
                cost /= 2;
            }
            if (enable) {
                if ((blockPos.m_123342_() >= 128 || biomeHolder.m_203656_(Tags.Biomes.IS_MOUNTAIN)) && level.m_45527_(blockPos)) {
                    cost = (int)((float)cost / 1.5f);
                } else if (blockPos.m_123342_() <= 32 && !level.m_45527_(blockPos)) {
                    cost = (int)((float)cost * 1.5f);
                }
            }
        }
        if (this.getSpellType() == SpellType.STORM) {
            if (this.StormSoulDiscount(entityLiving)) {
                cost /= 2;
            }
            if (enable && level.m_45527_(blockPos) && level.m_46470_()) {
                cost = (int)((float)cost / 1.5f);
            }
        }
        if (this.getSpellType() == SpellType.GEOMANCY) {
            if (this.GeoSoulDiscount(entityLiving)) {
                cost /= 2;
            }
            if (enable) {
                if ((blockPos.m_123342_() <= 32 || biomeHolder.m_203656_(Tags.Biomes.IS_UNDERGROUND)) && !level.m_45527_(blockPos)) {
                    cost = (int)((float)cost / 1.5f);
                } else if (blockPos.m_123342_() >= 128) {
                    cost = (int)((float)cost * 1.5f);
                }
            }
        }
        if (this.getSpellType() == SpellType.NETHER && enable && (level.m_46472_() == Level.f_46429_ || biomeHolder.m_203656_(BiomeTags.f_207612_))) {
            cost = (int)((float)cost / 1.5f);
        }
        if (this.getSpellType() == SpellType.NECROMANCY && enable && (level.m_46940_() > 0.9f || biomeHolder.m_203565_(Biomes.f_48199_) || biomeHolder.m_203565_(Biomes.f_220594_))) {
            cost = (int)((float)cost / 1.5f);
        }
        if (this.getSpellType() == SpellType.WILD) {
            if (this.WildSoulDiscount(entityLiving)) {
                cost /= 2;
            }
            if (enable) {
                if (biomeHolder.m_203656_(BiomeTags.f_207610_) || biomeHolder.m_203656_(Tags.Biomes.IS_SWAMP)) {
                    cost = (int)((float)cost / 1.5f);
                } else if (biomeHolder.m_203656_(Tags.Biomes.IS_DESERT) || biomeHolder.m_203656_(Tags.Biomes.IS_DEAD) || biomeHolder.m_203656_(Tags.Biomes.IS_WASTELAND)) {
                    cost = (int)((float)cost * 1.5f);
                }
            }
        }
        if (this.getSpellType() == SpellType.ABYSS && enable && biomeHolder.m_203656_(BiomeTags.f_207603_)) {
            cost = (int)((float)cost / 1.5f);
        }
        if (this.getSpellType() == SpellType.VOID && enable && (biomeHolder.containsTag(Tags.Biomes.IS_VOID) || level.m_46472_() == Level.f_46430_ || biomeHolder.m_203656_(BiomeTags.f_215818_))) {
            cost = (int)((float)cost / 1.5f);
        }
        return cost;
    }

    public int defaultCastDuration();

    default public int castDuration(LivingEntity entityLiving) {
        if (this.ReduceCastTime(entityLiving)) {
            return this.defaultCastDuration() / 2;
        }
        return this.defaultCastDuration();
    }

    @Nullable
    public SoundEvent CastingSound();

    public int defaultSpellCooldown();

    default public int spellCooldown() {
        return this.defaultSpellCooldown();
    }

    public void SpellResult(ServerLevel var1, LivingEntity var2, ItemStack var3);

    public SpellType getSpellType();

    public boolean conditionsMet(ServerLevel var1, LivingEntity var2);

    public List<Enchantment> acceptedEnchantments();

    default public SoundEvent loopSound(LivingEntity entityLiving) {
        return null;
    }

    default public ColorUtil particleColors(LivingEntity entityLiving) {
        return new ColorUtil(0.2f, 0.2f, 0.2f);
    }

    default public HitResult rayTrace(Level worldIn, LivingEntity livingEntity, int range, double radius) {
        if (this.entityResult(worldIn, livingEntity, range, radius) == null) {
            return this.blockResult(worldIn, livingEntity, range);
        }
        return this.entityResult(worldIn, livingEntity, range, radius);
    }

    default public BlockHitResult blockResult(Level worldIn, LivingEntity livingEntity, double range) {
        float f = livingEntity.m_146909_();
        float f1 = livingEntity.m_146908_();
        Vec3 vector3d = livingEntity.m_20299_(1.0f);
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        Vec3 vector3d1 = vector3d.m_82520_((double)f6 * range, (double)f5 * range, (double)f7 * range);
        return worldIn.m_45547_(new ClipContext(vector3d, vector3d1, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)livingEntity));
    }

    default public EntityHitResult entityResult(Level worldIn, LivingEntity livingEntity, int range, double radius) {
        Vec3 srcVec = livingEntity.m_20299_(1.0f);
        Vec3 lookVec = livingEntity.m_20252_(1.0f);
        Vec3 destVec = srcVec.m_82520_(lookVec.f_82479_ * (double)range, lookVec.f_82480_ * (double)range, lookVec.f_82481_ * (double)range);
        AABB axisalignedbb = livingEntity.m_20191_().m_82369_(lookVec.m_82490_((double)range)).m_82377_(radius, radius, radius);
        return ProjectileUtil.m_37304_((Level)worldIn, (Entity)livingEntity, (Vec3)srcVec, (Vec3)destVec, (AABB)axisalignedbb, entity -> entity instanceof LivingEntity && !entity.m_5833_() && entity.m_6087_());
    }

    default public boolean ReduceCastTime(LivingEntity entityLiving) {
        if (this.getSpellType() == SpellType.NECROMANCY) {
            return CuriosFinder.hasCurio(entityLiving, (Item)ModItems.NECRO_CROWN.get()) || CuriosFinder.hasCurio(entityLiving, itemStack -> itemStack.m_41720_() instanceof MagicHatItem);
        }
        return CuriosFinder.hasCurio(entityLiving, itemStack -> itemStack.m_41720_() instanceof MagicHatItem);
    }

    @Nullable
    default public MobEffectInstance summonDownEffect(LivingEntity livingEntity) {
        return livingEntity.m_21124_((MobEffect)GoetyEffects.SUMMON_DOWN.get());
    }

    default public int SoulCostUp(LivingEntity entityLiving) {
        MobEffectInstance mobEffectInstance = this.summonDownEffect(entityLiving);
        if (mobEffectInstance != null) {
            return mobEffectInstance.m_19564_() + 2;
        }
        return 1;
    }

    default public boolean SoulDiscount(LivingEntity entityLiving) {
        return CuriosFinder.hasCurio(entityLiving, itemStack -> itemStack.m_41720_() instanceof MagicRobeItem);
    }

    default public boolean FrostSoulDiscount(LivingEntity entityLiving) {
        return CuriosFinder.hasCurio(entityLiving, itemStack -> itemStack.m_41720_() instanceof FrostRobeItem);
    }

    default public boolean WindSoulDiscount(LivingEntity entityLiving) {
        return CuriosFinder.hasCurio(entityLiving, (Item)ModItems.WIND_ROBE.get());
    }

    default public boolean GeoSoulDiscount(LivingEntity entityLiving) {
        return CuriosFinder.hasCurio(entityLiving, (Item)ModItems.AMETHYST_NECKLACE.get());
    }

    default public boolean StormSoulDiscount(LivingEntity entityLiving) {
        return CuriosFinder.hasCurio(entityLiving, (Item)ModItems.STORM_ROBE.get());
    }

    default public boolean WildSoulDiscount(LivingEntity entityLiving) {
        return CuriosFinder.hasWildRobe(entityLiving);
    }
}

