/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.api.magic;

import com.Polarice3.Goety.api.magic.IMold;
import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.magic.construct.GraveGolemMold;
import com.Polarice3.Goety.common.magic.construct.LeapleafMold;
import com.Polarice3.Goety.common.magic.construct.RedstoneGolemMold;
import com.Polarice3.Goety.common.magic.construct.SquallGolemMold;
import com.Polarice3.Goety.common.magic.construct.WhispererMold;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IExtensibleEnum;

public enum GolemType implements IExtensibleEnum
{
    NONE(null, null),
    WHISPERER(() -> ((Block)Blocks.f_152544_).m_49966_(), new WhispererMold()),
    LEAPLEAF(() -> ((Block)((Block)ModBlocks.OVERGROWN_ROOTS.get())).m_49966_(), new LeapleafMold()),
    SQUALL_GOLEM(() -> ((Block)((Block)ModBlocks.JADE_BLOCK.get())).m_49966_(), new SquallGolemMold()),
    REDSTONE_GOLEM(() -> ((Block)Blocks.f_50330_).m_49966_(), new RedstoneGolemMold()),
    GRAVE_GOLEM(() -> ((Block)((Block)ModBlocks.SKULL_PILE.get())).m_49966_(), new GraveGolemMold());

    private final Supplier<BlockState> blockState;
    private final IMold mold;

    private GolemType(Supplier<BlockState> blockState, IMold mold) {
        this.blockState = blockState;
        this.mold = mold;
    }

    public static GolemType create(String name, Supplier<BlockState> blockState, IMold mold) {
        throw new IllegalStateException("Enum not extended");
    }

    public BlockState getBlockState() {
        return this.blockState.get();
    }

    public IMold getMold() {
        return this.mold;
    }

    public static Map<BlockState, IMold> getGolemList() {
        HashMap list = Maps.newHashMap();
        for (GolemType golemType : GolemType.values()) {
            if (golemType.blockState == null) continue;
            list.put(golemType.getBlockState(), golemType.getMold());
        }
        return list;
    }
}

