/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.math;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class ChunkDimPos
implements Comparable<ChunkDimPos> {
    private final ResourceKey<Level> dimension;
    private final ChunkPos chunkPos;
    private int hash;

    public ChunkDimPos(ResourceKey<Level> dim, int x, int z) {
        this.dimension = dim;
        this.chunkPos = new ChunkPos(x, z);
        int h = Objects.hash(this.dimension.m_135782_(), this.chunkPos);
        this.hash = h == 0 ? 1 : h;
    }

    public ChunkDimPos(ResourceKey<Level> dim, ChunkPos pos) {
        this(dim, pos.f_45578_, pos.f_45579_);
    }

    public ChunkDimPos(Level world, BlockPos pos) {
        this((ResourceKey<Level>)world.m_46472_(), pos.m_123341_() >> 4, pos.m_123343_() >> 4);
    }

    public ChunkDimPos(Entity entity) {
        this(entity.m_9236_(), entity.m_20183_());
    }

    public ChunkPos getChunkPos() {
        return this.chunkPos;
    }

    public int x() {
        return this.chunkPos.f_45578_;
    }

    public int z() {
        return this.chunkPos.f_45579_;
    }

    public ResourceKey<Level> dimension() {
        return this.dimension;
    }

    public String toString() {
        return "[" + this.dimension.m_135782_() + ":" + this.x() + ":" + this.z() + "]";
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ChunkDimPos) {
            ChunkDimPos p = (ChunkDimPos)obj;
            return this.dimension == p.dimension && this.chunkPos.equals((Object)p.chunkPos);
        }
        return false;
    }

    @Override
    public int compareTo(ChunkDimPos o) {
        int i = this.dimension.m_135782_().compareTo(o.dimension.m_135782_());
        return i == 0 ? Long.compare(this.getChunkPos().m_45588_(), o.getChunkPos().m_45588_()) : i;
    }

    public ChunkDimPos offset(int ox, int oz) {
        return new ChunkDimPos(this.dimension, this.x() + ox, this.z() + oz);
    }
}

