/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public interface ItemSearchMode {
    public static final ItemSearchMode ALL_ITEMS = new ItemSearchMode(){
        private List<ItemStack> allItemsCache = null;

        @Override
        public Icon getIcon() {
            return ItemIcon.getItemIcon(Items.f_42522_);
        }

        @Override
        public MutableComponent getDisplayName() {
            return Component.m_237115_((String)"ftblibrary.select_item.list_mode.all");
        }

        @Override
        public Collection<ItemStack> getAllItems() {
            CreativeModeTabs.m_269226_((FeatureFlagSet)FeatureFlags.f_244332_, (boolean)false, (HolderLookup.Provider)ClientUtils.registryAccess());
            if (this.allItemsCache == null) {
                this.allItemsCache = CreativeModeTabs.m_257478_().stream().flatMap(tab -> tab.m_260957_().stream()).toList();
            }
            return this.allItemsCache;
        }
    };
    public static final ItemSearchMode INVENTORY = new ItemSearchMode(){

        @Override
        public Icon getIcon() {
            return ItemIcon.getItemIcon(Items.f_42009_);
        }

        @Override
        public MutableComponent getDisplayName() {
            return Component.m_237115_((String)"ftblibrary.select_item.list_mode.inv");
        }

        @Override
        public Collection<ItemStack> getAllItems() {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return Collections.emptySet();
            }
            int invSize = player.m_150109_().m_6643_();
            ArrayList<ItemStack> items = new ArrayList<ItemStack>(invSize);
            for (int i = 0; i < invSize; ++i) {
                ItemStack stack = player.m_150109_().m_8020_(i);
                if (stack.m_41619_()) continue;
                items.add(stack);
            }
            return items;
        }
    };

    public Icon getIcon();

    public MutableComponent getDisplayName();

    public Collection<ItemStack> getAllItems();
}

