/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config;

import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigListScreen;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ListConfig<E, CV extends ConfigValue<E>>
extends ConfigValue<List<E>> {
    public static final Component EMPTY_LIST = Component.m_237113_((String)"[]");
    public static final Component NON_EMPTY_LIST = Component.m_237113_((String)"[...]");
    public static final Color4I COLOR = Color4I.rgb(16755273);
    private final CV type;

    public ListConfig(CV t) {
        this.type = t;
    }

    public CV getType() {
        return this.type;
    }

    @Override
    public List<E> copy(List<E> v) {
        ArrayList<E> list = new ArrayList<E>(v.size());
        for (E value : v) {
            list.add(((ConfigValue)this.type).copy(value));
        }
        return list;
    }

    @Override
    public Color4I getColor(List<E> v) {
        return COLOR;
    }

    @Override
    public void addInfo(TooltipList l) {
        if (!((List)this.getValue()).isEmpty()) {
            l.add(ListConfig.info("List"));
            for (Object value : (List)this.getValue()) {
                l.add(((ConfigValue)this.type).getStringForGUI(value));
            }
            if (!((List)this.getDefaultValue()).isEmpty()) {
                l.blankLine();
            }
        }
        if (!((List)this.getDefaultValue()).isEmpty()) {
            l.add(ListConfig.info("Default"));
            for (Object value : (List)this.getDefaultValue()) {
                l.add(((ConfigValue)this.type).getStringForGUI(value));
            }
        }
    }

    @Override
    public void onClicked(MouseButton button, ConfigCallback callback) {
        new EditConfigListScreen(this, callback).openGui();
    }

    @Override
    public Component getStringForGUI(List<E> v) {
        return v == null ? NULL_TEXT : (v.isEmpty() ? EMPTY_LIST : this.formatListSize(v));
    }

    private Component formatListSize(List<E> v) {
        MutableComponent main = v.size() == 1 ? Component.m_237115_((String)"ftblibrary.gui.listSize1") : Component.m_237110_((String)"ftblibrary.gui.listSize", (Object[])new Object[]{v.size()});
        return Component.m_237113_((String)"[ ").m_7220_((Component)main.m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY})).m_130946_(" ]");
    }
}

