/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary;

import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.client.screen.ScreenAccess;
import dev.architectury.platform.Platform;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.ftb.mods.ftblibrary.FTBLibraryCommon;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.FluidConfig;
import dev.ftb.mods.ftblibrary.config.ImageConfig;
import dev.ftb.mods.ftblibrary.config.IntConfig;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButtonManager;
import dev.ftb.mods.ftblibrary.sidebar.SidebarGroupGuiButton;
import dev.ftb.mods.ftblibrary.ui.CursorType;
import dev.ftb.mods.ftblibrary.ui.IScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.misc.SelectImageScreen;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.rei.api.client.config.ConfigObject;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.core.Direction;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class FTBLibraryClient
extends FTBLibraryCommon {
    public static int showButtons = 1;
    public CursorType lastCursorType = null;

    @Override
    public void init() {
        if (Platform.isModLoaded((String)"roughlyenoughitems")) {
            showButtons = 3;
        }
        if (Minecraft.m_91087_() == null) {
            return;
        }
        ClientGuiEvent.INIT_POST.register(this::guiInit);
        ClientTickEvent.CLIENT_POST.register(this::clientTick);
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)SidebarButtonManager.INSTANCE);
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)SelectImageScreen.ResourceListener.INSTANCE);
    }

    private void guiInit(Screen screen, ScreenAccess access) {
        if (FTBLibraryClient.areButtonsVisible(screen)) {
            access.addRenderableWidget((AbstractWidget)new SidebarGroupGuiButton());
        }
    }

    private void clientTick(Minecraft client) {
        CursorType t;
        CursorType cursorType = t = client.f_91080_ instanceof IScreenWrapper ? ((IScreenWrapper)client.f_91080_).getGui().getCursor() : null;
        if (this.lastCursorType != t) {
            this.lastCursorType = t;
            CursorType.set(t);
        }
        if (!ClientUtils.RUN_LATER.isEmpty()) {
            for (Runnable runnable : new ArrayList<Runnable>(ClientUtils.RUN_LATER)) {
                runnable.run();
            }
            ClientUtils.RUN_LATER.clear();
        }
    }

    public static boolean areButtonsVisible(@Nullable Screen gui) {
        if (Minecraft.m_91087_().f_91073_ == null || Minecraft.m_91087_().f_91074_ == null) {
            return false;
        }
        if (showButtons == 0 || showButtons == 2 && !(gui instanceof EffectRenderingInventoryScreen)) {
            return false;
        }
        if (showButtons == 3 && Platform.isModLoaded((String)"roughlyenoughitems") && ConfigObject.getInstance().isFavoritesEnabled()) {
            return false;
        }
        return gui instanceof AbstractContainerScreen && !SidebarButtonManager.INSTANCE.getGroups().isEmpty();
    }

    @Override
    public void testScreen() {
        ConfigGroup group = new ConfigGroup("test");
        group.add("image", new ImageConfig(), "", v -> {}, "");
        group.addItemStack("item", ItemStack.f_41583_, v -> {}, ItemStack.f_41583_, false, true);
        group.add("fluid", new FluidConfig(true), FluidStack.empty(), v -> {}, FluidStack.empty());
        ConfigGroup grp1 = group.getOrCreateSubgroup("group1");
        grp1.addInt("integer", 1, v -> {}, 0, 0, 10);
        grp1.addBool("bool", true, v -> {}, false);
        ConfigGroup grp2 = grp1.getOrCreateSubgroup("subgroup1");
        grp2.addEnum("enum", Direction.UP, v -> {}, NameMap.of(Direction.UP, Direction.values()).create());
        ArrayList<Integer> integers = new ArrayList<Integer>(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)));
        grp2.addList("list", integers, new IntConfig(0, 10), 1);
        new EditConfigScreen(group).openGuiLater();
    }
}

