/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalenchants.handler;

import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import fuzs.universalenchants.capability.ArrowLootingCapability;
import fuzs.universalenchants.init.ModRegistry;
import fuzs.universalenchants.mixin.accessor.AbstractArrowAccessor;
import java.util.Optional;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemCompatHandler {
    public static EventResult onArrowLoose(Player player, ItemStack stack, Level level, MutableInt charge, boolean hasAmmo) {
        if (hasAmmo && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)stack) > 0) {
            float velocity = BowItem.m_40661_((int)charge.getAsInt());
            if (!level.f_46443_ && velocity >= 0.1f) {
                ItemStack itemstack = player.m_6298_(stack);
                ArrowItem arrowitem = (ArrowItem)(itemstack.m_41720_() instanceof ArrowItem ? itemstack.m_41720_() : Items.f_42412_);
                float[] shotPitches = ItemCompatHandler.getShotPitches(level.f_46441_, velocity);
                for (int i = 0; i < 2; ++i) {
                    AbstractArrow abstractarrow = arrowitem.m_6394_(level, itemstack, (LivingEntity)player);
                    abstractarrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, velocity * 3.0f, 1.5f);
                    ItemCompatHandler.applyPowerEnchantment(abstractarrow, stack);
                    ItemCompatHandler.applyPunchEnchantment(abstractarrow, stack);
                    ItemCompatHandler.applyFlameEnchantment(abstractarrow, stack);
                    ItemCompatHandler.applyPiercingEnchantment(abstractarrow, stack);
                    ItemCompatHandler.applyLootingEnchantment(abstractarrow, stack);
                    abstractarrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    level.m_7967_((Entity)abstractarrow);
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, shotPitches[i + 1]);
                }
            }
        }
        return EventResult.PASS;
    }

    private static float[] getShotPitches(RandomSource random, float velocity) {
        boolean flag = random.m_188499_();
        return new float[]{1.0f, ItemCompatHandler.getRandomShotPitch(flag, random, velocity), ItemCompatHandler.getRandomShotPitch(!flag, random, velocity)};
    }

    private static float getRandomShotPitch(boolean p_150798_, RandomSource random, float velocity) {
        float f = p_150798_ ? 0.63f : 0.43f;
        return 1.0f / (random.m_188501_() * 0.5f + 1.8f) + f * velocity;
    }

    public static EventResult onUseItemTick(LivingEntity entity, ItemStack useItem, MutableInt useItemRemaining) {
        Item item2 = useItem.m_41720_();
        int duration2 = useItem.m_41779_() - useItemRemaining.getAsInt();
        if (item2 instanceof BowItem && duration2 < 20 || item2 instanceof TridentItem && duration2 < 10) {
            int quickChargeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)useItem);
            useItemRemaining.mapInt(duration -> duration - quickChargeLevel);
        }
        return EventResult.PASS;
    }

    public static void onLootingLevel(LivingEntity entity, @Nullable DamageSource damageSource, MutableInt lootingLevel) {
        if (damageSource == null) {
            return;
        }
        Entity source = damageSource.m_7640_();
        if (source instanceof AbstractArrow) {
            if (source instanceof ThrownTrident) {
                ItemStack stack = ((AbstractArrowAccessor)source).callGetPickupItem();
                int level = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44982_, (ItemStack)stack);
                if (level > 0) {
                    lootingLevel.accept(level);
                }
            } else {
                lootingLevel.accept((int)ModRegistry.ARROW_LOOTING_CAPABILITY.maybeGet((Object)source).map(ArrowLootingCapability::getLevel).orElse((byte)0).byteValue());
            }
        }
    }

    public static Optional<Unit> onShieldBlock(LivingEntity blocker, DamageSource source, float amount) {
        Entity entity;
        if (!source.m_269533_(DamageTypeTags.f_268524_) && (entity = source.m_7640_()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            int level = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44972_, (ItemStack)blocker.m_21211_());
            Enchantments.f_44972_.m_7675_(blocker, (Entity)attacker, level);
        }
        return Optional.empty();
    }

    public static void applyPowerEnchantment(AbstractArrow arrow, ItemStack stack) {
        int powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
        if (powerLevel > 0) {
            arrow.m_36781_(arrow.m_36789_() + (double)powerLevel * 0.5 + 0.5);
        }
    }

    public static void applyPunchEnchantment(AbstractArrow arrow, ItemStack stack) {
        int punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack);
        if (punchLevel > 0) {
            arrow.m_36735_(punchLevel);
        }
    }

    public static void applyFlameEnchantment(AbstractArrow arrow, ItemStack stack) {
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
            arrow.m_20254_(100);
        }
    }

    public static void applyPiercingEnchantment(AbstractArrow arrow, ItemStack stack) {
        int pierceLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)stack);
        if (pierceLevel > 0) {
            arrow.m_36767_((byte)pierceLevel);
        }
    }

    public static void applyLootingEnchantment(AbstractArrow arrow, ItemStack stack) {
        int level = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44982_, (ItemStack)stack);
        if (level > 0) {
            ModRegistry.ARROW_LOOTING_CAPABILITY.maybeGet((Object)arrow).ifPresent(capability -> capability.setLevel((byte)level));
        }
    }
}

