/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalenchants.handler;

import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.event.v1.data.DefaultedInt;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import fuzs.universalenchants.UniversalEnchants;
import fuzs.universalenchants.config.ServerConfig;
import fuzs.universalenchants.core.CommonAbstractions;
import fuzs.universalenchants.mixin.accessor.ExperienceOrbAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BetterEnchantsHandler {
    public static EventResultHolder<InteractionResultHolder<ItemStack>> onUseItem(Player player, Level level, InteractionHand hand) {
        if (!((ServerConfig)UniversalEnchants.CONFIG.get(ServerConfig.class)).trueInfinity) {
            return EventResultHolder.pass();
        }
        ItemStack stack = player.m_21120_(hand);
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0 && (stack.m_41720_() instanceof BowItem || stack.m_41720_() instanceof CrossbowItem && !CrossbowItem.m_40932_((ItemStack)stack))) {
            player.m_6672_(hand);
            return EventResultHolder.interrupt((Object)InteractionResultHolder.m_19090_((Object)stack));
        }
        return EventResultHolder.pass();
    }

    public static EventResult onLivingHurt(LivingEntity entity, DamageSource source, MutableFloat amount) {
        if (!((ServerConfig)UniversalEnchants.CONFIG.get(ServerConfig.class)).noProjectileImmunity) {
            return EventResult.PASS;
        }
        if (!(entity instanceof Player) && source.m_269533_(DamageTypeTags.f_268524_)) {
            entity.f_19802_ = 0;
        }
        return EventResult.PASS;
    }

    public static EventResult onFarmlandTrample(Level level, BlockPos pos, BlockState state, float fallDistance, Entity entity) {
        LivingEntity livingEntity;
        if (!((ServerConfig)UniversalEnchants.CONFIG.get(ServerConfig.class)).noFarmlandTrample) {
            return EventResult.PASS;
        }
        if (entity instanceof LivingEntity && EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44967_, (LivingEntity)(livingEntity = (LivingEntity)entity)) > 0) {
            return EventResult.INTERRUPT;
        }
        return EventResult.PASS;
    }

    public static EventResult onLivingExperienceDrop(LivingEntity entity, @Nullable Player attackingPlayer, DefaultedInt droppedExperience) {
        if (!((ServerConfig)UniversalEnchants.CONFIG.get(ServerConfig.class)).lootingBoostsXp) {
            return EventResult.PASS;
        }
        int level = CommonAbstractions.INSTANCE.getMobLootingLevel((Entity)entity, (Entity)attackingPlayer, attackingPlayer != null ? entity.m_9236_().m_269111_().m_269075_(attackingPlayer) : null);
        if (level > 0) {
            droppedExperience.mapDefaultInt(experience -> BetterEnchantsHandler.getDroppedXp(experience, level));
        }
        return EventResult.PASS;
    }

    private static int getDroppedXp(int droppedXp, int level) {
        float multiplier = (float)(level * (level + 1)) / 10.0f;
        return droppedXp + Math.min(50, (int)((float)droppedXp * multiplier));
    }

    public static EventResult onPickupXp(Player player, ExperienceOrb orb) {
        if (!((ServerConfig)UniversalEnchants.CONFIG.get(ServerConfig.class)).mendingCraftingRepair) {
            return EventResult.PASS;
        }
        player.f_36101_ = 2;
        player.m_7938_((Entity)orb, 1);
        if (orb.m_20801_() > 0) {
            player.m_6756_(orb.m_20801_());
        }
        int count = ((ExperienceOrbAccessor)orb).getCount() - 1;
        ((ExperienceOrbAccessor)orb).setCount(count);
        if (count == 0) {
            orb.m_146870_();
        }
        return EventResult.INTERRUPT;
    }
}

