/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.sodiumextra.client.gui;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Map;
import me.flashyreese.mods.sodiumextra.client.SodiumExtraClientMod;
import me.jellysquid.mods.sodium.client.gui.options.TextProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.glfw.GLFW;

public class SodiumExtraGameOptions {
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2}).create();
    public final AnimationSettings animationSettings = new AnimationSettings();
    public final ParticleSettings particleSettings = new ParticleSettings();
    public final DetailSettings detailSettings = new DetailSettings();
    public final RenderSettings renderSettings = new RenderSettings();
    public final ExtraSettings extraSettings = new ExtraSettings();
    public final SuperSecretSettings superSecretSettings = new SuperSecretSettings();
    private File file;

    public static SodiumExtraGameOptions load(File file) {
        SodiumExtraGameOptions config;
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                config = (SodiumExtraGameOptions)gson.fromJson((Reader)reader, SodiumExtraGameOptions.class);
            }
            catch (Exception e) {
                SodiumExtraClientMod.LOGGER.error("Could not parse config, falling back to defaults!", (Throwable)e);
                config = new SodiumExtraGameOptions();
            }
        } else {
            config = new SodiumExtraGameOptions();
        }
        config.file = file;
        config.writeChanges();
        return config;
    }

    public void writeChanges() {
        File dir = this.file.getParentFile();
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new RuntimeException("Could not create parent directories");
            }
        } else if (!dir.isDirectory()) {
            throw new RuntimeException("The parent file is not a directory");
        }
        try (FileWriter writer = new FileWriter(this.file);){
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save configuration file", e);
        }
    }

    public static class AnimationSettings {
        public boolean animation = true;
        public boolean water = true;
        public boolean lava = true;
        public boolean fire = true;
        public boolean portal = true;
        public boolean blockAnimations = true;
        public boolean sculkSensor = true;
    }

    public static class ParticleSettings {
        public boolean particles = true;
        public boolean rainSplash = true;
        public boolean blockBreak = true;
        public boolean blockBreaking = true;
        @SerializedName(value="other")
        public Map<ResourceLocation, Boolean> otherMap = new Object2BooleanArrayMap();
    }

    public static class DetailSettings {
        public boolean sky = true;
        public boolean sunMoon = true;
        public boolean stars = true;
        public boolean rainSnow = true;
        public boolean biomeColors = true;
        public boolean skyColors = true;
    }

    public static class RenderSettings {
        public FogType fogType = FogType.DEFAULT;
        public int fogDistance = 0;
        public int fogStart = 100;
        public boolean multiDimensionFogControl = false;
        @SerializedName(value="dimensionFogDistance")
        public Map<ResourceLocation, Integer> dimensionFogDistanceMap = new Object2IntArrayMap();
        public boolean lightUpdates = true;
        public boolean itemFrame = true;
        public boolean armorStand = true;
        public boolean painting = true;
        public boolean piston = true;
        public boolean beaconBeam = true;
        public boolean enchantingTableBook = true;
        public boolean itemFrameNameTag = true;
        public boolean playerNameTag = true;

        public static enum FogType implements TextProvider
        {
            DEFAULT("sodium-extra.option.fog_type.default"),
            MOD_COMPAT("sodium-extra.option.fog_type.mod_compat");

            private final Component text;

            private FogType(String text) {
                this.text = Component.m_237115_((String)text);
            }

            public Component getLocalizedName() {
                return this.text;
            }
        }
    }

    public static class ExtraSettings {
        public OverlayCorner overlayCorner = OverlayCorner.TOP_LEFT;
        public TextContrast textContrast = TextContrast.NONE;
        public boolean showFps = false;
        public boolean showFPSExtended = true;
        public boolean showCoords = false;
        public boolean reduceResolutionOnMac = false;
        public boolean useAdaptiveSync = false;
        public int cloudHeight = 192;
        public int cloudDistance = 100;
        public boolean toasts = true;
        public boolean advancementToast = true;
        public boolean recipeToast = true;
        public boolean systemToast = true;
        public boolean tutorialToast = true;
        public boolean instantSneak = false;
        public boolean preventShaders = false;
        public boolean steadyDebugHud = true;
        public int steadyDebugHudRefreshInterval = 1;
    }

    public static class SuperSecretSettings {
        public boolean fetchSodiumExtraCrowdinTranslations = false;
        public String sodiumExtraCrowdinProjectIdentifier = "sodium-extra";
        public boolean fetchSodiumCrowdinTranslations = false;
        public String sodiumCrowdinProjectIdentifier = "sodium-fabric";
    }

    public static enum VerticalSyncOption implements TextProvider
    {
        OFF("options.off"),
        ON("options.on"),
        ADAPTIVE("sodium-extra.option.use_adaptive_sync.name", GLFW.glfwExtensionSupported((CharSequence)"GLX_EXT_swap_control_tear") || GLFW.glfwExtensionSupported((CharSequence)"WGL_EXT_swap_control_tear"));

        private final Component name;
        private final boolean supported;

        private VerticalSyncOption(String name) {
            this(name, true);
        }

        private VerticalSyncOption(String name, boolean supported) {
            this.name = Component.m_237115_((String)name);
            this.supported = supported;
        }

        public static VerticalSyncOption[] getAvailableOptions() {
            return (VerticalSyncOption[])Arrays.stream(VerticalSyncOption.values()).filter(o -> o.supported).toArray(VerticalSyncOption[]::new);
        }

        public Component getLocalizedName() {
            return this.name;
        }
    }

    public static enum TextContrast implements TextProvider
    {
        NONE("sodium-extra.option.text_contrast.none"),
        BACKGROUND("sodium-extra.option.text_contrast.background"),
        SHADOW("sodium-extra.option.text_contrast.shadow");

        private final Component text;

        private TextContrast(String text) {
            this.text = Component.m_237115_((String)text);
        }

        public Component getLocalizedName() {
            return this.text;
        }
    }

    public static enum OverlayCorner implements TextProvider
    {
        TOP_LEFT("sodium-extra.option.overlay_corner.top_left"),
        TOP_RIGHT("sodium-extra.option.overlay_corner.top_right"),
        BOTTOM_LEFT("sodium-extra.option.overlay_corner.bottom_left"),
        BOTTOM_RIGHT("sodium-extra.option.overlay_corner.bottom_right");

        private final Component text;

        private OverlayCorner(String text) {
            this.text = Component.m_237115_((String)text);
        }

        public Component getLocalizedName() {
            return this.text;
        }
    }
}

