/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcneg.compositematerial.common.items.armors;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.github.rcneg.compositematerial.common.config.Config;
import io.github.rcneg.compositematerial.common.init.ItemRegistry;
import io.github.rcneg.compositematerial.common.items.armors.CMArmorItems;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;

public class EtheriteArmors
extends CMArmorItems {
    public EtheriteArmors(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(this.m_7167_(slot));
        if (slot == EquipmentSlot.HEAD && stack.m_150930_((Item)ItemRegistry.ETHERITE_HELMET.get())) {
            builder.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(UUID.fromString("12345678-8975-1244-7120-823039137111"), "etherite_armor_add_health", 14.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22286_, (Object)new AttributeModifier(UUID.fromString("12345678-8975-1244-7120-918179719961"), "etherite_head_add_luck", 10.0, AttributeModifier.Operation.ADDITION));
        } else if (slot == EquipmentSlot.CHEST && stack.m_150930_((Item)ItemRegistry.ETHERITE_CHESTPLATE.get())) {
            builder.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(UUID.fromString("12345678-4143-6188-5454-419203311511"), "etherite_armor_add_health", 18.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(UUID.fromString("12345678-4143-6188-5454-821136036032"), "etherite_chest_add_attack", 0.7, AttributeModifier.Operation.MULTIPLY_BASE));
        } else if (slot == EquipmentSlot.LEGS && stack.m_150930_((Item)ItemRegistry.ETHERITE_LEGGINGS.get())) {
            builder.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(UUID.fromString("12345678-8717-1264-0999-548882903870"), "etherite_armor_add_health", 16.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()), (Object)new AttributeModifier(UUID.fromString("12345678-8717-1264-0999-254449325829"), "etherite_leggings_add_step", 1.0, AttributeModifier.Operation.ADDITION));
        } else if (slot == EquipmentSlot.FEET && stack.m_150930_((Item)ItemRegistry.ETHERITE_BOOTS.get())) {
            builder.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(UUID.fromString("12345678-2358-1274-2343-213601639069"), "etherite_armor_add_health", 12.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(UUID.fromString("12345678-2358-1274-2343-256643988120"), "etherite_boots_add_speed", 0.4, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        return builder.build();
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return true;
    }

    public void m_6883_(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(itemstack, world, entity, slot, selected);
        CompoundTag tag = itemstack.m_41783_();
        if (tag != null) {
            tag.m_128379_("Unbreakable", true);
        }
    }

    public void onArmorTick(ItemStack itemstack, Level level, Player player) {
        if (!level.m_5776_()) {
            float f;
            if (player.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ItemRegistry.ETHERITE_HELMET.get()) && player.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)ItemRegistry.ETHERITE_CHESTPLATE.get()) && player.m_6844_(EquipmentSlot.LEGS).m_150930_((Item)ItemRegistry.ETHERITE_LEGGINGS.get()) && player.m_6844_(EquipmentSlot.FEET).m_150930_((Item)ItemRegistry.ETHERITE_BOOTS.get()) && player.m_20186_() > (double)(level.m_141937_() - 64) && (f = player.m_21223_()) > 0.0f) {
                player.m_21153_(f + (float)((Double)Config.ETHERITE_HEALTH_HEAL.get() / 20.0));
            }
            if (!player.m_7500_() && !player.m_5833_() && ((Boolean)Config.ETHERITE_FLIGHT.get()).booleanValue()) {
                if (player.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ItemRegistry.ETHERITE_HELMET.get()) && player.m_6844_(EquipmentSlot.LEGS).m_150930_((Item)ItemRegistry.ETHERITE_LEGGINGS.get()) && player.m_6844_(EquipmentSlot.FEET).m_150930_((Item)ItemRegistry.ETHERITE_BOOTS.get()) && player.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)ItemRegistry.ETHERITE_CHESTPLATE.get())) {
                    player.m_150110_().f_35936_ = true;
                    player.m_6885_();
                } else {
                    player.m_150110_().f_35936_ = false;
                    player.m_150110_().f_35935_ = false;
                    player.m_6885_();
                }
            }
            if (!level.m_5776_() && (player.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ItemRegistry.ETHERITE_HELMET.get()) || player.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)ItemRegistry.ETHERITE_CHESTPLATE.get()) || player.m_6844_(EquipmentSlot.LEGS).m_150930_((Item)ItemRegistry.ETHERITE_LEGGINGS.get()) || player.m_6844_(EquipmentSlot.FEET).m_150930_((Item)ItemRegistry.ETHERITE_BOOTS.get()))) {
                player.m_20095_();
                player.m_146917_(0);
                ArrayList list = new ArrayList(player.m_21220_());
                for (MobEffectInstance ins : list) {
                    if (ins.m_19544_().m_19483_() == MobEffectCategory.BENEFICIAL) continue;
                    player.m_21195_(ins.m_19544_());
                    if (!player.m_21023_(ins.m_19544_())) continue;
                    player.m_21221_().remove(ins.m_19544_());
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.composite_material.etherite_armor").m_130940_(ChatFormatting.DARK_PURPLE));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.composite_material.etherite_armor_1").m_130940_(ChatFormatting.DARK_PURPLE));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.composite_material.etherite_armor_2").m_130940_(ChatFormatting.GOLD));
    }
}

