/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcneg.compositematerial.common.events;

import io.github.rcneg.compositematerial.common.config.Config;
import io.github.rcneg.compositematerial.common.init.ItemRegistry;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SpawnEvents {
    @SubscribeEvent
    public static void onEntitySpawn(EntityJoinLevelEvent event) {
        Warden warden;
        Entity entity = event.getEntity();
        if (entity instanceof Warden && (warden = (Warden)entity).m_20089_() == Pose.EMERGING && ((Boolean)Config.ECHOIUM_STOP_SPAWN.get()).booleanValue()) {
            Vec3 center = new Vec3(warden.m_20185_(), warden.m_20186_(), warden.m_20189_());
            List<Entity> entities = event.getEntity().m_9236_().m_6443_(Entity.class, new AABB(center, center).m_82400_(64.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(center))).toList();
            for (Entity target : entities) {
                Player player;
                if (!(target instanceof Player) || !(player = (Player)target).m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ItemRegistry.ECHOIUM_HELMET.get()) || !player.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)ItemRegistry.ECHOIUM_CHESTPLATE.get()) || !player.m_6844_(EquipmentSlot.LEGS).m_150930_((Item)ItemRegistry.ECHOIUM_LEGGINGS.get()) || !player.m_6844_(EquipmentSlot.FEET).m_150930_((Item)ItemRegistry.ECHOIUM_BOOTS.get())) continue;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityTickForAllay(LivingEvent.LivingTickEvent event) {
        Allay allay;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Allay && (allay = (Allay)livingEntity).m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)ItemRegistry.DUNGEON_STEEL_INGOT.get())) {
            if (!allay.m_21023_(MobEffects.f_216964_)) {
                allay.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 220, 2, false, true, true));
            }
            if (allay.m_21023_(MobEffects.f_216964_) && allay.m_21124_(MobEffects.f_216964_).m_19557_() < 20) {
                allay.m_216990_(SoundEvents.f_215672_);
                allay.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_235902_, allay.m_20185_(), allay.m_20186_(), allay.m_20189_(), 0.0, 0.0, 0.0);
                allay.m_19998_((ItemLike)ItemRegistry.ALLAY_STEEL_INGOT.get());
                allay.m_19998_((ItemLike)ItemRegistry.ALLAY_STEEL_INGOT.get());
                allay.m_146870_();
            }
        }
    }
}

