/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcneg.compositematerial.common.events;

import io.github.rcneg.compositematerial.common.config.Config;
import io.github.rcneg.compositematerial.common.init.ItemRegistry;
import io.github.rcneg.compositematerial.common.tags.ModTags;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class AttackEvents {
    @SubscribeEvent
    public static void onPlayerLeftClickEntity(AttackEntityEvent event) {
        Entity entity;
        if (event.getEntity().m_21205_().m_204117_(ModTags.RUSTED_COPPER_TOOLS)) {
            ((LivingEntity)event.getTarget()).m_7292_(new MobEffectInstance(MobEffects.f_19614_, 60, 0, false, true, true));
        }
        if (event.getEntity().m_21205_().m_150930_((Item)ItemRegistry.DUNGEON_PICKAXE.get()) && (entity = event.getTarget()) instanceof Monster) {
            Monster entity2 = (Monster)entity;
            Silverfish mite = (Silverfish)EntityType.f_20523_.m_20615_(event.getEntity().m_9236_());
            mite.m_7678_(entity2.m_20185_(), entity2.m_20186_(), entity2.m_20189_(), entity2.m_146908_(), 0.0f);
            mite.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 4, false, true, true));
            entity2.m_9236_().m_7967_((Entity)mite);
            entity2.m_6710_((LivingEntity)mite);
            mite.m_6710_((LivingEntity)entity2);
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity source;
        ItemStack weapon;
        Entity entity;
        LivingEntity entity2 = event.getEntity();
        Level level = event.getEntity().m_9236_();
        if (!level.m_5776_() && (entity = event.getSource().m_7640_()) instanceof LivingEntity && (weapon = (source = (LivingEntity)entity).m_21205_()).m_204117_(ModTags.ECHOIUM_TOOLS) && entity2.m_21230_() > 0) {
            float d0 = (float)(entity2.m_21230_() * (Integer)Config.ECHOIUM_EXTRA_DAMAGE.get()) / 100.0f;
            float d1 = (Integer)Config.ECHOIUM_EXTRA_LIMIT.get() != 0 ? Math.min(d0, (float)((Integer)Config.ECHOIUM_EXTRA_LIMIT.get()).intValue()) : d0;
            event.setAmount(event.getAmount() + d1);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity entity;
        LivingEntity entity2 = event.getEntity();
        Level level = event.getEntity().m_9236_();
        if (!level.m_5776_() && (entity = event.getSource().m_7640_()) instanceof LivingEntity) {
            LivingEntity source = (LivingEntity)entity;
            ItemStack weapon = source.m_21205_();
            if (weapon.m_150930_((Item)ItemRegistry.DISC_AXE.get()) && entity2 instanceof Warden) {
                event.setAmount(event.getAmount() * (float)((Double)Config.DISC_AXE_BASE.get() / 100.0));
            }
            if (weapon.m_204117_(ModTags.ETHERITE_TOOLS)) {
                float d0 = (entity2.m_21233_() - entity2.m_21223_()) * (float)((Integer)Config.ETHERITE_EXTRA_DAMAGE.get()).intValue() / 100.0f;
                float d1 = (Integer)Config.ETHERITE_EXTRA_LIMIT.get() != 0 ? Math.min(d0, (float)((Integer)Config.ETHERITE_EXTRA_LIMIT.get()).intValue()) : d0;
                event.setAmount(event.getAmount() + d1);
            }
            if (weapon.m_150930_((Item)ItemRegistry.DUNGEON_HAMMER.get())) {
                float h = (float)((double)source.f_19789_ * (Double)Config.DUNGEON_HAMMER_MULTI.get());
                event.setAmount(event.getAmount() + h);
                if (source instanceof Player) {
                    Player player1 = (Player)source;
                    player1.m_5661_((Component)Component.m_237113_((String)String.valueOf((float)Math.round(h * 10.0f) / 10.0f)), true);
                }
                source.m_183634_();
            }
            if (weapon.m_204117_(ModTags.ALLAY_STEEL_TOOLS)) {
                Vec3 center = new Vec3(entity2.m_20185_(), entity2.m_20186_(), entity2.m_20189_());
                List<Entity> entities = event.getEntity().m_9236_().m_6443_(Entity.class, new AABB(center, center).m_82400_(((Double)Config.ALLAY_ATTACK_RANGE.get()).doubleValue()), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(center))).toList();
                for (Entity target : entities) {
                    if (event.getEntity().m_6095_() != target.m_6095_()) continue;
                    target.m_6469_(event.getEntity().m_9236_().m_269111_().m_269075_((Player)event.getSource().m_7639_()), event.getAmount());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityLoot(LivingDropsEvent event) {
        Entity head;
        Entity egg;
        ItemStack drops;
        Entity drop;
        LivingEntity player;
        Entity entity;
        if (!event.getEntity().m_9236_().m_5776_() && (entity = event.getSource().m_7639_()) instanceof LivingEntity && (player = (LivingEntity)entity).m_21205_().m_150930_((Item)ItemRegistry.ABYSS_BLADE.get()) && event.getEntity().m_6336_() == MobType.f_21644_) {
            switch ((int)Math.round(Math.random() * 10.0)) {
                case 1: {
                    drop = Items.f_42715_;
                    break;
                }
                case 2: {
                    drop = Items.f_42355_;
                    break;
                }
                case 3: {
                    drop = Items.f_42696_;
                    break;
                }
                case 4: {
                    drop = Items.f_42526_;
                    break;
                }
                case 5: {
                    drop = Items.f_42527_;
                    break;
                }
                case 6: {
                    drop = Items.f_41868_;
                    break;
                }
                case 7: {
                    drop = Items.f_41867_;
                    break;
                }
                case 8: {
                    drop = Items.f_41910_;
                    break;
                }
                case 9: {
                    drop = Items.f_42279_;
                    break;
                }
                case 10: {
                    drop = Items.f_42529_;
                    break;
                }
                default: {
                    drop = Items.f_42528_;
                }
            }
            drops = drop.m_7968_();
            AttackEvents.addEntityDrops(event, drops, 0, 1.0f, 0.0f);
        }
        if (!event.getEntity().m_9236_().m_5776_() && (drop = event.getSource().m_7639_()) instanceof LivingEntity && (player = (LivingEntity)drop).m_21205_().m_150930_((Item)ItemRegistry.DISC_AXE.get()) && event.getEntity() instanceof Warden) {
            switch ((int)Math.round(Math.random() * 10.0)) {
                case 1: {
                    drop = Items.f_220192_;
                    break;
                }
                case 2: {
                    drop = Items.f_220195_;
                    break;
                }
                case 3: {
                    drop = Items.f_220194_;
                    break;
                }
                case 4: {
                    drop = Items.f_151042_;
                    break;
                }
                case 5: {
                    drop = Items.f_220193_;
                    break;
                }
                case 6: {
                    drop = Items.f_220218_;
                    break;
                }
                case 7: {
                    drop = Items.f_220211_;
                    break;
                }
                case 8: {
                    drop = (Item)ItemRegistry.ECHOIUM_NUGGET.get();
                    break;
                }
                case 9: {
                    drop = (Item)ItemRegistry.WARDEN_HAND.get();
                    break;
                }
                default: {
                    drop = Items.f_220224_;
                }
            }
            drops = drop.m_7968_();
            AttackEvents.addEntityDrops(event, drops, 0, 1.0f, 0.0f);
        }
        if (!event.getEntity().m_9236_().m_5776_() && (drop = event.getSource().m_7639_()) instanceof LivingEntity && (player = (LivingEntity)drop).m_21205_().m_150930_((Item)ItemRegistry.DUNGEON_SWORD.get())) {
            egg = new ItemStack((ItemLike)ForgeSpawnEggItem.fromEntityType((EntityType)event.getEntity().m_6095_()));
            int ench = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44982_, (ItemStack)player.m_21205_());
            if (Math.random() <= (double)((float)((Double)Config.DUNGEON_SWORD_BASE.get() / 100.0) + (float)ench * (float)((Double)Config.DUNGEON_SWORD_ENCH.get() / 100.0)) && egg.m_41720_() != ItemStack.f_41583_.m_41720_()) {
                event.getEntity().m_19983_((ItemStack)egg);
            }
        }
        if (!event.getEntity().m_9236_().m_5776_() && (egg = event.getSource().m_7639_()) instanceof LivingEntity && (player = (LivingEntity)egg).m_21205_().m_150930_((Item)ItemRegistry.DUNGEON_AXE.get())) {
            LivingEntity livingEntity;
            head = null;
            int ench = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44987_, (ItemStack)player.m_21205_());
            if (event.getEntity() instanceof Zombie) {
                head = Items.f_42681_.m_7968_();
            }
            if (event.getEntity() instanceof Skeleton) {
                head = Items.f_42678_.m_7968_();
            }
            if (event.getEntity() instanceof WitherSkeleton || event.getEntity() instanceof WitherBoss) {
                head = Items.f_42679_.m_7968_();
            }
            if (event.getEntity() instanceof Creeper) {
                head = Items.f_42682_.m_7968_();
            }
            if (event.getEntity() instanceof EnderDragon) {
                head = Items.f_42683_.m_7968_();
            }
            if (event.getEntity() instanceof Piglin) {
                head = Items.f_260451_.m_7968_();
            }
            if ((livingEntity = event.getEntity()) instanceof Player) {
                Player killedPlayer = (Player)livingEntity;
                head = Items.f_42680_.m_7968_();
                head.m_41784_().m_128359_("SkullOwner", killedPlayer.m_36316_().getName());
            }
            AttackEvents.addEntityDrops(event, (ItemStack)head, ench, (float)((Double)Config.DUNGEON_AXE_BASE.get() / 100.0), (float)((Double)Config.DUNGEON_AXE_ENCH.get() / 100.0));
        }
        if (!event.getEntity().m_9236_().m_5776_() && (head = event.getSource().m_7639_()) instanceof LivingEntity && (player = (LivingEntity)head).m_21205_().m_150930_((Item)ItemRegistry.DISC_SWORD.get())) {
            LivingEntity target = event.getEntity();
            int ench = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44982_, (ItemStack)player.m_21205_());
            Item drop2 = target instanceof PiglinBrute ? Items.f_42419_ : (target instanceof Piglin ? Items.f_42436_ : (target instanceof WanderingTrader ? Items.f_42437_ : (target instanceof Villager ? Items.f_42777_ : (target.m_6336_() == MobType.f_21643_ ? Items.f_42747_ : Items.f_42417_))));
            ItemStack drops2 = drop2.m_7968_();
            AttackEvents.addEntityDrops(event, drops2, ench, (float)((Double)Config.DISC_SWORD_BASE.get() / 100.0), (float)((Double)Config.DISC_SWORD_ENCH.get() / 100.0));
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        if (!event.getEntity().m_9236_().m_5776_()) {
            LivingEntity entity = event.getEntity();
            ItemStack item1 = entity.m_21205_();
            ItemStack item2 = entity.m_21206_();
            if (item1.m_150930_((Item)ItemRegistry.ETHERITE_TOTEM.get()) || item2.m_150930_((Item)ItemRegistry.ETHERITE_TOTEM.get())) {
                ItemStack item;
                ItemStack itemStack = item = item1.m_150930_((Item)ItemRegistry.ETHERITE_TOTEM.get()) ? item1 : item2;
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (!player.m_36335_().m_41519_(item.m_41720_())) {
                        player.m_36335_().m_41524_(item.m_41720_(), ((Integer)Config.TOTEM_COOLDOWN.get()).intValue());
                        Minecraft.m_91087_().f_91063_.m_109113_(item);
                        entity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200, 4, false, true, true));
                        entity.m_216990_(SoundEvents.f_12513_);
                        entity.m_21153_(entity.m_21233_());
                        event.setCanceled(true);
                    }
                } else {
                    entity.m_216990_(SoundEvents.f_12513_);
                    entity.m_21153_(entity.m_21233_());
                    event.setCanceled(true);
                }
            }
        }
    }

    public static void addEntityDrops(LivingDropsEvent event, ItemStack item, int ench, float rate, float enchRate) {
        if (Math.random() <= (double)(rate + (float)ench * enchRate)) {
            ItemEntity itemEntity = new ItemEntity(event.getEntity().m_9236_(), event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), item);
            itemEntity.m_32010_(10);
            event.getDrops().add(itemEntity);
        }
    }
}

