/*
 * Decompiled with CFR 0.152.
 */
package io.github.rcneg.compositematerial.common.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Config {
    public static ForgeConfigSpec COMMON_CONFIG;
    public static final String ALLAY_STEEL = "allaySteel";
    public static ForgeConfigSpec.DoubleValue ALLAY_ATTACK_RANGE;
    public static ForgeConfigSpec.IntValue ALLAY_BREAK_RANGE;
    public static ForgeConfigSpec.IntValue ALLAY_BREAK_LIMIT;
    public static ForgeConfigSpec.DoubleValue ALLAY_HEALTH_HEAL;
    public static final String DUNGEON_STEEL = "dungeonSteel";
    public static ForgeConfigSpec.DoubleValue DUNGEON_AXE_BASE;
    public static ForgeConfigSpec.DoubleValue DUNGEON_AXE_ENCH;
    public static ForgeConfigSpec.DoubleValue DUNGEON_SWORD_BASE;
    public static ForgeConfigSpec.DoubleValue DUNGEON_SWORD_ENCH;
    public static ForgeConfigSpec.DoubleValue DUNGEON_HAMMER_MULTI;
    public static final String DISC = "disc";
    public static ForgeConfigSpec.DoubleValue DISC_AXE_BASE;
    public static ForgeConfigSpec.DoubleValue DISC_SWORD_BASE;
    public static ForgeConfigSpec.DoubleValue DISC_SWORD_ENCH;
    public static ForgeConfigSpec.DoubleValue DISC_PICKAXE_BASE;
    public static ForgeConfigSpec.DoubleValue DISC_PICKAXE_ENCH;
    public static final String ECHOIUM = "echoium";
    public static ForgeConfigSpec.IntValue ECHOIUM_EXTRA_DAMAGE;
    public static ForgeConfigSpec.IntValue ECHOIUM_EXTRA_LIMIT;
    public static ForgeConfigSpec.BooleanValue ECHOIUM_STOP_SPAWN;
    public static final String ETHERITE = "etherite";
    public static ForgeConfigSpec.IntValue ETHERITE_EXTRA_DAMAGE;
    public static ForgeConfigSpec.IntValue ETHERITE_EXTRA_LIMIT;
    public static ForgeConfigSpec.DoubleValue ETHERITE_HEALTH_HEAL;
    public static ForgeConfigSpec.BooleanValue ETHERITE_FLIGHT;
    public static final String MAGIC_ITEMS = "magicItems";
    public static ForgeConfigSpec.IntValue NUGGET_MAX_REPAIR;
    public static ForgeConfigSpec.IntValue BOOK_MAX_REINFORCE;
    public static final String MISC = "misc";
    public static ForgeConfigSpec.IntValue DUNGEON_CHANCE;
    public static ForgeConfigSpec.IntValue TOTEM_COOLDOWN;
    public static ForgeConfigSpec.IntValue SONIC_DAMAGE;
    public static ForgeConfigSpec.IntValue SONIC_LENGTH;
    public static ForgeConfigSpec.BooleanValue SONIC_DESTROY;

    static {
        ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
        COMMON_BUILDER.comment("AllaySteel").push(ALLAY_STEEL);
        ALLAY_ATTACK_RANGE = COMMON_BUILDER.comment("Define the max area attack range of Allay Steel Tools.").defineInRange("attackRange", 7.0, 0.0, Double.MAX_VALUE);
        ALLAY_BREAK_RANGE = COMMON_BUILDER.comment("Define the max area break range of Allay Steel Tools.").defineInRange("breakRange", 7, 0, Integer.MAX_VALUE);
        ALLAY_BREAK_LIMIT = COMMON_BUILDER.comment("Define the max area break amount of Allay Steel Tools.").defineInRange("breakLimit", 64, 0, Integer.MAX_VALUE);
        ALLAY_HEALTH_HEAL = COMMON_BUILDER.comment("Define the heal amount in each second when player equipped full set.").defineInRange("healAmount", 2.0, 0.0, Double.MAX_VALUE);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("DungeonSteel").push(DUNGEON_STEEL);
        DISC_AXE_BASE = COMMON_BUILDER.comment("Define the damage multiple rate of Disc Axe.").defineInRange("damageRate", 500.0, 0.0, Double.MAX_VALUE);
        DISC_SWORD_BASE = COMMON_BUILDER.comment("Define the base chance to get special drops for Disc Sword.").defineInRange("enchantRate", 20.0, 0.0, Double.MAX_VALUE);
        DISC_SWORD_ENCH = COMMON_BUILDER.comment("Define the extra chance to get special drops for Disc Sword by enchantment each level.").defineInRange("enchantRate", 5.0, 0.0, Double.MAX_VALUE);
        DISC_PICKAXE_BASE = COMMON_BUILDER.comment("Define the base chance to get special drops for Disc Sword.").defineInRange("enchantRate", 10.0, 0.0, Double.MAX_VALUE);
        DISC_PICKAXE_ENCH = COMMON_BUILDER.comment("Define the extra chance to get special drops for Disc Sword by enchantment each level.").defineInRange("extraDamage", 5.0, 0.0, Double.MAX_VALUE);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Disc").push(DISC);
        DUNGEON_AXE_BASE = COMMON_BUILDER.comment("Define the base chance to get special drops for Dungeon Axe.").defineInRange("baseRate", 10.0, 0.0, Double.MAX_VALUE);
        DUNGEON_AXE_ENCH = COMMON_BUILDER.comment("Define the extra chance to get special drops for Dungeon Axe by enchantment each level.").defineInRange("enchantRate", 15.0, 0.0, Double.MAX_VALUE);
        DUNGEON_SWORD_BASE = COMMON_BUILDER.comment("Define the base chance to get special drops for Dungeon Sword.").defineInRange("enchantRate", 10.0, 0.0, Double.MAX_VALUE);
        DUNGEON_SWORD_ENCH = COMMON_BUILDER.comment("Define the extra chance to get special drops for Dungeon Sword by enchantment each level.").defineInRange("enchantRate", 5.0, 0.0, Double.MAX_VALUE);
        DUNGEON_HAMMER_MULTI = COMMON_BUILDER.comment("Define the extra damage of Dungeon Hammer per block.").defineInRange("extraDamage", 3.0, 0.0, Double.MAX_VALUE);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Echoium").push(ECHOIUM);
        ECHOIUM_EXTRA_DAMAGE = COMMON_BUILDER.comment("Define the extra damage dealt by Echoium Tools based on the percentage of target's armor value.").defineInRange("percentage", 50, 0, Integer.MAX_VALUE);
        ECHOIUM_EXTRA_LIMIT = COMMON_BUILDER.comment("Define the max extra damage dealt by Echoium Tools, 0 means no limitation.").defineInRange("maxExtraDamage", 0, 0, Integer.MAX_VALUE);
        ECHOIUM_STOP_SPAWN = COMMON_BUILDER.comment("Define if player can stop Warden spawning when player equipped full set.").define("spawn", true);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Etherite").push(ETHERITE);
        ETHERITE_EXTRA_DAMAGE = COMMON_BUILDER.comment("Define the extra damage dealt by Etherite Tools based on the percentage of target's lost Health.").defineInRange("percentage", 25, 0, Integer.MAX_VALUE);
        ETHERITE_EXTRA_LIMIT = COMMON_BUILDER.comment("Define the max extra damage dealt by Etherite Tools, 0 means no limitation.").defineInRange("maxExtraDamage", 0, 0, Integer.MAX_VALUE);
        ETHERITE_HEALTH_HEAL = COMMON_BUILDER.comment("Define the heal amount in each second when player equipped full set.").defineInRange("healAmount", 1.0, 0.0, Double.MAX_VALUE);
        ETHERITE_FLIGHT = COMMON_BUILDER.comment("Define if player can get the creative flight ability when player equipped full set.").define("flight", true);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("MagicItems").push(MAGIC_ITEMS);
        NUGGET_MAX_REPAIR = COMMON_BUILDER.comment("Define the amount of damage can be repaired by Obsidian Steel Nugget.").defineInRange("repairAmount", 100, 0, Integer.MAX_VALUE);
        BOOK_MAX_REINFORCE = COMMON_BUILDER.comment("Define the max extra level which Reinforce Book can upgrade.").defineInRange("maxReinforceLevel", 4, 0, Integer.MAX_VALUE);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Misc").push(MISC);
        DUNGEON_CHANCE = COMMON_BUILDER.comment("Define the chance of converting Dungeon Steel Ingot.").defineInRange("chance", 30, 0, 100);
        TOTEM_COOLDOWN = COMMON_BUILDER.comment("Define the cool-down of Totem Of Unbreaking.").defineInRange("cooldown", 1000, 0, Integer.MAX_VALUE);
        SONIC_DAMAGE = COMMON_BUILDER.comment("Define the damage of Sonic Boom Wand.").defineInRange("damage", 10, 0, Integer.MAX_VALUE);
        SONIC_LENGTH = COMMON_BUILDER.comment("Define the max attack range of Sonic Boom Wand.").defineInRange("range", 20, 0, Integer.MAX_VALUE);
        SONIC_DESTROY = COMMON_BUILDER.comment("Define if Sonic Boom Wand can destroy dropped items.").define("destroyItems", false);
        COMMON_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
    }
}

