/*
 * Decompiled with CFR 0.152.
 */
package shiroroku.tarotcards.Item;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fml.ModList;
import shiroroku.tarotcards.CuriosCompat;
import shiroroku.tarotcards.Registry.ItemRegistry;
import shiroroku.tarotcards.TarotCards;

public abstract class TarotItem
extends Item {
    public TarotItem() {
        super(new Item.Properties().m_41497_(Rarity.UNCOMMON).m_41487_(1));
    }

    public boolean m_5812_(ItemStack stack) {
        return TarotItem.isActivated(stack);
    }

    public static boolean isActivated(ItemStack tarot) {
        return !tarot.m_41784_().m_128471_("deactivated");
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack tarot = pPlayer.m_21120_(pUsedHand);
        tarot.m_41784_().m_128379_("deactivated", !tarot.m_41784_().m_128471_("deactivated"));
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public static boolean hasTarot(Player player, Item tarot) {
        if (player == null) {
            return false;
        }
        ItemStack deck = null;
        Inventory pInv = player.m_150109_();
        ImmutableList fullInv = ImmutableList.of((Object)pInv.f_35974_, (Object)pInv.f_35975_, (Object)pInv.f_35976_);
        if (ModList.get().isLoaded("curios")) {
            deck = CuriosCompat.getTarotDeckCurio(player);
        }
        for (List compartment : fullInv) {
            for (ItemStack stack : compartment) {
                if (stack.m_150930_(tarot)) {
                    return TarotItem.isActivated(stack);
                }
                if (stack.m_41720_() != ItemRegistry.tarot_deck.get()) continue;
                deck = stack;
            }
        }
        if (deck == null) {
            return false;
        }
        AtomicReference<Object> finalCard = new AtomicReference<Object>(null);
        deck.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (!handler.getStackInSlot(i).m_150930_(tarot)) continue;
                finalCard.set(handler.getStackInSlot(i).m_41777_());
                break;
            }
        });
        return finalCard.get() != null && TarotItem.isActivated(finalCard.get());
    }

    public static void handleAttributeTick(Player player, Attribute a, AttributeModifier mod, Item tarot) {
        TarotItem.handleAttributeTick(player, a, mod, tarot, () -> true);
    }

    public static void handleAttributeTick(Player player, Attribute a, AttributeModifier mod, Item tarot, Supplier<Boolean> additionalRequirements) {
        boolean hasCard;
        boolean bl = hasCard = TarotItem.hasTarot(player, tarot) && additionalRequirements.get() != false;
        if (player.m_21051_(a).m_22109_(mod)) {
            if (!hasCard) {
                TarotCards.LOGGER.debug("Removing Tarot Modifier: {} - {}", (Object)tarot, (Object)mod);
                player.m_21051_(a).m_22120_(mod.m_22209_());
            }
        } else if (hasCard) {
            TarotCards.LOGGER.debug("Adding Tarot Modifier: {} - {}", (Object)tarot, (Object)mod);
            player.m_21051_(a).m_22118_(mod);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".desc")).m_130940_(ChatFormatting.BLUE));
    }
}

