/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.entity.custom.void_blossom;

import com.cerbon.bosses_of_mass_destruction.block.BMDBlocks;
import com.cerbon.bosses_of_mass_destruction.entity.ai.action.IActionWithCooldown;
import com.cerbon.bosses_of_mass_destruction.entity.custom.void_blossom.VoidBlossomEntity;
import com.cerbon.bosses_of_mass_destruction.entity.custom.void_blossom.hitbox.HitboxId;
import com.cerbon.bosses_of_mass_destruction.entity.custom.void_blossom.hitbox.NetworkedHitboxManager;
import com.cerbon.bosses_of_mass_destruction.packet.BMDPacketHandler;
import com.cerbon.bosses_of_mass_destruction.packet.custom.PlaceS2CPacket;
import com.cerbon.bosses_of_mass_destruction.sound.BMDSounds;
import com.cerbon.cerbons_api.api.general.event.EventScheduler;
import com.cerbon.cerbons_api.api.general.event.EventSeries;
import com.cerbon.cerbons_api.api.general.event.IEvent;
import com.cerbon.cerbons_api.api.general.event.TimedEvent;
import com.cerbon.cerbons_api.api.static_utilities.SoundUtils;
import com.cerbon.cerbons_api.api.static_utilities.VecUtils;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class BlossomAction
implements IActionWithCooldown {
    private final VoidBlossomEntity entity;
    private final EventScheduler eventScheduler;
    private final Supplier<Boolean> shouldCancel;
    private final List<Vec3> blossomPositions = Stream.of(VecUtils.xAxis, VecUtils.zAxis, VecUtils.xAxis.m_82548_(), VecUtils.zAxis.m_82548_(), VecUtils.xAxis.m_82549_(VecUtils.zAxis), VecUtils.xAxis.m_82549_(VecUtils.zAxis.m_82548_()), VecUtils.xAxis.m_82548_().m_82549_(VecUtils.zAxis), VecUtils.xAxis.m_82548_().m_82549_(VecUtils.zAxis.m_82548_())).map(vec3 -> vec3.m_82541_().m_82490_(15.0)).toList();

    public BlossomAction(VoidBlossomEntity entity, EventScheduler eventScheduler, Supplier<Boolean> shouldCancel) {
        this.entity = entity;
        this.eventScheduler = eventScheduler;
        this.shouldCancel = shouldCancel;
    }

    @Override
    public int perform() {
        Level level = this.entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return 80;
        }
        this.eventScheduler.addEvent((IEvent)new EventSeries(new IEvent[]{new TimedEvent(() -> this.entity.m_20088_().m_135381_(NetworkedHitboxManager.hitbox, (Object)HitboxId.SpikeWave3.getId()), 20, 1, this.shouldCancel), new TimedEvent(() -> this.entity.m_20088_().m_135381_(NetworkedHitboxManager.hitbox, (Object)HitboxId.Idle.getId()), 80)}));
        this.placeBlossoms((ServerLevel)level);
        return 120;
    }

    private void placeBlossoms(ServerLevel level) {
        List positions = this.blossomPositions.stream().map(pos -> BlockPos.m_274446_((Position)pos.m_82549_(this.entity.m_20182_()))).collect(Collectors.toList());
        Collections.shuffle(positions);
        float hpRatio = this.entity.m_21223_() / this.entity.m_21233_();
        int protectedPositions = hpRatio < VoidBlossomEntity.hpMilestones.get(1).floatValue() ? 6 : (hpRatio < VoidBlossomEntity.hpMilestones.get(2).floatValue() ? 3 : 0);
        SoundUtils.playSound((ServerLevel)level, (Vec3)this.entity.m_20182_(), (SoundEvent)((SoundEvent)BMDSounds.SPIKE_WAVE_INDICATOR.get()), (SoundSource)SoundSource.HOSTILE, (float)2.0f, (float)0.7f, (double)64.0, null);
        for (int i = 0; i < 8; ++i) {
            int i1 = i;
            this.eventScheduler.addEvent((IEvent)new TimedEvent(() -> {
                BlockPos blossomPos = (BlockPos)positions.get(i1);
                level.m_46597_(blossomPos, Blocks.f_152544_.m_49966_());
                level.m_46597_(blossomPos.m_7494_(), ((Block)BMDBlocks.VOID_BLOSSOM.get()).m_49966_());
                BMDPacketHandler.sendToAllPlayersTrackingChunk(new PlaceS2CPacket(VecUtils.asVec3((BlockPos)blossomPos).m_82549_(VecUtils.unit.m_82490_(0.5))), level, this.entity.m_20182_());
                SoundUtils.playSound((ServerLevel)level, (Vec3)VecUtils.asVec3((BlockPos)blossomPos), (SoundEvent)((SoundEvent)BMDSounds.PETAL_BLADE.get()), (SoundSource)SoundSource.HOSTILE, (float)1.0f, (float)SoundUtils.randomPitch((RandomSource)this.entity.m_217043_()), (double)64.0, null);
                if (i1 < protectedPositions) {
                    for (int x = -1; x <= 1; ++x) {
                        for (int z = -1; z <= 1; ++z) {
                            for (int y = 0; y <= 2; ++y) {
                                if (x == 0 && z == 0) continue;
                                level.m_46597_(blossomPos.m_7918_(x, y, z), ((Block)BMDBlocks.VINE_WALL.get()).m_49966_());
                            }
                        }
                    }
                }
            }, 40 + i * 8, 1, this.shouldCancel));
        }
    }
}

