/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.logging.LogUtils;
import java.io.OutputStream;
import java.io.PrintStream;
import java.time.Duration;
import java.time.Instant;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.selector.options.EntitySelectorOptions;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.locale.Language;
import net.minecraft.server.DebugLoggedPrintStream;
import net.minecraft.server.LoggedPrintStream;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraftforge.registries.GameData;
import org.slf4j.Logger;

public class Bootstrap {
    public static final PrintStream f_135866_ = System.out;
    private static volatile boolean f_135867_;
    private static final Logger f_135868_;
    public static final AtomicLong f_285608_;

    public static void m_135870_() {
        if (!f_135867_) {
            f_135867_ = true;
            Instant instant = Instant.now();
            if (BuiltInRegistries.f_257047_.m_6566_().isEmpty()) {
                throw new IllegalStateException("Unable to load registries");
            }
            FireBlock.m_53484_();
            ComposterBlock.m_51988_();
            if (EntityType.m_20613_(EntityType.f_20532_) == null) {
                throw new IllegalStateException("Failed loading EntityTypes");
            }
            PotionBrewing.m_43499_();
            EntitySelectorOptions.m_121426_();
            DispenseItemBehavior.m_123402_();
            CauldronInteraction.m_175649_();
            BuiltInRegistries.m_257498_();
            CreativeModeTabs.m_280019_();
            GameData.vanillaSnapshot();
            f_285608_.set(Duration.between(instant, Instant.now()).toMillis());
        }
    }

    private static <T> void m_135871_(Iterable<T> p_135872_, Function<T, String> p_135873_, Set<String> p_135874_) {
        Language language = Language.m_128107_();
        p_135872_.forEach(p_135883_ -> {
            String s = (String)p_135873_.apply(p_135883_);
            if (!language.m_6722_(s)) {
                p_135874_.add(s);
            }
        });
    }

    private static void m_135877_(final Set<String> p_135878_) {
        final Language language = Language.m_128107_();
        GameRules.m_46164_((GameRules.GameRuleTypeVisitor)new GameRules.GameRuleTypeVisitor(){

            public <T extends GameRules.Value<T>> void m_6889_(GameRules.Key<T> p_135897_, GameRules.Type<T> p_135898_) {
                if (!language.m_6722_(p_135897_.m_46331_())) {
                    p_135878_.add(p_135897_.m_46328_());
                }
            }
        });
    }

    public static Set<String> m_135886_() {
        TreeSet<String> set = new TreeSet<String>();
        Bootstrap.m_135871_(BuiltInRegistries.f_256951_, Attribute::m_22087_, set);
        Bootstrap.m_135871_(BuiltInRegistries.f_256780_, EntityType::m_20675_, set);
        Bootstrap.m_135871_(BuiltInRegistries.f_256974_, MobEffect::m_19481_, set);
        Bootstrap.m_135871_(BuiltInRegistries.f_257033_, Item::m_5524_, set);
        Bootstrap.m_135871_(BuiltInRegistries.f_256876_, Enchantment::m_44704_, set);
        Bootstrap.m_135871_(BuiltInRegistries.f_256975_, Block::m_7705_, set);
        Bootstrap.m_135871_(BuiltInRegistries.f_256771_, p_135885_ -> "stat." + p_135885_.toString().replace(':', '.'), set);
        Bootstrap.m_135877_(set);
        return set;
    }

    public static void m_179912_(Supplier<String> p_179913_) {
        if (!f_135867_) {
            throw Bootstrap.m_179916_(p_179913_);
        }
    }

    private static RuntimeException m_179916_(Supplier<String> p_179917_) {
        try {
            String s = p_179917_.get();
            return new IllegalArgumentException("Not bootstrapped (called from " + s + ")");
        }
        catch (Exception exception) {
            IllegalArgumentException runtimeexception = new IllegalArgumentException("Not bootstrapped (failed to resolve location)");
            runtimeexception.addSuppressed(exception);
            return runtimeexception;
        }
    }

    public static void m_135889_() {
        Bootstrap.m_179912_(() -> "validate");
        if (SharedConstants.f_136183_) {
            Bootstrap.m_135886_().forEach(p_179915_ -> f_135868_.error("Missing translations: {}", p_179915_));
            Commands.m_82138_();
        }
    }

    private static void m_135890_() {
        if (f_135868_.isDebugEnabled()) {
            System.setErr((PrintStream)new DebugLoggedPrintStream("STDERR", (OutputStream)System.err));
            System.setOut((PrintStream)new DebugLoggedPrintStream("STDOUT", (OutputStream)f_135866_));
        } else {
            System.setErr((PrintStream)new LoggedPrintStream("STDERR", (OutputStream)System.err));
            System.setOut((PrintStream)new LoggedPrintStream("STDOUT", (OutputStream)f_135866_));
        }
    }

    public static void m_135875_(String p_135876_) {
        f_135866_.println(p_135876_);
    }

    static {
        f_135868_ = LogUtils.getLogger();
        f_285608_ = new AtomicLong(-1L);
    }
}

