/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.MultipartModelData;
import net.minecraftforge.common.util.ConcatenatedListView;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class MultiPartBakedModel
implements IDynamicBakedModel {
    private final List<Pair<Predicate<BlockState>, BakedModel>> f_119459_;
    protected final boolean f_119453_;
    protected final boolean f_119454_;
    protected final boolean f_119455_;
    protected final TextureAtlasSprite f_119456_;
    protected final ItemTransforms f_119457_;
    protected final ItemOverrides f_119458_;
    private final Map<BlockState, BitSet> f_119460_ = new Object2ObjectOpenCustomHashMap(Util.m_137583_());
    private final BakedModel defaultModel;

    public MultiPartBakedModel(List<Pair<Predicate<BlockState>, BakedModel>> p_119462_) {
        BakedModel bakedmodel;
        this.f_119459_ = p_119462_;
        this.defaultModel = bakedmodel = (BakedModel)p_119462_.iterator().next().getRight();
        this.f_119453_ = bakedmodel.m_7541_();
        this.f_119454_ = bakedmodel.m_7539_();
        this.f_119455_ = bakedmodel.m_7547_();
        this.f_119456_ = bakedmodel.m_6160_();
        this.f_119457_ = bakedmodel.m_7442_();
        this.f_119458_ = bakedmodel.m_7343_();
    }

    public BitSet getSelectors(@javax.annotation.Nullable BlockState p_235050_) {
        BitSet bitset = this.f_119460_.get((Object)p_235050_);
        if (bitset == null) {
            bitset = new BitSet();
            for (int i = 0; i < this.f_119459_.size(); ++i) {
                Pair<Predicate<BlockState>, BakedModel> pair = this.f_119459_.get(i);
                if (!((Predicate)pair.getLeft()).test(p_235050_)) continue;
                bitset.set(i);
            }
            this.f_119460_.put(p_235050_, bitset);
        }
        return bitset;
    }

    public List<BakedQuad> getQuads(@javax.annotation.Nullable BlockState p_235050_, @javax.annotation.Nullable Direction p_235051_, RandomSource p_235052_, ModelData modelData, @Nullable RenderType renderType) {
        if (p_235050_ == null) {
            return Collections.emptyList();
        }
        BitSet bitset = this.getSelectors(p_235050_);
        ArrayList list = Lists.newArrayList();
        long k = p_235052_.m_188505_();
        for (int j = 0; j < bitset.length(); ++j) {
            if (!bitset.get(j)) continue;
            BakedModel model = (BakedModel)this.f_119459_.get(j).getRight();
            if (renderType != null && !model.getRenderTypes(p_235050_, p_235052_, modelData).contains(renderType)) continue;
            list.add(model.getQuads(p_235050_, p_235051_, RandomSource.m_216335_((long)k), MultipartModelData.resolve((ModelData)modelData, (BakedModel)model), renderType));
        }
        return ConcatenatedListView.of((List)list);
    }

    public boolean m_7541_() {
        return this.f_119453_;
    }

    public boolean useAmbientOcclusion(BlockState state) {
        return this.defaultModel.useAmbientOcclusion(state);
    }

    public boolean useAmbientOcclusion(BlockState state, RenderType renderType) {
        return this.defaultModel.useAmbientOcclusion(state, renderType);
    }

    public boolean m_7539_() {
        return this.f_119454_;
    }

    public boolean m_7547_() {
        return this.f_119455_;
    }

    public boolean m_7521_() {
        return false;
    }

    @Deprecated
    public TextureAtlasSprite m_6160_() {
        return this.f_119456_;
    }

    public TextureAtlasSprite getParticleIcon(ModelData modelData) {
        return this.defaultModel.getParticleIcon(modelData);
    }

    @Deprecated
    public ItemTransforms m_7442_() {
        return this.f_119457_;
    }

    public BakedModel applyTransform(ItemDisplayContext transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
        return this.defaultModel.applyTransform(transformType, poseStack, applyLeftHandTransform);
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        LinkedList<ChunkRenderTypeSet> renderTypeSets = new LinkedList<ChunkRenderTypeSet>();
        BitSet selectors = this.getSelectors(state);
        for (int i = 0; i < selectors.length(); ++i) {
            if (!selectors.get(i)) continue;
            renderTypeSets.add(((BakedModel)this.f_119459_.get(i).getRight()).getRenderTypes(state, rand, data));
        }
        return ChunkRenderTypeSet.union(renderTypeSets);
    }

    public ItemOverrides m_7343_() {
        return this.f_119458_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder {
        private final List<Pair<Predicate<BlockState>, BakedModel>> f_119474_ = Lists.newArrayList();

        public void m_119477_(Predicate<BlockState> p_119478_, BakedModel p_119479_) {
            this.f_119474_.add((Pair<Predicate<BlockState>, BakedModel>)Pair.of(p_119478_, (Object)p_119479_));
        }

        public BakedModel m_119476_() {
            return new MultiPartBakedModel(this.f_119474_);
        }
    }
}

