/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.monobank.event;

import io.github.mortuusars.monobank.Registry;
import io.github.mortuusars.monobank.Thief;
import io.github.mortuusars.monobank.config.Configuration;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class CommonEvents {
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        Registry.Advancements.register();
    }

    public static void onCreativeTabsBuild(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256791_) {
            event.m_246326_((ItemLike)Registry.Items.MONOBANK.get());
        }
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            event.m_246326_((ItemLike)Registry.Items.REPLACEMENT_LOCK.get());
        }
    }

    public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        Player opener = event.getEntity();
        if (!((Boolean)Configuration.THIEF_ENABLED.get()).booleanValue() || opener.m_9236_().f_46443_ || !((Boolean)Configuration.THIEF_INCLUDE_OTHER_CONTAINERS.get()).booleanValue()) {
            return;
        }
        BlockEntity blockEntity = opener.m_9236_().m_7702_(event.getHitVec().m_82425_());
        if (blockEntity instanceof RandomizableContainerBlockEntity) {
            RandomizableContainerBlockEntity containerBE = (RandomizableContainerBlockEntity)blockEntity;
            if (containerBE.f_59605_ != null) {
                if (blockEntity.m_58900_().m_204336_(Registry.BlockTags.LOOTR_CONTAINERS) && !Thief.shouldDeclareThiefForOpeningLootr(containerBE, (LivingEntity)opener)) {
                    return;
                }
                List<LivingEntity> witnesses = Thief.getWitnesses((LivingEntity)opener);
                if (witnesses.size() > 0 && Thief.isInProtectedStructureRange((ServerLevel)opener.m_9236_(), opener.m_20183_())) {
                    Thief.declareThief((LivingEntity)opener, witnesses, Thief.Offence.MODERATE);
                }
            }
        }
    }

    public static void onBlockBroken(BlockEvent.BreakEvent event) {
        ServerLevel serverLevel;
        Player player;
        block6: {
            block5: {
                Level level;
                player = event.getPlayer();
                if (!((Boolean)Configuration.THIEF_ENABLED.get()).booleanValue() || !((level = player.m_9236_()) instanceof ServerLevel)) break block5;
                serverLevel = (ServerLevel)level;
                if (((Boolean)Configuration.THIEF_INCLUDE_OTHER_CONTAINERS.get()).booleanValue()) break block6;
            }
            return;
        }
        BlockEntity blockEntityAtPos = player.m_9236_().m_7702_(event.getPos());
        if (blockEntityAtPos instanceof RandomizableContainerBlockEntity) {
            List<LivingEntity> witnesses;
            RandomizableContainerBlockEntity container = (RandomizableContainerBlockEntity)blockEntityAtPos;
            if (container.f_59605_ != null && Thief.isInProtectedStructureRange(serverLevel, player.m_20183_()) && (witnesses = Thief.getWitnesses((LivingEntity)player)).size() > 0) {
                Thief.declareThief((LivingEntity)player, witnesses, Thief.Offence.HEAVY);
            }
        }
    }

    public static void onEntityInteractEvent(PlayerInteractEvent.EntityInteract event) {
        Entity entity;
        Player player = event.getEntity();
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (((Boolean)Configuration.THIEF_NO_TRADE.get()).booleanValue() && (entity = event.getTarget()) instanceof Villager) {
            Villager villager = (Villager)entity;
            if (((Boolean)Configuration.THIEF_NO_TRADE_ONLY_NEAR_PROTECTED_STRUCTURES.get()).booleanValue() && !Thief.isInProtectedStructureRange(serverLevel, player.m_20183_())) {
                return;
            }
            MobEffectInstance thiefEffect = player.m_21124_((MobEffect)Registry.Effects.THIEF.get());
            if (thiefEffect != null) {
                villager.m_35518_();
                event.setCanceled(true);
            }
        }
    }
}

