/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.monobank.data;

import io.github.mortuusars.monobank.data.provider.Advancements;
import io.github.mortuusars.monobank.data.provider.BlockStates;
import io.github.mortuusars.monobank.data.provider.ItemModels;
import io.github.mortuusars.monobank.data.provider.LootTables;
import io.github.mortuusars.monobank.data.provider.Recipes;
import java.util.Collections;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="monobank", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGeneration {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        PackOutput packOutput = generator.getPackOutput();
        generator.addProvider(event.includeServer(), (DataProvider)new Advancements(generator, event.getLookupProvider(), helper));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(LootTables.BlockLoot::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(LootTables.ChestLoot::new, LootContextParamSets.f_81411_))));
        generator.addProvider(event.includeServer(), (DataProvider)new Recipes(generator));
        BlockStates blockStates = new BlockStates(generator, helper);
        generator.addProvider(event.includeClient(), (DataProvider)blockStates);
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModels(generator, blockStates.models().existingFileHelper));
    }
}

