/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.monobank.core.stealth;

import io.github.mortuusars.monobank.core.stealth.IStealthModifier;
import io.github.mortuusars.monobank.core.stealth.modifier.DarknessModifier;
import io.github.mortuusars.monobank.core.stealth.modifier.InvisibilityModifier;
import io.github.mortuusars.monobank.core.stealth.modifier.SneakingModifier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;

public class Stealth {
    private static List<IStealthModifier> modifiers = new ArrayList<IStealthModifier>();

    public static List<IStealthModifier> getModifiers() {
        return modifiers;
    }

    public static void addModifier(IStealthModifier modifier) {
        modifiers.add(modifier);
    }

    public static void addModifier(int index, IStealthModifier modifier) {
        modifiers.add(index, modifier);
    }

    public static float getValueOf(LivingEntity entity) {
        float value = 1.0f;
        for (IStealthModifier modifier : modifiers) {
            Tuple<Float, Boolean> result = modifier.modify(entity, value);
            value = ((Float)result.m_14418_()).floatValue();
            if (((Boolean)result.m_14419_()).booleanValue()) continue;
            break;
        }
        return value;
    }

    static {
        modifiers.add(new InvisibilityModifier());
        modifiers.add(new SneakingModifier());
        modifiers.add(new DarknessModifier());
    }
}

