/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.monobank.content.monobank.component;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;

public class Owner {
    private static final String TYPE_NBT_KEY = "Type";
    private static final String UUID_NBT_KEY = "UUID";
    private UUID uuid;
    private Type type;

    public Owner(UUID uuid, Type type) {
        this.uuid = uuid;
        this.type = type;
    }

    public Owner(Player player) {
        this.uuid = player.m_20148_();
        this.type = Type.PLAYER;
    }

    public static Owner none() {
        return new Owner(Util.f_137441_, Type.NONE);
    }

    public void setOwner(Player player) {
        Objects.requireNonNull(player);
        this.uuid = player.m_20148_();
        this.type = Type.PLAYER;
    }

    public void setOwner(Type type) {
        if (type == Type.PLAYER) {
            throw new IllegalArgumentException("Cannot set owner to 'Type.PLAYER' without setting UUID. Use setOwner(Player player) overload.");
        }
        this.type = type;
        this.uuid = Util.f_137441_;
    }

    public Type getType() {
        return this.type;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public boolean hasOwner() {
        return this.type == Type.PLAYER || this.type == Type.NPC;
    }

    public boolean isPlayerOwned() {
        return this.type == Type.PLAYER && !this.uuid.equals(Util.f_137441_);
    }

    public boolean isOwnedBy(Player player) {
        return this.isPlayerOwned() && this.uuid.equals(player.m_20148_());
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.type != Type.NONE) {
            tag.m_128359_(TYPE_NBT_KEY, this.type.m_7912_());
            if (this.isPlayerOwned()) {
                tag.m_128362_(UUID_NBT_KEY, this.uuid);
            }
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128441_(TYPE_NBT_KEY)) {
            this.type = Type.byName(tag.m_128461_(TYPE_NBT_KEY));
            if (tag.m_128441_(UUID_NBT_KEY)) {
                this.uuid = tag.m_128342_(UUID_NBT_KEY);
            }
        }
    }

    public static enum Type implements StringRepresentable
    {
        NONE("none"),
        PLAYER("player"),
        NPC("npc");

        private final String name;
        private static final Map<String, Type> BY_NAME;

        private Type(String name) {
            this.name = name;
        }

        public static Type byName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("'name' cannot be null.");
            }
            return BY_NAME.get(name.toLowerCase(Locale.ROOT));
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            BY_NAME = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::m_7912_, ownershipType -> ownershipType));
        }
    }
}

