/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.monobank.content.monobank.component;

import com.mojang.datafixers.util.Either;
import io.github.mortuusars.monobank.content.monobank.MonobankBlockEntity;
import io.github.mortuusars.monobank.content.monobank.unlocking.Combination;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class Lock {
    public static final String LOCKED_TAG = "Locked";
    public static final String COMBINATION_TABLE_TAG = "CombinationTable";
    public static final String COMBINATION_TAG = "Combination";
    public static final String INVENTORY_TAG = "Inventory";
    private Either<ResourceLocation, Combination> combination;
    private final ItemStackHandler inventory;
    private boolean locked = false;
    private final BlockPos pos;
    private final Runnable onLockedChanged;
    private final Consumer<Integer> onLockInventoryChanged;
    private final Supplier<Level> levelSupplier;

    public Lock(BlockPos pos, Runnable onLockChanged, Consumer<Integer> onLockInventoryChanged, Supplier<Level> levelSupplier) {
        this.pos = pos;
        this.onLockedChanged = onLockChanged;
        this.onLockInventoryChanged = onLockInventoryChanged;
        this.levelSupplier = levelSupplier;
        this.combination = Either.right((Object)Combination.empty());
        this.inventory = this.createLockItemHandler();
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public void setCombination(Item first, Item second, Item third) {
        this.combination = Either.right((Object)new Combination(List.of(first, second, third)));
    }

    public void setCombination(Combination combination) {
        this.combination = Either.right((Object)combination);
    }

    public void setCombinationTable(ResourceLocation combinationLootTable) {
        this.combination = Either.left((Object)combinationLootTable);
    }

    public boolean hasCombinationOrCombinationTable() {
        boolean b = !this.combination.right().orElse(Combination.empty()).isEmpty();
        return this.combination.left().isPresent() || b;
    }

    public Combination getCombination() {
        if (this.combination.left().isPresent() && this.tryUnpackCombinationTable()) {
            Objects.requireNonNull(this.levelSupplier.get().m_7702_(this.pos)).m_6596_();
        }
        return this.combination.right().orElse(Combination.empty());
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
        this.onLockedChanged.run();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_(LOCKED_TAG, this.locked);
        this.combination.ifLeft(lootTable -> tag.m_128359_(COMBINATION_TABLE_TAG, lootTable.toString())).ifRight(combination -> tag.m_128365_(COMBINATION_TAG, (Tag)combination.serializeNBT()));
        if (this.hasItemsInInventory()) {
            tag.m_128365_(INVENTORY_TAG, (Tag)this.inventory.serializeNBT());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128456_()) {
            return;
        }
        this.locked = tag.m_128471_(LOCKED_TAG);
        if (tag.m_128425_(COMBINATION_TABLE_TAG, 8)) {
            this.combination = Either.left((Object)new ResourceLocation(tag.m_128461_(COMBINATION_TABLE_TAG)));
        } else if (tag.m_128425_(COMBINATION_TAG, 9)) {
            Combination combination = this.combination.right().orElse(Combination.empty());
            combination.deserializeNBT(tag.m_128437_(COMBINATION_TAG, 8));
            this.combination = Either.right((Object)combination);
        }
        if (tag.m_128425_(INVENTORY_TAG, 10)) {
            this.inventory.deserializeNBT(tag.m_128469_(INVENTORY_TAG));
        }
    }

    public boolean tryUnpackCombinationTable() {
        Level level = this.levelSupplier.get();
        if (level.m_7654_() == null || level.f_46443_) {
            return false;
        }
        Optional combinationTable = this.combination.left();
        if (combinationTable.isEmpty()) {
            return false;
        }
        ResourceLocation lootTable = (ResourceLocation)combinationTable.get();
        LootTable loottable = level.m_7654_().m_278653_().m_278676_(lootTable);
        LootParams lootParams = new LootParams.Builder((ServerLevel)level).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.pos)).m_287235_(LootContextParamSets.f_81411_);
        ObjectArrayList randomItems = loottable.m_287195_(lootParams);
        ArrayList<Item> newCombination = new ArrayList<Item>();
        for (int i = 0; i < 3; ++i) {
            if (randomItems.size() <= i) {
                newCombination.add(Items.f_41852_);
                continue;
            }
            newCombination.add(((ItemStack)randomItems.get(i)).m_41720_());
        }
        Collections.shuffle(newCombination);
        this.combination = Either.right((Object)new Combination(newCombination));
        BlockEntity blockEntity = level.m_7702_(this.pos);
        if (blockEntity instanceof MonobankBlockEntity) {
            MonobankBlockEntity monobankBlockEntity = (MonobankBlockEntity)blockEntity;
            monobankBlockEntity.m_6596_();
        }
        return true;
    }

    private boolean hasItemsInInventory() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    private ItemStackHandler createLockItemHandler() {
        return new ItemStackHandler(NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_)){

            protected void onContentsChanged(int slot) {
                Lock.this.onLockInventoryChanged.accept(slot);
            }
        };
    }
}

