/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.monobank;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.monobank.Registry;
import io.github.mortuusars.monobank.config.Configuration;
import io.github.mortuusars.monobank.content.effect.ThiefEffect;
import io.github.mortuusars.monobank.core.stealth.Stealth;
import io.github.mortuusars.monobank.util.TextUtil;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;

public class Thief {
    public static boolean isInProtectedStructureRange(ServerLevel level, BlockPos thiefPos) {
        if (!((Boolean)Configuration.THIEF_ONLY_NEAR_PROTECTED_STRUCTURES.get()).booleanValue()) {
            return true;
        }
        BlockPos nearestProtectedStructure = level.m_215011_(Registry.StructureTags.THEFT_PROTECTED, thiefPos, 1, false);
        if (nearestProtectedStructure != null) {
            BlockPos heightmapPos = level.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, nearestProtectedStructure);
            double distance = Math.sqrt(thiefPos.m_123331_((Vec3i)heightmapPos));
            return distance <= (double)((Integer)Configuration.THIEF_PROTECTED_STRUCTURE_RANGE.get()).intValue();
        }
        return false;
    }

    public static boolean shouldDeclareThiefForOpeningLootr(RandomizableContainerBlockEntity containerBE, LivingEntity opener) {
        CompoundTag tag = containerBE.m_5995_();
        if (tag.m_128425_("LootrOpeners", 9)) {
            try {
                ListTag lootrOpeners = tag.m_128437_("LootrOpeners", 11);
                UUID livingEntityUUID = opener.m_20148_();
                for (Tag openerUUID : lootrOpeners) {
                    UUID uuid = NbtUtils.m_129233_((Tag)openerUUID);
                    if (!uuid.equals(livingEntityUUID)) continue;
                    return false;
                }
            }
            catch (Exception e) {
                LogUtils.getLogger().error("Monobank has failed to handle Thief interaction for Lootr container: " + e);
                return false;
            }
        }
        return true;
    }

    public static List<LivingEntity> getWitnesses(LivingEntity thief) {
        Player player;
        if (!((Boolean)Configuration.THIEF_ENABLED.get()).booleanValue() || thief instanceof Player && ((player = (Player)thief).m_7500_() || player.m_5833_())) {
            return Collections.emptyList();
        }
        Level level = thief.m_9236_();
        int radius = Math.max((int)(32.0f * Stealth.getValueOf(thief)), 3);
        AABB crimeScene = new AABB(thief.m_20183_()).m_82377_((double)radius, (double)((float)radius * 0.33f), (double)radius);
        Predicate<LivingEntity> isWitness = witness -> {
            float distance = witness.m_20270_((Entity)thief);
            return witness.m_6095_().m_204039_(Registry.EntityTags.THEFT_HATERS) && (witness.m_5803_() && distance <= 3.0f || distance <= 7.0f || distance <= 48.0f && witness.m_142582_((Entity)thief));
        };
        List<LivingEntity> witnesses = level.m_45976_(LivingEntity.class, crimeScene).stream().filter(isWitness).toList();
        return witnesses;
    }

    public static void declareThief(LivingEntity offender, List<LivingEntity> witnesses, Offence offence) {
        if (!((Boolean)Configuration.THIEF_ENABLED.get()).booleanValue()) {
            return;
        }
        offender.m_21195_(MobEffects.f_19595_);
        int durationSeconds = (int)((float)ThiefEffect.getBaseDurationSeconds() * offence.getModifier());
        int amplifier = offence.getAmplifier();
        MobEffectInstance existingThiefEffect = offender.m_21124_((MobEffect)Registry.Effects.THIEF.get());
        if (existingThiefEffect != null) {
            amplifier = Math.max(amplifier, existingThiefEffect.m_19564_());
            int existingDuration = existingThiefEffect.m_19557_() / 20;
            durationSeconds = Math.min(ThiefEffect.getBaseDurationSeconds() * 4, durationSeconds + existingDuration);
        }
        offender.m_21195_((MobEffect)Registry.Effects.THIEF.get());
        MobEffectInstance thiefEffectInstance = ThiefEffect.createInstance(Duration.ofSeconds(durationSeconds), amplifier);
        offender.m_7292_(thiefEffectInstance);
        if (offender instanceof Player) {
            Player player = (Player)offender;
            player.m_5661_((Component)TextUtil.translate("message.thief.you_were_seen", new Object[0]), true);
        }
        for (LivingEntity witness : witnesses) {
            Villager villager;
            if (!(witness instanceof Villager) || !((villager = (Villager)witness).m_20270_((Entity)offender) <= 16.0f)) continue;
            if (villager.m_5803_()) {
                villager.m_5796_();
            }
            villager.m_35518_();
        }
    }

    public static enum Offence {
        LIGHT(0, 0.5f),
        MODERATE(1, 1.0f),
        HEAVY(2, 2.0f);

        private final int amplifier;
        private final float modifier;

        private Offence(int amplifier, float modifier) {
            this.amplifier = amplifier;
            this.modifier = modifier;
        }

        public int getAmplifier() {
            return this.amplifier;
        }

        public float getModifier() {
            return this.modifier;
        }
    }
}

