/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterstructure_common_forge.events;

import com.natamus.collective_common_forge.functions.PlayerFunctions;
import com.natamus.starterstructure_common_forge.config.ConfigHandler;
import com.natamus.starterstructure_common_forge.util.Util;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class StructureSpawnPointEvents {
    public static void onPlayerRespawn(ServerPlayer oldPlayer, ServerPlayer serverPlayer, boolean alive) {
        if (ConfigHandler.forceExactSpawn) {
            Optional optionalbed;
            ServerLevel serverLevel = (ServerLevel)serverPlayer.m_9236_();
            BlockPos respawnlocation = serverLevel.m_220360_();
            Vec3 respawnvec = new Vec3((double)respawnlocation.m_123341_() + 0.5, (double)respawnlocation.m_123342_(), (double)respawnlocation.m_123343_() + 0.5);
            BlockPos bedpos = serverPlayer.m_8961_();
            if (bedpos != null && (optionalbed = Player.m_36130_((ServerLevel)serverLevel, (BlockPos)bedpos, (float)1.0f, (boolean)false, (boolean)false)).isPresent()) {
                return;
            }
            serverPlayer.m_6021_(respawnvec.f_82479_, respawnvec.f_82480_, respawnvec.f_82481_);
        }
    }

    public static void onEntityJoin(Level level, Entity entity) {
        if (level.f_46443_) {
            return;
        }
        Util.processEntityMovementOnJoin(entity);
        if (!ConfigHandler.forceExactSpawn) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!PlayerFunctions.isJoiningWorldForTheFirstTime((Player)player, (String)"starterstructure", (boolean)false)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos ppos = player.m_20183_();
        BlockPos wspos = serverLevel.m_220360_();
        if (new BlockPos(ppos.m_123341_(), wspos.m_123342_(), ppos.m_123343_()).m_123314_((Vec3i)wspos, 50.0)) {
            player.m_6021_((double)wspos.m_123341_() + 0.5, (double)wspos.m_123342_(), (double)wspos.m_123343_() + 0.5);
        }
    }
}

