/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterstructure_common_forge.events;

import com.natamus.collective_common_forge.functions.FeatureFunctions;
import com.natamus.collective_common_forge.functions.TaskFunctions;
import com.natamus.starterstructure_common_forge.config.ConfigHandler;
import com.natamus.starterstructure_common_forge.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.ServerLevelData;

public class StructureCreationEvents {
    public static InteractionResult onLevelSpawn(ServerLevel serverLevel, ServerLevelData serverLevelData) {
        TaskFunctions.enqueueCollectiveTask((MinecraftServer)serverLevel.m_7654_(), () -> {
            if (ConfigHandler.shouldGenerateStructure) {
                BlockPos spawnPos = null;
                BlockPos structurePos = Util.generateSchematic(serverLevel);
                if (structurePos != null) {
                    spawnPos = structurePos.m_7949_();
                    if (ConfigHandler.shouldUseSpawnCoordOffsets) {
                        spawnPos = spawnPos.m_7918_(ConfigHandler.spawnXCoordOffset, ConfigHandler.spawnYCoordOffset, ConfigHandler.spawnZCoordOffset).m_7949_();
                    }
                    serverLevel.m_8733_(spawnPos, 1.0f);
                }
                if (spawnPos != null) {
                    try {
                        WorldOptions worldOptions = serverLevel.m_7654_().m_129910_().m_246337_();
                        if (worldOptions.m_245100_()) {
                            FeatureFunctions.placeBonusChest((Level)serverLevel, (BlockPos)spawnPos);
                        }
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                }
            }
        }, (int)1);
        if (ConfigHandler.shouldUseSpawnCoordinates || ConfigHandler.shouldUseSpawnCoordOffsets || ConfigHandler.shouldUseStructureOffset) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static void onLevelLoad(ServerLevel serverLevel) {
        Util.readProtectedList(serverLevel);
    }
}

