/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core;

import com.mojang.blaze3d.platform.Lighting;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidColors;
import net.mehvahdjukaar.moonlight.api.map.client.MapDecorationClientManager;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcePack;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.core.ClientConfigs;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Vector3f;

@ApiStatus.Internal
public class MoonlightClient {
    private static final ThreadLocal<Boolean> MAP_MIPMAP = ThreadLocal.withInitial(() -> false);
    private static MergedDynamicTexturePack mergedDynamicPack;

    public static void initClient() {
        ClientHelper.addClientReloadListener(SoftFluidColors::new, Moonlight.res("soft_fluids"));
        ClientHelper.addClientReloadListener(MapDecorationClientManager::new, Moonlight.res("map_markers"));
        ClientConfigs.init();
        Gen gen = new Gen();
        gen.register();
    }

    public static DynamicTexturePack maybeMergePack(DynamicTexturePack pack) {
        if (!ClientConfigs.MERGE_PACKS.get().booleanValue()) {
            return pack;
        }
        if (mergedDynamicPack == null) {
            mergedDynamicPack = new MergedDynamicTexturePack(){};
        }
        Set<String> nameSpaces = pack.m_5698_(pack.getPackType());
        for (String n : nameSpaces) {
            mergedDynamicPack.addNamespaces(n);
        }
        ++MoonlightClient.mergedDynamicPack.mods;
        return mergedDynamicPack;
    }

    public static void afterTextureReload() {
        DynamicResourcePack.clearAfterReload(PackType.CLIENT_RESOURCES);
    }

    public static void setMipMap(boolean b) {
        if (ClientConfigs.MAPS_MIPMAP.get() == 0) {
            b = false;
        }
        MAP_MIPMAP.set(b);
    }

    public static boolean isMapMipMap() {
        return MAP_MIPMAP.get();
    }

    private static class Gen
    extends DynClientResourcesGenerator {
        private Vector3f oldL0 = null;
        private Vector3f oldL1 = null;
        private Vector3f oldL0n = null;
        private Vector3f oldL1n = null;

        public Gen() {
            super(new DynamicTexturePack(Moonlight.res("generated_pack")));
            ((DynamicTexturePack)this.dynamicPack).addNamespaces("minecraft");
        }

        @Override
        public Logger getLogger() {
            return Moonlight.LOGGER;
        }

        @Override
        public boolean dependsOnLoadedPacks() {
            return true;
        }

        @Override
        public void regenerateDynamicAssets(ResourceManager manager) {
            if (ClientConfigs.FIX_SHADE.get().booleanValue()) {
                if (this.oldL0 == null) {
                    this.oldL0 = Lighting.f_84919_;
                    this.oldL1 = Lighting.f_84920_;
                    this.oldL0n = Lighting.f_84921_;
                    this.oldL1n = Lighting.f_84922_;
                }
                float x = 0.2f;
                float y = 0.7777778f;
                float z = -0.6f;
                Lighting.f_84919_ = new Vector3f(x, y, z).normalize();
                Lighting.f_84920_ = new Vector3f(-x, y, -z).normalize();
                Lighting.f_84921_ = Lighting.f_84919_;
                Lighting.f_84922_ = Lighting.f_84920_;
                ((DynamicTexturePack)this.dynamicPack).addBytes(new ResourceLocation("shaders/include/light.glsl"), "#version 150\n\n#define MINECRAFT_LIGHT_POWER   (0.5)\n#define MINECRAFT_AMBIENT_LIGHT (0.5)\n\nvec4 minecraft_mix_light(vec3 lightDir0, vec3 lightDir1, vec3 normal, vec4 color) {\n    lightDir0 = normalize(lightDir0);\n    lightDir1 = normalize(lightDir1);\n    float light0 = max(0.0, dot(lightDir0, normal));\n    float light1 = max(0.0, dot(lightDir1, normal));\n    float lightAccum = min(1.0, (light0 + light1) * MINECRAFT_LIGHT_POWER + MINECRAFT_AMBIENT_LIGHT);\n    return vec4(color.rgb * lightAccum, color.a);\n}\n\nvec4 minecraft_sample_lightmap(sampler2D lightMap, ivec2 uv) {\n    return texture(lightMap, clamp(uv / 256.0, vec2(0.5 / 16.0), vec2(15.5 / 16.0)));\n}".getBytes(), ResType.GENERIC);
            } else if (this.oldL0 != null) {
                Lighting.f_84919_ = this.oldL0;
                Lighting.f_84920_ = this.oldL1;
                Lighting.f_84921_ = this.oldL0n;
                Lighting.f_84922_ = this.oldL1n;
                this.oldL0 = null;
                this.oldL1 = null;
                this.oldL0n = null;
                this.oldL1n = null;
            }
        }
    }

    private static class MergedDynamicTexturePack
    extends DynamicTexturePack {
        int mods = 0;

        public MergedDynamicTexturePack() {
            super(Moonlight.res("mods_dynamic_assets"));
        }

        @Override
        public Component makeDescription() {
            return Component.m_237113_((String)("Dynamic resources for " + this.mods + (this.mods == 1 ? " mod" : " mods")));
        }
    }
}

