/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.weaponpassive;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.gameasset.WOMSkills;
import reascer.wom.skill.WOMSkillDataKeys;
import reascer.wom.skill.weaponinnate.TrueBerserkSkill;
import reascer.wom.world.capabilities.item.WOMWeaponCategories;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class TormentPassiveSkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("72eabb8f-f889-4302-80bb-690bb557a008");

    public TormentPassiveSkill(Skill.Builder<?> builder) {
        super(builder.setActivateType(Skill.ActivateType.DURATION_INFINITE));
    }

    public void onInitiate(SkillContainer container) {
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID, event -> {
            if (((LocalPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND).getWeaponCategory() == WOMWeaponCategories.TORMENT && container.getExecuter().getEntityState().canBasicAttack() && container.getExecuter().getStamina() > 0.0f) {
                ((LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
                ((Player)container.getExecuter().getOriginal()).m_6858_(false);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID, event -> {
            if (((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND).getWeaponCategory() == WOMWeaponCategories.TORMENT && container.getExecuter().getEntityState().canBasicAttack() && container.getExecuter().getStamina() > 0.0f) {
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGING.get(), (Object)true, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                ((Player)container.getExecuter().getOriginal()).m_6858_(false);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGED_ATTACK.get())).booleanValue() || ((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGED_ATTACK.get())).booleanValue()) {
                event.setDamage(event.getDamage() * 3.0f);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, EVENT_UUID, event -> {
            ServerPlayerPatch entitypatch = (ServerPlayerPatch)event.getPlayerPatch();
            AttackAnimation anim = (AttackAnimation)event.getDamageSource().getAnimation();
            AnimationPlayer player = entitypatch.getAnimator().getPlayerFor((DynamicAnimation)event.getDamageSource().getAnimation());
            float elapsedTime = player.getElapsedTime();
            AttackAnimation.Phase phase = anim.getPhaseByTime(elapsedTime);
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGED_ATTACK.get())).booleanValue() && phase == anim.phases[0]) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGED_ATTACK.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                ((ServerLevel)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, event.getTarget().m_20185_() - 0.15, event.getTarget().m_20186_() + 1.2, event.getTarget().m_20189_() - 0.15, 25, 0.0, 0.0, 0.0, 0.2);
                ((ServerLevel)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123756_, event.getTarget().m_20185_() - 0.15, event.getTarget().m_20186_() + 1.2, event.getTarget().m_20189_() - 0.15, 25, 0.0, 0.0, 0.0, 1.0);
            } else {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGED_ATTACK.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGED_ATTACK.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SUPER_ARMOR.get())).booleanValue() || ((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING.get())).booleanValue()) {
                event.setAmount(event.getAmount() * 0.8f);
                ((EpicFightDamageSource)event.getDamageSource()).setStunType(StunType.NONE);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            if (event.getAnimation().equals((Object)WOMAnimations.SHADOWSTEP_BACKWARD) || event.getAnimation().equals((Object)WOMAnimations.SHADOWSTEP_FORWARD)) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.MOVESPEED.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
            if (event.getAnimation().equals((Object)WOMAnimations.TORMENT_AUTO_1) || event.getAnimation().equals((Object)WOMAnimations.TORMENT_AUTO_2) || event.getAnimation().equals((Object)WOMAnimations.TORMENT_AUTO_3) || !event.getAnimation().equals((Object)WOMAnimations.TORMENT_AUTO_4)) {
                // empty if block
            }
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGED_ATTACK.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGED_ATTACK.get())).booleanValue()) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGED_ATTACK.get(), (Object)true, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGING.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SAVED_CHARGE.get()) < 20) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SAVED_CHARGE.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get())), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get(), (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID, event -> {
            if (event.getAnimation().equals((Object)WOMAnimations.TORMENT_AUTO_1) || event.getAnimation().equals((Object)WOMAnimations.TORMENT_AUTO_2) || event.getAnimation().equals((Object)WOMAnimations.TORMENT_AUTO_3) || !event.getAnimation().equals((Object)WOMAnimations.TORMENT_AUTO_4)) {
                // empty if block
            }
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGED_ATTACK.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGED_ATTACK.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
        });
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        if (container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getSkill() instanceof TrueBerserkSkill) {
            return ((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING.get()) != false || (Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGED_ATTACK.get()) != false || (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SAVED_CHARGE.get()) > 0) && (Boolean)container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.ACTIVE.get()) == false;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)WOMSkills.TRUE_BERSERK.getSkillTexture());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280411_(WOMSkills.TRUE_BERSERK.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        int charge = 0;
        charge = (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SAVED_CHARGE.get()) > 0 ? ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SAVED_CHARGE.get()) + 10) / 30 : ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get()) + 10) / 30;
        if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGED_ATTACK.get())).booleanValue()) {
            guiGraphics.drawString(gui.font, String.valueOf(charge), x + 10.0f, y + 4.0f, 0xFFFFFF, true);
            guiGraphics.drawString(gui.font, "x3", x + 7.0f, y + 13.0f, 0xFFFFFF, true);
        } else {
            guiGraphics.drawString(gui.font, String.valueOf(charge), x + 10.0f, y + 6.0f, 0xFFFFFF, true);
        }
        poseStack.m_85849_();
    }

    public void updateContainer(SkillContainer container) {
        if (!container.getExecuter().isLogicalClient()) {
            AttributeModifier charging_Movementspeed = new AttributeModifier(EVENT_UUID, "torment.charging_movespeed", 3.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
            ServerPlayerPatch executer = (ServerPlayerPatch)container.getExecuter();
            int sweeping_edge = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)executer.getOriginal()));
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING.get())).booleanValue() && !((Player)container.getExecuter().getOriginal()).m_6117_() && container.getExecuter().getEntityState().canBasicAttack()) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.MOVESPEED.get(), (Object)true, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                int animation_timer = (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get());
                if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get()) < 20 && (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SAVED_CHARGE.get()) >= 20) {
                    animation_timer = (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.SAVED_CHARGE.get());
                }
                if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get()) >= 110) {
                    ((Player)container.getExecuter().getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19596_, 4, 2, true, false, false));
                    ((Player)container.getExecuter().getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), (SoundEvent)EpicFightSounds.WHOOSH_BIG.get(), SoundSource.PLAYERS, 1.0f, 1.2f);
                    if (!((Player)container.getExecuter().getOriginal()).m_7500_() && !container.getExecuter().consumeStamina(3.0f)) {
                        container.getExecuter().setStamina(0.0f);
                    }
                } else if (animation_timer >= 80) {
                    container.getExecuter().playAnimationSynchronized(WOMAnimations.TORMENT_CHARGED_ATTACK_3, 0.0f);
                } else if (animation_timer >= 50) {
                    container.getExecuter().playAnimationSynchronized(WOMAnimations.TORMENT_CHARGED_ATTACK_2, 0.0f);
                } else if (animation_timer >= 20) {
                    container.getExecuter().playAnimationSynchronized(WOMAnimations.TORMENT_CHARGED_ATTACK_1, 0.0f);
                } else if (!((Boolean)container.getExecuter().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.ACTIVE.get())).booleanValue()) {
                    ((Player)container.getExecuter().getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19596_, 4, 1, true, false, false));
                    ((Player)container.getExecuter().getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), (SoundEvent)EpicFightSounds.WHOOSH_BIG.get(), SoundSource.PLAYERS, 1.0f, 1.2f);
                    if (!((Player)container.getExecuter().getOriginal()).m_7500_() && !container.getExecuter().consumeStamina(3.0f)) {
                        container.getExecuter().setStamina(0.0f);
                    }
                } else {
                    ((Player)container.getExecuter().getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19596_, 7, 3, true, false, false));
                    ((Player)container.getExecuter().getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), (SoundEvent)EpicFightSounds.WHOOSH_BIG.get(), SoundSource.PLAYERS, 1.0f, 1.2f);
                    float stamina = container.getExecuter().getStamina();
                    float maxStamina = container.getExecuter().getMaxStamina();
                    float staminaRegen = (float)((Player)container.getExecuter().getOriginal()).m_21133_((Attribute)EpicFightAttributes.STAMINA_REGEN.get());
                    int regenStandbyTime = 900 / (int)(30.0f * staminaRegen);
                    if (container.getExecuter().getTickSinceLastAction() > regenStandbyTime) {
                        if (!((Player)container.getExecuter().getOriginal()).m_7500_()) {
                            float staminaFactor = 1.0f + (float)Math.pow(stamina / (maxStamina - stamina * 0.5f), 2.0);
                            if (!container.getExecuter().consumeStamina(2.0f + maxStamina * 0.05f * staminaFactor * staminaRegen)) {
                                container.getExecuter().setStamina(0.0f);
                            }
                        }
                    } else if (!((Player)container.getExecuter().getOriginal()).m_7500_() && !container.getExecuter().consumeStamina(2.0f)) {
                        container.getExecuter().setStamina(0.0f);
                    }
                }
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGING.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get(), (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SAVED_CHARGE.get(), (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                ((Player)container.getExecuter().getOriginal()).m_21051_(Attributes.f_22279_).m_22130_(charging_Movementspeed);
            }
            if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING.get())).booleanValue()) {
                ((Player)container.getExecuter().getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 5, 0, true, false, false));
                if (((Player)container.getExecuter().getOriginal()).m_21051_(Attributes.f_22279_).m_22111_(EVENT_UUID) == null && ((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.MOVESPEED.get())).booleanValue()) {
                    ((Player)container.getExecuter().getOriginal()).m_21051_(Attributes.f_22279_).m_22125_(charging_Movementspeed);
                }
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get()) + 1), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get()) <= 130) {
                    if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get()) == 20) {
                        container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.SAVED_CHARGE.get(), (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                        ((Player)container.getExecuter().getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), SoundEvents.f_11668_, SoundSource.PLAYERS, 1.0f, 0.6f);
                        this.consume_stamina(container);
                    }
                    if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get()) == 50) {
                        ((Player)container.getExecuter().getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), SoundEvents.f_11668_, SoundSource.PLAYERS, 1.0f, 0.65f);
                        this.consume_stamina(container);
                    }
                    if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get()) == 80) {
                        ((Player)container.getExecuter().getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), SoundEvents.f_11668_, SoundSource.PLAYERS, 1.0f, 0.7f);
                        this.consume_stamina(container);
                    }
                    if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get()) == 110) {
                        container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGED_ATTACK.get(), (Object)true, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                        ((Player)container.getExecuter().getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), SoundEvents.f_11668_, SoundSource.PLAYERS, 1.0f, 0.5f);
                        ((Player)container.getExecuter().getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), SoundEvents.f_11699_, SoundSource.MASTER, 2.5f, 0.5f);
                        this.consume_stamina(container);
                    }
                    if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get()) == 130) {
                        container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.CHARGING_TIME.get(), (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                        ((Player)container.getExecuter().getOriginal()).m_21051_(Attributes.f_22279_).m_22130_(charging_Movementspeed);
                    }
                }
            } else {
                ((Player)container.getExecuter().getOriginal()).m_21051_(Attributes.f_22279_).m_22130_(charging_Movementspeed);
            }
        }
    }

    public void consume_stamina(SkillContainer container) {
        if (!((Player)container.getExecuter().getOriginal()).m_7500_()) {
            if (container.getExecuter().getStamina() <= 0.0f) {
                ((Player)container.getExecuter().getOriginal()).m_5810_();
            }
            if (!container.getExecuter().consumeStamina(3.0f)) {
                container.getExecuter().setStamina(0.0f);
                ((Player)container.getExecuter().getOriginal()).m_9236_().m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), SoundEvents.f_12031_, ((Player)container.getExecuter().getOriginal()).m_5720_(), 1.0f, 2.0f);
            }
        }
    }
}

