/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.passive;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.skill.WOMSkillDataKeys;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class HeartShieldSkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("42580b91-53a6-4d7f-92b4-487aa585cd0b");
    private float recovery_delay;
    private float recovery_rate;

    public HeartShieldSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        this.recovery_delay = 5.0f;
        this.recovery_rate = 2.0f;
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)100, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal()));
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        ((Player)container.getExecuter().getOriginal()).m_7911_(0.0f);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return (Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 0 || ((Player)container.getExecuter().getOriginal()).m_6103_() < (float)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.MAX_SHIELD.get())).intValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 0) {
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        guiGraphics.m_280411_(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 0) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.drawString(gui.font, String.valueOf((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) / 20 + 1), x + 9.0f, y + 10.0f, 0xFFFFFF, true);
        }
        poseStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(String.format("%.1f", Float.valueOf(this.recovery_delay)));
        list.add(String.format("%.1f", Float.valueOf(this.recovery_rate)));
        return list;
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        int protection = 0;
        for (ItemStack ArmorPiece : ((Player)container.getExecuter().getOriginal()).m_6168_()) {
            protection += ArmorPiece.getEnchantmentLevel(Enchantments.f_44965_);
        }
        this.recovery_rate = (float)(40 / (1 + protection / 4)) / 20.0f;
        if (!container.getExecuter().isLogicalClient()) {
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.MAX_SHIELD.get(), (Object)20, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) > 0) {
                container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.COOLDOWN.get()) - 1), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            } else if (((Player)container.getExecuter().getOriginal()).m_6103_() < (float)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.MAX_SHIELD.get())).intValue()) {
                if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.RECOVERY_RATE.get()) > 0) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.RECOVERY_RATE.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.RECOVERY_RATE.get()) - 1), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                } else {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.RECOVERY_RATE.get(), (Object)(40 / (1 + protection / 4)), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                    if (((Player)container.getExecuter().getOriginal()).m_6103_() + 1.0f >= (float)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.MAX_SHIELD.get())).intValue()) {
                        ((Player)container.getExecuter().getOriginal()).m_7911_((float)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.MAX_SHIELD.get())).intValue());
                    } else {
                        ((Player)container.getExecuter().getOriginal()).m_7911_(((Player)container.getExecuter().getOriginal()).m_6103_() + 1.0f);
                    }
                }
            }
        }
    }
}

