/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.dodges;

import io.netty.buffer.Unpooled;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.skill.WOMSkillDataKeys;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.client.events.engine.ControllEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.network.client.CPExecuteSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.dodge.DodgeSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.DodgeSuccessEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class DodgeMasterSkill
extends DodgeSkill {
    private static final UUID EVENT_UUID = UUID.fromString("691d9d1e-05ce-11ed-b939-0242ac120002");

    public DodgeMasterSkill(DodgeSkill.Builder builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) > 4) {
                if (!((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.DODGE.get())).booleanValue()) {
                    ((ServerPlayerPatch)event.getPlayerPatch()).getEventListener().triggerEvents(PlayerEventListener.EventType.DODGE_SUCCESS_EVENT, (PlayerEvent)new DodgeSuccessEvent((ServerPlayerPatch)event.getPlayerPatch(), (DamageSource)event.getDamageSource()));
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.DODGE.get(), (Object)true, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                }
                event.setCanceled(true);
                event.setResult(AttackResult.ResultType.MISSED);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, EVENT_UUID, event -> {
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.DODGE.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)0, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
        });
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public FriendlyByteBuf gatherArguments(LocalPlayerPatch executer, ControllEngine controllEngine) {
        int forward = controllEngine.isKeyDown(Minecraft.m_91087_().f_91066_.f_92085_) ? 1 : 0;
        int backward = controllEngine.isKeyDown(Minecraft.m_91087_().f_91066_.f_92087_) ? -1 : 0;
        int left = controllEngine.isKeyDown(Minecraft.m_91087_().f_91066_.f_92086_) ? 1 : 0;
        int right = controllEngine.isKeyDown(Minecraft.m_91087_().f_91066_.f_92088_) ? -1 : 0;
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(forward);
        buf.writeInt(backward);
        buf.writeInt(left);
        buf.writeInt(right);
        return buf;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object getExecutionPacket(LocalPlayerPatch executer, FriendlyByteBuf args) {
        int degree;
        int forward = args.readInt();
        int backward = args.readInt();
        int left = args.readInt();
        int right = args.readInt();
        int vertic = forward + backward;
        int horizon = left + right;
        int n = degree = vertic == 0 ? 0 : -(90 * horizon * (1 - Math.abs(vertic)) + 45 * vertic * horizon);
        int animation = vertic == 0 ? (horizon == 0 ? 1 : (horizon >= 0 ? 2 : 3)) : (vertic >= 0 ? 0 : 1);
        CPExecuteSkill packet = new CPExecuteSkill(executer.getSkill((Skill)this).getSlotId());
        packet.getBuffer().writeInt(animation);
        packet.getBuffer().writeFloat((float)degree);
        return packet;
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        int i = args.readInt();
        float yaw = args.readFloat();
        if ((Integer)executer.getSkill((Skill)this).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) > 0 && !((Boolean)executer.getSkill((Skill)this).getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.DODGE.get())).booleanValue()) {
            executer.playAnimationSynchronized(this.animations[i], 0.0f);
            executer.changeModelYRot(yaw);
            if (!executer.consumeStamina(this.getConsumption() * 3.0f)) {
                executer.setStamina(0.0f);
            }
        }
        executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)14, (ServerPlayer)executer.getOriginal());
        executer.getSkill((Skill)this).getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.DODGE.get(), (Object)false, (ServerPlayer)executer.getOriginal());
    }

    public Skill getPriorSkill() {
        return EpicFightSkills.STEP;
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        EntityState playerState = executer.getEntityState();
        if (!(executer.isUnstable() || !playerState.canUseSkill() || ((Player)executer.getOriginal()).m_20069_() || ((Player)executer.getOriginal()).m_6147_() || executer.getStamina() < 8.0f)) {
            ((Player)executer.getOriginal()).m_5496_(SoundEvents.f_11705_, 0.3f, 2.0f);
            return true;
        }
        ((Player)executer.getOriginal()).m_5496_(SoundEvents.f_12031_, 1.0f, 2.0f);
        return false;
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) > 0 && !container.getExecuter().isLogicalClient()) {
            container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) - 1), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            if (((ServerPlayerPatch)container.getExecuter()).getStamina() > 0.0f) {
                if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) < 14 && ((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.DODGE.get())).booleanValue()) {
                    container.getExecuter().playAnimationSynchronized(this.animations[Math.abs(new Random().nextInt()) % 2 + 2], 0.0f);
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.TIMER.get(), (Object)14, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                    if (!container.getExecuter().consumeStamina(this.getConsumption() + 1.0f)) {
                        container.getExecuter().setStamina(0.0f);
                    }
                }
                if ((Integer)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.TIMER.get()) > 5 && ((Boolean)container.getDataManager().getDataValue((SkillDataKey)WOMSkillDataKeys.DODGE.get())).booleanValue()) {
                    container.getDataManager().setDataSync((SkillDataKey)WOMSkillDataKeys.DODGE.get(), (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                }
            }
        }
    }
}

