/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.events;

import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.gameasset.WOMEnchantment;
import reascer.wom.particle.WOMParticles;
import reascer.wom.wold.gamerules.WOMGamerules;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageType;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.eventlistener.DealtDamageEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.item.EpicFightItems;

@Mod.EventBusSubscriber(modid="wom", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WOMLivingEntityEvents {
    private static final Map<EquipmentSlot, UUID> STAMINAR_ADD = WOMLivingEntityEvents.makeUUIDMap("wom_staminar_add");

    private static Map<EquipmentSlot, UUID> makeUUIDMap(String key) {
        EnumMap<EquipmentSlot, UUID> map = new EnumMap<EquipmentSlot, UUID>(EquipmentSlot.class);
        for (EquipmentSlot type : EquipmentSlot.values()) {
            map.put(type, UUID.nameUUIDFromBytes((key + type.m_20751_()).getBytes()));
        }
        return map;
    }

    @SubscribeEvent
    public static void onSpawnEvent(MobSpawnEvent event) {
        EntityPatch entitypatch = EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), EntityPatch.class);
        if (entitypatch != null && entitypatch.isInitialized() && !event.getEntity().m_19880_().contains("wom-bow-replaced")) {
            if (event.getEntity() instanceof Skeleton && event.getEntity().m_21205_().m_41720_() == Items.f_42411_ && !event.getEntity().m_19880_().contains("wom-bow-replaced")) {
                ItemStack weapon = Items.f_42411_.m_7968_();
                boolean no_change = true;
                if (Math.abs(new Random().nextInt()) % 100 < event.getEntity().m_9236_().m_46469_().m_46215_(WOMGamerules.SKELETON_MELEE_PERCENTAGE)) {
                    no_change = false;
                    switch (Math.abs(new Random().nextInt()) % 4) {
                        case 0: {
                            weapon = Items.f_42425_.m_7968_();
                            break;
                        }
                        case 1: {
                            weapon = Items.f_42428_.m_7968_();
                            break;
                        }
                        case 2: {
                            weapon = ((Item)EpicFightItems.STONE_SPEAR.get()).m_7968_();
                            break;
                        }
                        case 3: {
                            weapon = ((Item)EpicFightItems.STONE_GREATSWORD.get()).m_7968_();
                        }
                    }
                }
                if (!no_change) {
                    event.getEntity().m_21008_(InteractionHand.MAIN_HAND, weapon);
                }
                event.getEntity().m_20049_("wom-bow-replaced");
            }
            float distance_from_zero = (float)Math.sqrt(Math.pow(event.getX(), 2.0) + Math.pow(event.getZ(), 2.0));
            int block_distance = 1000;
            double health_multiplier = 1.1;
            double damage_multiplier = 1.09;
            if (distance_from_zero / (float)block_distance > 1.0f && !event.getEntity().m_19880_().contains("wom-stronger-mob") && event.getEntity().m_9236_().m_46469_().m_46207_(WOMGamerules.SPAWN_STONGER_MOB_OVER_DISTANCE)) {
                AttributeInstance entity_max_health = event.getEntity().m_21051_(Attributes.f_22276_);
                AttributeModifier boosted_health = new AttributeModifier(UUID.fromString("5a70f02c-7ca0-43c5-a766-2be3d68461a2"), "wom.wom_stronger_health", (double)Math.round(Math.pow(health_multiplier, distance_from_zero / (float)block_distance) - 1.0), AttributeModifier.Operation.MULTIPLY_TOTAL);
                if (entity_max_health != null) {
                    entity_max_health.m_22130_(boosted_health);
                    entity_max_health.m_22125_(boosted_health);
                }
                AttributeInstance entity_attack_damage = event.getEntity().m_21051_(Attributes.f_22281_);
                AttributeModifier boosted_damage = new AttributeModifier(UUID.fromString("5a70f02c-7ca0-43c5-a766-2be3d68461a2"), "wom.wom_stronger_damage", (double)Math.round(Math.pow(damage_multiplier, distance_from_zero / (float)block_distance) - 1.0), AttributeModifier.Operation.MULTIPLY_TOTAL);
                if (entity_attack_damage != null) {
                    entity_attack_damage.m_22130_(boosted_damage);
                    entity_attack_damage.m_22125_(boosted_damage);
                }
                event.getEntity().m_5634_(event.getEntity().m_21233_());
                event.getEntity().m_20049_("wom-stronger-mob");
            }
        }
    }

    @SubscribeEvent
    public static void onkillEvent(LivingDeathEvent event) {
        block3: {
            Iterator iterator;
            if (!(event.getEntity() instanceof Player) && !(event.getEntity() instanceof Animal) && !(event.getEntity() instanceof Npc) && event.getEntity().m_9236_().m_46469_().m_46207_(WOMGamerules.STONGER_MOB_DROP_EMERALDS)) {
                int i = 1;
                while ((float)i < event.getEntity().m_21233_() / 20.0f) {
                    if (Math.abs(new Random().nextInt()) % 5 == 0) {
                        double d0 = EntityType.f_20461_.m_20678_();
                        double d1 = 1.0 - d0;
                        double d2 = d0 / 2.0;
                        double d3 = Math.floor(event.getEntity().m_20185_()) + new Random().nextDouble() * d1 + d2;
                        double d4 = Math.floor(event.getEntity().m_20186_()) + new Random().nextDouble() * d1;
                        double d5 = Math.floor(event.getEntity().m_20189_()) + new Random().nextDouble() * d1 + d2;
                        ItemStack itemStack = Items.f_42616_.m_7968_();
                        ItemEntity itementity = new ItemEntity(event.getEntity().m_9236_(), d3, d4, d5, itemStack);
                        itementity.m_32060_();
                        itementity.m_20334_(new Random().nextGaussian() * (double)0.05f, new Random().nextGaussian() * (double)0.05f + (double)0.2f, new Random().nextGaussian() * (double)0.05f);
                        event.getEntity().m_9236_().m_7967_((Entity)itementity);
                    }
                    ++i;
                }
            }
            if (!(iterator = event.getEntity().m_19880_().iterator()).hasNext()) break block3;
            String tag = (String)iterator.next();
            event.getEntity().m_20137_(tag);
        }
    }

    @SubscribeEvent
    public static void onDropedExpPoint(LivingExperienceDropEvent event) {
        if (!(event.getEntity() instanceof Player) && event.getEntity().m_9236_().m_46469_().m_46207_(WOMGamerules.STONGER_MOB_GIVE_MORE_EXP)) {
            event.setDroppedExperience((int)((float)event.getDroppedExperience() * (event.getEntity().m_21233_() / 20.0f)));
        }
    }

    @SubscribeEvent
    public static void itemAttributeModifiers(ItemAttributeModifierEvent event) {
        float invigoration = 0.0f;
        ItemStack stack = event.getItemStack();
        EquipmentSlot slot = event.getSlotType();
        if (slot == LivingEntity.m_147233_((ItemStack)stack)) {
            invigoration += (float)stack.getEnchantmentLevel((Enchantment)WOMEnchantment.INVIGORATION.get());
        }
        if (invigoration != 0.0f) {
            event.addModifier((Attribute)EpicFightAttributes.MAX_STAMINA.get(), new AttributeModifier(STAMINAR_ADD.get(slot), "invigoration_stamina_add", (double)(invigoration * 2.0f), AttributeModifier.Operation.ADDITION));
        }
    }

    @SubscribeEvent
    public static void onUpdateEvent(LivingEvent.LivingTickEvent event) {
        Entity player;
        LivingEntity e = event.getEntity();
        if (e instanceof Player) {
            for (String tag : event.getEntity().m_19880_()) {
                if (!tag.contains("wom_health_fix:")) continue;
                if (!(Float.valueOf(tag.substring(15)).floatValue() <= event.getEntity().m_21233_())) break;
                event.getEntity().m_21153_(Float.valueOf(tag.substring(15)).floatValue());
                event.getEntity().m_19880_().remove(tag);
                break;
            }
            if (event.getEntity().m_21223_() > event.getEntity().m_21233_()) {
                event.getEntity().m_21153_(event.getEntity().m_21233_());
            }
        }
        for (String tag : event.getEntity().m_19880_()) {
            if (!tag.contains("anti_stunlock:") || !((float)e.f_19797_ - Float.valueOf(tag.split(":")[2]).floatValue() > 40.0f)) continue;
            e.m_20137_(tag);
            break;
        }
        for (String tag : event.getEntity().m_19880_()) {
            String replacetag;
            if (!tag.contains("timed_katana_slashes:") || e == null || !e.m_6084_()) continue;
            if (Integer.valueOf(tag.split(":")[1]) > 0) {
                replacetag = new String(tag);
                e.m_20137_(tag);
                e.m_20049_("timed_katana_slashes:" + (Integer.valueOf(replacetag.split(":")[1]) - 1) + ":" + Integer.valueOf(replacetag.split(":")[2]) + ":" + Integer.valueOf(replacetag.split(":")[3]) + ":" + Integer.valueOf(replacetag.split(":")[4]) + ":" + Float.valueOf(replacetag.split(":")[5]) + ":" + Integer.valueOf(replacetag.split(":")[6]) + ":" + Integer.valueOf(replacetag.split(":")[7]));
                break;
            }
            if (Integer.valueOf(tag.split(":")[2]) > 0) {
                replacetag = new String(tag);
                e.m_20137_(tag);
                e.m_20049_("timed_katana_slashes:" + Integer.valueOf(replacetag.split(":")[1]) + ":" + (Integer.valueOf(replacetag.split(":")[2]) - 1) + ":" + Integer.valueOf(replacetag.split(":")[3]) + ":" + Integer.valueOf(replacetag.split(":")[4]) + ":" + Float.valueOf(replacetag.split(":")[5]) + ":" + Integer.valueOf(replacetag.split(":")[6]) + ":" + Integer.valueOf(replacetag.split(":")[7]));
                break;
            }
            if (Integer.valueOf(tag.split(":")[3]) > 0) {
                replacetag = new String(tag);
                e.m_20137_(tag);
                player = (ServerPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)e.m_9236_().m_6815_(Integer.valueOf(replacetag.split(":")[6]).intValue()), ServerPlayerPatch.class);
                EpicFightDamageSource epicFightDamageSource = player.getDamageSource(WOMAnimations.KATANA_SAKURA_TIMED_SLASH, InteractionHand.MAIN_HAND);
                epicFightDamageSource.setImpact(2.0f);
                epicFightDamageSource.setStunType(StunType.HOLD);
                epicFightDamageSource.addRuntimeTag(EpicFightDamageType.WEAPON_INNATE);
                EpicFightDamageSource damage = epicFightDamageSource;
                e.f_19802_ = 0;
                if (e.m_6469_((DamageSource)damage, Math.max(1.0f, Float.valueOf(replacetag.split(":")[5]).floatValue() * 0.25f))) {
                    player.getEventListener().triggerEvents(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, (PlayerEvent)new DealtDamageEvent((ServerPlayerPatch)player, e, epicFightDamageSource, Math.max(1.0f, Float.valueOf(replacetag.split(":")[5]).floatValue() * 0.25f)));
                    ((ServerLevel)event.getEntity().m_9236_()).m_6263_(null, event.getEntity().m_20185_(), event.getEntity().m_20186_() + 0.75, event.getEntity().m_20189_(), (SoundEvent)EpicFightSounds.BLADE_HIT.get(), event.getEntity().m_5720_(), 1.0f, 1.0f);
                    ((HitParticleType)WOMParticles.KATANA_SHEATHED_HIT.get()).spawnParticleWithArgument((ServerLevel)e.m_9236_(), null, null, (Entity)e, player.getOriginal());
                }
                e.m_20049_("timed_katana_slashes:" + Integer.valueOf(replacetag.split(":")[1]) + ":" + Integer.valueOf(replacetag.split(":")[4]) + ":" + (Integer.valueOf(replacetag.split(":")[3]) - 1) + ":" + Integer.valueOf(replacetag.split(":")[4]) + ":" + Float.valueOf(replacetag.split(":")[5]) + ":" + Integer.valueOf(replacetag.split(":")[6]) + ":" + Integer.valueOf(replacetag.split(":")[7]));
                break;
            }
            e.m_20137_(tag);
            break;
        }
        for (String tag : event.getEntity().m_19880_()) {
            if (!tag.contains("lunar_eclipse:")) continue;
            if (!event.getEntity().m_21023_(MobEffects.f_19610_)) break;
            int blindness_amp = event.getEntity().m_21124_(MobEffects.f_19610_).m_19564_();
            if (event.getEntity().m_21124_(MobEffects.f_19610_).m_19557_() != 1 && !event.getEntity().m_21224_()) break;
            player = event.getEntity().m_9236_().m_6815_(Integer.valueOf(tag.split(":")[1]).intValue());
            PlayerPatch playerpatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
            ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)playerpatch;
            EpicFightDamageSource epicFightDamageSource = serverPlayerPatch.getDamageSource(WOMAnimations.MOONLESS_LUNAR_ECLIPSE, InteractionHand.MAIN_HAND);
            epicFightDamageSource.setImpact(4.0f);
            epicFightDamageSource.setStunType(StunType.HOLD);
            epicFightDamageSource.addRuntimeTag(EpicFightDamageType.WEAPON_INNATE);
            EpicFightDamageSource damage = epicFightDamageSource;
            float lunar_power = Float.valueOf(tag.split(":")[2]).floatValue() + Float.valueOf(tag.split(":")[2]).floatValue() * (float)(blindness_amp / 100);
            ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123810_, event.getEntity().m_20185_(), event.getEntity().m_20186_() + 0.25 * (double)((int)((double)lunar_power * (1.0 / Math.sqrt(lunar_power / 8.0f + 1.0f)))), event.getEntity().m_20189_(), 5 * (int)((double)lunar_power * (1.0 / Math.sqrt(lunar_power / 8.0f + 1.0f))), 0.1, 0.5 * (double)((int)((double)lunar_power * (1.0 / Math.sqrt(lunar_power / 8.0f + 1.0f)))), 0.1, 0.0);
            ((ServerLevel)player.m_9236_()).m_6263_(null, event.getEntity().m_20185_(), event.getEntity().m_20186_() + 0.75, event.getEntity().m_20189_(), SoundEvents.f_11738_, event.getEntity().m_5720_(), 4.0f, 2.0f);
            int glowing_amp = 0;
            if (event.getEntity().m_21023_(MobEffects.f_19619_)) {
                glowing_amp = event.getEntity().m_21124_(MobEffects.f_19619_).m_19564_();
                event.getEntity().m_21195_(MobEffects.f_19619_);
            }
            AABB box = AABB.m_165882_((Vec3)event.getEntity().m_20182_(), (double)(10 + Math.min(40, glowing_amp)), (double)10.0, (double)(10 + Math.min(40, glowing_amp)));
            List list = event.getEntity().m_9236_().m_45933_(player, box);
            LivingEntity livingEntityLowestHP = null;
            float distance_to_stored_target = -1.0f;
            for (Entity entity : list) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (livingEntity.m_21023_(MobEffects.f_19610_)) {
                    int Aoe_blindness_amp = livingEntity.m_21124_(MobEffects.f_19610_).m_19564_();
                    int Aoe_blindness_dur = livingEntity.m_21124_(MobEffects.f_19610_).m_19557_();
                    livingEntity.m_21195_(MobEffects.f_19610_);
                    if (Aoe_blindness_dur < 80) {
                        livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 80, Aoe_blindness_amp, true, false, false));
                    }
                }
                if (livingEntity.equals((Object)event.getEntity())) {
                    if (livingEntity.m_6084_()) {
                        livingEntity.m_6469_((DamageSource)damage, lunar_power);
                        ((ServerLevel)event.getEntity().m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123747_, livingEntity.m_20185_(), livingEntity.m_20186_() + 1.0, livingEntity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                        ((ServerLevel)event.getEntity().m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123810_, livingEntity.m_20185_(), livingEntity.m_20186_() + 1.0, livingEntity.m_20189_(), 5 * (1 + (int)lunar_power / 10), 0.5 * (double)(1 + (int)lunar_power / 20), 0.5 * (double)(1 + (int)lunar_power / 20), 0.5 * (double)(1 + (int)lunar_power / 20), 0.0);
                    }
                } else if (!(livingEntity instanceof Animal) && livingEntity.m_6084_() && !(livingEntity instanceof Npc)) {
                    if (livingEntityLowestHP == null) {
                        livingEntityLowestHP = livingEntity;
                        distance_to_stored_target = (float)Math.sqrt(Math.pow(livingEntity.m_20185_() - event.getEntity().m_20185_(), 2.0) + Math.pow(livingEntity.m_20189_() - event.getEntity().m_20189_(), 2.0) + Math.pow(livingEntity.m_20186_() - event.getEntity().m_20186_(), 2.0));
                    } else {
                        float distance_to_current_target = (float)Math.sqrt(Math.pow(livingEntity.m_20185_() - event.getEntity().m_20185_(), 2.0) + Math.pow(livingEntity.m_20189_() - event.getEntity().m_20189_(), 2.0) + Math.pow(livingEntity.m_20186_() - event.getEntity().m_20186_(), 2.0));
                        if (distance_to_current_target < distance_to_stored_target) {
                            livingEntityLowestHP = livingEntity;
                            distance_to_stored_target = distance_to_current_target;
                        }
                    }
                }
                if (serverPlayerPatch == null) continue;
                serverPlayerPatch.getEventListener().triggerEvents(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, (PlayerEvent)new DealtDamageEvent(serverPlayerPatch, livingEntity, epicFightDamageSource, lunar_power));
            }
            if (event.getEntity().m_21224_() && livingEntityLowestHP != null) {
                String replacetag = new String(tag);
                livingEntityLowestHP.m_20049_(replacetag.split(":")[0] + ":" + replacetag.split(":")[1] + ":" + lunar_power * 0.95f);
                int lowestHP_blindness_amp = 0;
                int lowestHP_glowing_amp = 0;
                if (livingEntityLowestHP.m_21023_(MobEffects.f_19610_)) {
                    lowestHP_blindness_amp = livingEntityLowestHP.m_21124_(MobEffects.f_19610_).m_19564_();
                    livingEntityLowestHP.m_21195_(MobEffects.f_19610_);
                }
                if (livingEntityLowestHP.m_21023_(MobEffects.f_19619_)) {
                    lowestHP_glowing_amp = livingEntityLowestHP.m_21124_(MobEffects.f_19619_).m_19564_();
                    if (lowestHP_glowing_amp < glowing_amp) {
                        livingEntityLowestHP.m_21195_(MobEffects.f_19619_);
                        livingEntityLowestHP.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 5, glowing_amp, true, false, false));
                    } else {
                        livingEntityLowestHP.m_21195_(MobEffects.f_19619_);
                        livingEntityLowestHP.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 5, lowestHP_glowing_amp, true, false, false));
                    }
                } else if (glowing_amp > 0) {
                    livingEntityLowestHP.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 5, glowing_amp, true, false, false));
                }
                livingEntityLowestHP.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 3, lowestHP_blindness_amp, true, false, false));
            }
            event.getEntity().m_21195_(MobEffects.f_19610_);
            event.getEntity().m_19880_().remove(tag);
            break;
        }
    }

    @SubscribeEvent
    public static void onleaveEvent(EntityLeaveLevelEvent event) {
        Entity e = event.getEntity();
        if (e instanceof Player) {
            Player p = (Player)e;
            for (String tag : p.m_19880_()) {
                if (!tag.contains("wom_health_fix:")) continue;
                p.m_19880_().remove(tag);
                break;
            }
            if (p.m_6084_()) {
                p.m_20049_("wom_health_fix:" + p.m_21223_());
            }
        }
    }

    @SubscribeEvent
    public static void onDisconectEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        Player e = event.getEntity();
        if (e instanceof Player) {
            Player p = e;
            for (String tag : p.m_19880_()) {
                if (!tag.contains("wom_health_fix:")) continue;
                p.m_19880_().remove(tag);
                break;
            }
            if (p.m_6084_()) {
                p.m_20049_("wom_health_fix:" + p.m_21223_());
            }
        }
    }
}

